/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.services.entityresolution.model.UniqueIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteUniqueIdRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, BatchDeleteUniqueIdRequest> {
    private static final SdkField<String> INPUT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputSource").getter(BatchDeleteUniqueIdRequest.getter(BatchDeleteUniqueIdRequest::inputSource)).setter(BatchDeleteUniqueIdRequest.setter(Builder::inputSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("inputSource").build()}).build();
    private static final SdkField<List<String>> UNIQUE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("uniqueIds").getter(BatchDeleteUniqueIdRequest.getter(BatchDeleteUniqueIdRequest::uniqueIds)).setter(BatchDeleteUniqueIdRequest.setter(Builder::uniqueIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("uniqueIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowName").getter(BatchDeleteUniqueIdRequest.getter(BatchDeleteUniqueIdRequest::workflowName)).setter(BatchDeleteUniqueIdRequest.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SOURCE_FIELD, UNIQUE_IDS_FIELD, WORKFLOW_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inputSource", INPUT_SOURCE_FIELD);
            this.put("uniqueIds", UNIQUE_IDS_FIELD);
            this.put("workflowName", WORKFLOW_NAME_FIELD);
        }
    });
    private final String inputSource;
    private final List<String> uniqueIds;
    private final String workflowName;

    private BatchDeleteUniqueIdRequest(BuilderImpl builder) {
        super(builder);
        this.inputSource = builder.inputSource;
        this.uniqueIds = builder.uniqueIds;
        this.workflowName = builder.workflowName;
    }

    public final String inputSource() {
        return this.inputSource;
    }

    public final boolean hasUniqueIds() {
        return this.uniqueIds != null && !(this.uniqueIds instanceof SdkAutoConstructList);
    }

    public final List<String> uniqueIds() {
        return this.uniqueIds;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUniqueIds() ? this.uniqueIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteUniqueIdRequest)) {
            return false;
        }
        BatchDeleteUniqueIdRequest other = (BatchDeleteUniqueIdRequest)((Object)obj);
        return Objects.equals(this.inputSource(), other.inputSource()) && this.hasUniqueIds() == other.hasUniqueIds() && Objects.equals(this.uniqueIds(), other.uniqueIds()) && Objects.equals(this.workflowName(), other.workflowName());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteUniqueIdRequest").add("InputSource", (Object)this.inputSource()).add("UniqueIds", this.hasUniqueIds() ? this.uniqueIds() : null).add("WorkflowName", (Object)this.workflowName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputSource": {
                return Optional.ofNullable(clazz.cast(this.inputSource()));
            }
            case "uniqueIds": {
                return Optional.ofNullable(clazz.cast(this.uniqueIds()));
            }
            case "workflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteUniqueIdRequest, T> g) {
        return obj -> g.apply((BatchDeleteUniqueIdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private String inputSource;
        private List<String> uniqueIds = DefaultSdkAutoConstructList.getInstance();
        private String workflowName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteUniqueIdRequest model) {
            super(model);
            this.inputSource(model.inputSource);
            this.uniqueIds(model.uniqueIds);
            this.workflowName(model.workflowName);
        }

        public final String getInputSource() {
            return this.inputSource;
        }

        public final void setInputSource(String inputSource) {
            this.inputSource = inputSource;
        }

        @Override
        public final Builder inputSource(String inputSource) {
            this.inputSource = inputSource;
            return this;
        }

        public final Collection<String> getUniqueIds() {
            if (this.uniqueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.uniqueIds;
        }

        public final void setUniqueIds(Collection<String> uniqueIds) {
            this.uniqueIds = UniqueIdListCopier.copy(uniqueIds);
        }

        @Override
        public final Builder uniqueIds(Collection<String> uniqueIds) {
            this.uniqueIds = UniqueIdListCopier.copy(uniqueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uniqueIds(String ... uniqueIds) {
            this.uniqueIds(Arrays.asList(uniqueIds));
            return this;
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteUniqueIdRequest build() {
            return new BatchDeleteUniqueIdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteUniqueIdRequest> {
        public Builder inputSource(String var1);

        public Builder uniqueIds(Collection<String> var1);

        public Builder uniqueIds(String ... var1);

        public Builder workflowName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

