/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdMappingJobOutputSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdMappingJobOutputSource> {
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSArn").getter(IdMappingJobOutputSource.getter(IdMappingJobOutputSource::kmsArn)).setter(IdMappingJobOutputSource.setter(Builder::kmsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSArn").build()}).build();
    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3Path").getter(IdMappingJobOutputSource.getter(IdMappingJobOutputSource::outputS3Path)).setter(IdMappingJobOutputSource.setter(Builder::outputS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Path").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(IdMappingJobOutputSource.getter(IdMappingJobOutputSource::roleArn)).setter(IdMappingJobOutputSource.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ARN_FIELD, OUTPUT_S3_PATH_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsArn;
    private final String outputS3Path;
    private final String roleArn;

    private IdMappingJobOutputSource(BuilderImpl builder) {
        this.kmsArn = builder.kmsArn;
        this.outputS3Path = builder.outputS3Path;
        this.roleArn = builder.roleArn;
    }

    public final String kmsArn() {
        return this.kmsArn;
    }

    public final String outputS3Path() {
        return this.outputS3Path;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingJobOutputSource)) {
            return false;
        }
        IdMappingJobOutputSource other = (IdMappingJobOutputSource)obj;
        return Objects.equals(this.kmsArn(), other.kmsArn()) && Objects.equals(this.outputS3Path(), other.outputS3Path()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"IdMappingJobOutputSource").add("KMSArn", (Object)this.kmsArn()).add("OutputS3Path", (Object)this.outputS3Path()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KMSArn": {
                return Optional.ofNullable(clazz.cast(this.kmsArn()));
            }
            case "outputS3Path": {
                return Optional.ofNullable(clazz.cast(this.outputS3Path()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdMappingJobOutputSource, T> g) {
        return obj -> g.apply((IdMappingJobOutputSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsArn;
        private String outputS3Path;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingJobOutputSource model) {
            this.kmsArn(model.kmsArn);
            this.outputS3Path(model.outputS3Path);
            this.roleArn(model.roleArn);
        }

        public final String getKmsArn() {
            return this.kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final String getOutputS3Path() {
            return this.outputS3Path;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public IdMappingJobOutputSource build() {
            return new IdMappingJobOutputSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdMappingJobOutputSource> {
        public Builder kmsArn(String var1);

        public Builder outputS3Path(String var1);

        public Builder roleArn(String var1);
    }
}

