/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.IdNamespaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdNamespaceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdNamespaceSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(IdNamespaceSummary.getter(IdNamespaceSummary::createdAt)).setter(IdNamespaceSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(IdNamespaceSummary.getter(IdNamespaceSummary::description)).setter(IdNamespaceSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idNamespaceArn").getter(IdNamespaceSummary.getter(IdNamespaceSummary::idNamespaceArn)).setter(IdNamespaceSummary.setter(Builder::idNamespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceArn").build()}).build();
    private static final SdkField<String> ID_NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idNamespaceName").getter(IdNamespaceSummary.getter(IdNamespaceSummary::idNamespaceName)).setter(IdNamespaceSummary.setter(Builder::idNamespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idNamespaceName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(IdNamespaceSummary.getter(IdNamespaceSummary::typeAsString)).setter(IdNamespaceSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(IdNamespaceSummary.getter(IdNamespaceSummary::updatedAt)).setter(IdNamespaceSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_NAMESPACE_ARN_FIELD, ID_NAMESPACE_NAME_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String description;
    private final String idNamespaceArn;
    private final String idNamespaceName;
    private final String type;
    private final Instant updatedAt;

    private IdNamespaceSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.idNamespaceArn = builder.idNamespaceArn;
        this.idNamespaceName = builder.idNamespaceName;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String idNamespaceArn() {
        return this.idNamespaceArn;
    }

    public final String idNamespaceName() {
        return this.idNamespaceName;
    }

    public final IdNamespaceType type() {
        return IdNamespaceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.idNamespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.idNamespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdNamespaceSummary)) {
            return false;
        }
        IdNamespaceSummary other = (IdNamespaceSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.idNamespaceArn(), other.idNamespaceArn()) && Objects.equals(this.idNamespaceName(), other.idNamespaceName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"IdNamespaceSummary").add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("IdNamespaceArn", (Object)this.idNamespaceArn()).add("IdNamespaceName", (Object)this.idNamespaceName()).add("Type", (Object)this.typeAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "idNamespaceArn": {
                return Optional.ofNullable(clazz.cast(this.idNamespaceArn()));
            }
            case "idNamespaceName": {
                return Optional.ofNullable(clazz.cast(this.idNamespaceName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdNamespaceSummary, T> g) {
        return obj -> g.apply((IdNamespaceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String description;
        private String idNamespaceArn;
        private String idNamespaceName;
        private String type;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(IdNamespaceSummary model) {
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.idNamespaceArn(model.idNamespaceArn);
            this.idNamespaceName(model.idNamespaceName);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdNamespaceArn() {
            return this.idNamespaceArn;
        }

        public final void setIdNamespaceArn(String idNamespaceArn) {
            this.idNamespaceArn = idNamespaceArn;
        }

        @Override
        public final Builder idNamespaceArn(String idNamespaceArn) {
            this.idNamespaceArn = idNamespaceArn;
            return this;
        }

        public final String getIdNamespaceName() {
            return this.idNamespaceName;
        }

        public final void setIdNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
        }

        @Override
        public final Builder idNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IdNamespaceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public IdNamespaceSummary build() {
            return new IdNamespaceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdNamespaceSummary> {
        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder idNamespaceArn(String var1);

        public Builder idNamespaceName(String var1);

        public Builder type(String var1);

        public Builder type(IdNamespaceType var1);

        public Builder updatedAt(Instant var1);
    }
}

