/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobRunsRequest extends EmrServerlessRequest implements
        ToCopyableBuilder<ListJobRunsRequest.Builder, ListJobRunsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ListJobRunsRequest::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobRunsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListJobRunsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<Instant> CREATED_AT_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAtAfter").getter(getter(ListJobRunsRequest::createdAtAfter))
            .setter(setter(Builder::createdAtAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAtAfter").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAtBefore").getter(getter(ListJobRunsRequest::createdAtBefore))
            .setter(setter(Builder::createdAtBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAtBefore").build())
            .build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("states")
            .getter(getter(ListJobRunsRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(ListJobRunsRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CREATED_AT_AFTER_FIELD, CREATED_AT_BEFORE_FIELD, STATES_FIELD, MODE_FIELD));

    private final String applicationId;

    private final String nextToken;

    private final Integer maxResults;

    private final Instant createdAtAfter;

    private final Instant createdAtBefore;

    private final List<String> states;

    private final String mode;

    private ListJobRunsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.createdAtAfter = builder.createdAtAfter;
        this.createdAtBefore = builder.createdAtBefore;
        this.states = builder.states;
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The ID of the application for which to list the job run.
     * </p>
     * 
     * @return The ID of the application for which to list the job run.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The token for the next set of job run results.
     * </p>
     * 
     * @return The token for the next set of job run results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of job runs that can be listed.
     * </p>
     * 
     * @return The maximum number of job runs that can be listed.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The lower bound of the option to filter by creation date and time.
     * </p>
     * 
     * @return The lower bound of the option to filter by creation date and time.
     */
    public final Instant createdAtAfter() {
        return createdAtAfter;
    }

    /**
     * <p>
     * The upper bound of the option to filter by creation date and time.
     * </p>
     * 
     * @return The upper bound of the option to filter by creation date and time.
     */
    public final Instant createdAtBefore() {
        return createdAtBefore;
    }

    /**
     * <p>
     * An optional filter for job run states. Note that if this filter contains multiple states, the resulting list will
     * be grouped by the state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return An optional filter for job run states. Note that if this filter contains multiple states, the resulting
     *         list will be grouped by the state.
     */
    public final List<JobRunState> states() {
        return JobRunStateSetCopier.copyStringToEnum(states);
    }

    /**
     * For responses, this returns true if the service returned a value for the States property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional filter for job run states. Note that if this filter contains multiple states, the resulting list will
     * be grouped by the state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return An optional filter for job run states. Note that if this filter contains multiple states, the resulting
     *         list will be grouped by the state.
     */
    public final List<String> statesAsStrings() {
        return states;
    }

    /**
     * <p>
     * The mode of the job runs to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link JobRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the job runs to list.
     * @see JobRunMode
     */
    public final JobRunMode mode() {
        return JobRunMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode of the job runs to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link JobRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the job runs to list.
     * @see JobRunMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(createdAtAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdAtBefore());
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobRunsRequest)) {
            return false;
        }
        ListJobRunsRequest other = (ListJobRunsRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(createdAtAfter(), other.createdAtAfter())
                && Objects.equals(createdAtBefore(), other.createdAtBefore()) && hasStates() == other.hasStates()
                && Objects.equals(statesAsStrings(), other.statesAsStrings())
                && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobRunsRequest").add("ApplicationId", applicationId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("CreatedAtAfter", createdAtAfter())
                .add("CreatedAtBefore", createdAtBefore()).add("States", hasStates() ? statesAsStrings() : null)
                .add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "createdAtAfter":
            return Optional.ofNullable(clazz.cast(createdAtAfter()));
        case "createdAtBefore":
            return Optional.ofNullable(clazz.cast(createdAtBefore()));
        case "states":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobRunsRequest, T> g) {
        return obj -> g.apply((ListJobRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJobRunsRequest> {
        /**
         * <p>
         * The ID of the application for which to list the job run.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application for which to list the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The token for the next set of job run results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of job run results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of job runs that can be listed.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of job runs that can be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The lower bound of the option to filter by creation date and time.
         * </p>
         * 
         * @param createdAtAfter
         *        The lower bound of the option to filter by creation date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAtAfter(Instant createdAtAfter);

        /**
         * <p>
         * The upper bound of the option to filter by creation date and time.
         * </p>
         * 
         * @param createdAtBefore
         *        The upper bound of the option to filter by creation date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAtBefore(Instant createdAtBefore);

        /**
         * <p>
         * An optional filter for job run states. Note that if this filter contains multiple states, the resulting list
         * will be grouped by the state.
         * </p>
         * 
         * @param states
         *        An optional filter for job run states. Note that if this filter contains multiple states, the
         *        resulting list will be grouped by the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * An optional filter for job run states. Note that if this filter contains multiple states, the resulting list
         * will be grouped by the state.
         * </p>
         * 
         * @param states
         *        An optional filter for job run states. Note that if this filter contains multiple states, the
         *        resulting list will be grouped by the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * An optional filter for job run states. Note that if this filter contains multiple states, the resulting list
         * will be grouped by the state.
         * </p>
         * 
         * @param states
         *        An optional filter for job run states. Note that if this filter contains multiple states, the
         *        resulting list will be grouped by the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<JobRunState> states);

        /**
         * <p>
         * An optional filter for job run states. Note that if this filter contains multiple states, the resulting list
         * will be grouped by the state.
         * </p>
         * 
         * @param states
         *        An optional filter for job run states. Note that if this filter contains multiple states, the
         *        resulting list will be grouped by the state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(JobRunState... states);

        /**
         * <p>
         * The mode of the job runs to list.
         * </p>
         * 
         * @param mode
         *        The mode of the job runs to list.
         * @see JobRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of the job runs to list.
         * </p>
         * 
         * @param mode
         *        The mode of the job runs to list.
         * @see JobRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunMode
         */
        Builder mode(JobRunMode mode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrServerlessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String nextToken;

        private Integer maxResults;

        private Instant createdAtAfter;

        private Instant createdAtBefore;

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobRunsRequest model) {
            super(model);
            applicationId(model.applicationId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            createdAtAfter(model.createdAtAfter);
            createdAtBefore(model.createdAtBefore);
            statesWithStrings(model.states);
            mode(model.mode);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getCreatedAtAfter() {
            return createdAtAfter;
        }

        public final void setCreatedAtAfter(Instant createdAtAfter) {
            this.createdAtAfter = createdAtAfter;
        }

        @Override
        public final Builder createdAtAfter(Instant createdAtAfter) {
            this.createdAtAfter = createdAtAfter;
            return this;
        }

        public final Instant getCreatedAtBefore() {
            return createdAtBefore;
        }

        public final void setCreatedAtBefore(Instant createdAtBefore) {
            this.createdAtBefore = createdAtBefore;
        }

        @Override
        public final Builder createdAtBefore(Instant createdAtBefore) {
            this.createdAtBefore = createdAtBefore;
            return this;
        }

        public final Collection<String> getStates() {
            if (states instanceof SdkAutoConstructList) {
                return null;
            }
            return states;
        }

        public final void setStates(Collection<String> states) {
            this.states = JobRunStateSetCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = JobRunStateSetCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<JobRunState> states) {
            this.states = JobRunStateSetCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(JobRunState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(JobRunMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobRunsRequest build() {
            return new ListJobRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
