/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SparkSqlJobDriver
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SparkSqlJobDriver> {
    private static final SdkField<String> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryPoint").getter(SparkSqlJobDriver.getter(SparkSqlJobDriver::entryPoint)).setter(SparkSqlJobDriver.setter(Builder::entryPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build()}).build();
    private static final SdkField<String> SPARK_SQL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sparkSqlParameters").getter(SparkSqlJobDriver.getter(SparkSqlJobDriver::sparkSqlParameters)).setter(SparkSqlJobDriver.setter(Builder::sparkSqlParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkSqlParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_FIELD, SPARK_SQL_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SparkSqlJobDriver.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entryPoint;
    private final String sparkSqlParameters;

    private SparkSqlJobDriver(BuilderImpl builder) {
        this.entryPoint = builder.entryPoint;
        this.sparkSqlParameters = builder.sparkSqlParameters;
    }

    public final String entryPoint() {
        return this.entryPoint;
    }

    public final String sparkSqlParameters() {
        return this.sparkSqlParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.sparkSqlParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparkSqlJobDriver)) {
            return false;
        }
        SparkSqlJobDriver other = (SparkSqlJobDriver)obj;
        return Objects.equals(this.entryPoint(), other.entryPoint()) && Objects.equals(this.sparkSqlParameters(), other.sparkSqlParameters());
    }

    public final String toString() {
        return ToString.builder((String)"SparkSqlJobDriver").add("EntryPoint", (Object)(this.entryPoint() == null ? null : "*** Sensitive Data Redacted ***")).add("SparkSqlParameters", (Object)(this.sparkSqlParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
            case "sparkSqlParameters": {
                return Optional.ofNullable(clazz.cast(this.sparkSqlParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("entryPoint", ENTRY_POINT_FIELD);
        map.put("sparkSqlParameters", SPARK_SQL_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SparkSqlJobDriver, T> g) {
        return obj -> g.apply((SparkSqlJobDriver)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryPoint;
        private String sparkSqlParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SparkSqlJobDriver model) {
            this.entryPoint(model.entryPoint);
            this.sparkSqlParameters(model.sparkSqlParameters);
        }

        public final String getEntryPoint() {
            return this.entryPoint;
        }

        public final void setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
        }

        @Override
        public final Builder entryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public final String getSparkSqlParameters() {
            return this.sparkSqlParameters;
        }

        public final void setSparkSqlParameters(String sparkSqlParameters) {
            this.sparkSqlParameters = sparkSqlParameters;
        }

        @Override
        public final Builder sparkSqlParameters(String sparkSqlParameters) {
            this.sparkSqlParameters = sparkSqlParameters;
            return this;
        }

        public SparkSqlJobDriver build() {
            return new SparkSqlJobDriver(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SparkSqlJobDriver> {
        public Builder entryPoint(String var1);

        public Builder sparkSqlParameters(String var1);
    }
}

