/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CertificateProviderType {
    PEM("PEM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CertificateProviderType> VALUE_MAP;
    private final String value;

    private CertificateProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CertificateProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CertificateProviderType> knownValues() {
        EnumSet<CertificateProviderType> knownValues = EnumSet.allOf(CertificateProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CertificateProviderType.class, CertificateProviderType::toString);
    }
}

