/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrcontainers.model.Certificate;
import software.amazon.awssdk.services.emrcontainers.model.ConfigurationOverrides;
import software.amazon.awssdk.services.emrcontainers.model.EndpointState;
import software.amazon.awssdk.services.emrcontainers.model.FailureReason;
import software.amazon.awssdk.services.emrcontainers.model.SubnetIdsCopier;
import software.amazon.awssdk.services.emrcontainers.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Endpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Endpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Endpoint.getter(Endpoint::id)).setter(Endpoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Endpoint.getter(Endpoint::name)).setter(Endpoint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Endpoint.getter(Endpoint::arn)).setter(Endpoint.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualClusterId").getter(Endpoint.getter(Endpoint::virtualClusterId)).setter(Endpoint.setter(Builder::virtualClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualClusterId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Endpoint.getter(Endpoint::type)).setter(Endpoint.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Endpoint.getter(Endpoint::stateAsString)).setter(Endpoint.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(Endpoint.getter(Endpoint::releaseLabel)).setter(Endpoint.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(Endpoint.getter(Endpoint::executionRoleArn)).setter(Endpoint.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(Endpoint.getter(Endpoint::certificateArn)).setter(Endpoint.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<Certificate> CERTIFICATE_AUTHORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificateAuthority").getter(Endpoint.getter(Endpoint::certificateAuthority)).setter(Endpoint.setter(Builder::certificateAuthority)).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAuthority").build()}).build();
    private static final SdkField<ConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationOverrides").getter(Endpoint.getter(Endpoint::configurationOverrides)).setter(Endpoint.setter(Builder::configurationOverrides)).constructor(ConfigurationOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build()}).build();
    private static final SdkField<String> SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverUrl").getter(Endpoint.getter(Endpoint::serverUrl)).setter(Endpoint.setter(Builder::serverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverUrl").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Endpoint.getter(Endpoint::createdAt)).setter(Endpoint.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("securityGroup").getter(Endpoint.getter(Endpoint::securityGroup)).setter(Endpoint.setter(Builder::securityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroup").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(Endpoint.getter(Endpoint::subnetIds)).setter(Endpoint.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(Endpoint.getter(Endpoint::stateDetails)).setter(Endpoint.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(Endpoint.getter(Endpoint::failureReasonAsString)).setter(Endpoint.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Endpoint.getter(Endpoint::tags)).setter(Endpoint.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, VIRTUAL_CLUSTER_ID_FIELD, TYPE_FIELD, STATE_FIELD, RELEASE_LABEL_FIELD, EXECUTION_ROLE_ARN_FIELD, CERTIFICATE_ARN_FIELD, CERTIFICATE_AUTHORITY_FIELD, CONFIGURATION_OVERRIDES_FIELD, SERVER_URL_FIELD, CREATED_AT_FIELD, SECURITY_GROUP_FIELD, SUBNET_IDS_FIELD, STATE_DETAILS_FIELD, FAILURE_REASON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("virtualClusterId", VIRTUAL_CLUSTER_ID_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("state", STATE_FIELD);
            this.put("releaseLabel", RELEASE_LABEL_FIELD);
            this.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("certificateArn", CERTIFICATE_ARN_FIELD);
            this.put("certificateAuthority", CERTIFICATE_AUTHORITY_FIELD);
            this.put("configurationOverrides", CONFIGURATION_OVERRIDES_FIELD);
            this.put("serverUrl", SERVER_URL_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("securityGroup", SECURITY_GROUP_FIELD);
            this.put("subnetIds", SUBNET_IDS_FIELD);
            this.put("stateDetails", STATE_DETAILS_FIELD);
            this.put("failureReason", FAILURE_REASON_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String arn;
    private final String virtualClusterId;
    private final String type;
    private final String state;
    private final String releaseLabel;
    private final String executionRoleArn;
    private final String certificateArn;
    private final Certificate certificateAuthority;
    private final ConfigurationOverrides configurationOverrides;
    private final String serverUrl;
    private final Instant createdAt;
    private final String securityGroup;
    private final List<String> subnetIds;
    private final String stateDetails;
    private final String failureReason;
    private final Map<String, String> tags;

    private Endpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.virtualClusterId = builder.virtualClusterId;
        this.type = builder.type;
        this.state = builder.state;
        this.releaseLabel = builder.releaseLabel;
        this.executionRoleArn = builder.executionRoleArn;
        this.certificateArn = builder.certificateArn;
        this.certificateAuthority = builder.certificateAuthority;
        this.configurationOverrides = builder.configurationOverrides;
        this.serverUrl = builder.serverUrl;
        this.createdAt = builder.createdAt;
        this.securityGroup = builder.securityGroup;
        this.subnetIds = builder.subnetIds;
        this.stateDetails = builder.stateDetails;
        this.failureReason = builder.failureReason;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String virtualClusterId() {
        return this.virtualClusterId;
    }

    public final String type() {
        return this.type;
    }

    public final EndpointState state() {
        return EndpointState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    @Deprecated
    public final String certificateArn() {
        return this.certificateArn;
    }

    public final Certificate certificateAuthority() {
        return this.certificateAuthority;
    }

    public final ConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public final String serverUrl() {
        return this.serverUrl;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String securityGroup() {
        return this.securityGroup;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final FailureReason failureReason() {
        return FailureReason.fromValue(this.failureReason);
    }

    public final String failureReasonAsString() {
        return this.failureReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthority());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.virtualClusterId(), other.virtualClusterId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateAuthority(), other.certificateAuthority()) && Objects.equals(this.configurationOverrides(), other.configurationOverrides()) && Objects.equals(this.serverUrl(), other.serverUrl()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.securityGroup(), other.securityGroup()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.stateDetails(), other.stateDetails()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Endpoint").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("VirtualClusterId", (Object)this.virtualClusterId()).add("Type", (Object)this.type()).add("State", (Object)this.stateAsString()).add("ReleaseLabel", (Object)this.releaseLabel()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("CertificateArn", (Object)this.certificateArn()).add("CertificateAuthority", (Object)this.certificateAuthority()).add("ConfigurationOverrides", (Object)this.configurationOverrides()).add("ServerUrl", (Object)this.serverUrl()).add("CreatedAt", (Object)this.createdAt()).add("SecurityGroup", (Object)this.securityGroup()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("StateDetails", (Object)this.stateDetails()).add("FailureReason", (Object)this.failureReasonAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "virtualClusterId": {
                return Optional.ofNullable(clazz.cast(this.virtualClusterId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateAuthority": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthority()));
            }
            case "configurationOverrides": {
                return Optional.ofNullable(clazz.cast(this.configurationOverrides()));
            }
            case "serverUrl": {
                return Optional.ofNullable(clazz.cast(this.serverUrl()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "securityGroup": {
                return Optional.ofNullable(clazz.cast(this.securityGroup()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReasonAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String virtualClusterId;
        private String type;
        private String state;
        private String releaseLabel;
        private String executionRoleArn;
        private String certificateArn;
        private Certificate certificateAuthority;
        private ConfigurationOverrides configurationOverrides;
        private String serverUrl;
        private Instant createdAt;
        private String securityGroup;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String stateDetails;
        private String failureReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.virtualClusterId(model.virtualClusterId);
            this.type(model.type);
            this.state(model.state);
            this.releaseLabel(model.releaseLabel);
            this.executionRoleArn(model.executionRoleArn);
            this.certificateArn(model.certificateArn);
            this.certificateAuthority(model.certificateAuthority);
            this.configurationOverrides(model.configurationOverrides);
            this.serverUrl(model.serverUrl);
            this.createdAt(model.createdAt);
            this.securityGroup(model.securityGroup);
            this.subnetIds(model.subnetIds);
            this.stateDetails(model.stateDetails);
            this.failureReason(model.failureReason);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getVirtualClusterId() {
            return this.virtualClusterId;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EndpointState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        @Deprecated
        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Deprecated
        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        @Deprecated
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final Certificate.Builder getCertificateAuthority() {
            return this.certificateAuthority != null ? this.certificateAuthority.toBuilder() : null;
        }

        public final void setCertificateAuthority(Certificate.BuilderImpl certificateAuthority) {
            this.certificateAuthority = certificateAuthority != null ? certificateAuthority.build() : null;
        }

        @Override
        public final Builder certificateAuthority(Certificate certificateAuthority) {
            this.certificateAuthority = certificateAuthority;
            return this;
        }

        public final ConfigurationOverrides.Builder getConfigurationOverrides() {
            return this.configurationOverrides != null ? this.configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(ConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final String getServerUrl() {
            return this.serverUrl;
        }

        public final void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Override
        public final Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getSecurityGroup() {
            return this.securityGroup;
        }

        public final void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        @Override
        public final Builder securityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(FailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Endpoint> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder virtualClusterId(String var1);

        public Builder type(String var1);

        public Builder state(String var1);

        public Builder state(EndpointState var1);

        public Builder releaseLabel(String var1);

        public Builder executionRoleArn(String var1);

        @Deprecated
        public Builder certificateArn(String var1);

        public Builder certificateAuthority(Certificate var1);

        default public Builder certificateAuthority(Consumer<Certificate.Builder> certificateAuthority) {
            return this.certificateAuthority((Certificate)((Certificate.Builder)Certificate.builder().applyMutation(certificateAuthority)).build());
        }

        public Builder configurationOverrides(ConfigurationOverrides var1);

        default public Builder configurationOverrides(Consumer<ConfigurationOverrides.Builder> configurationOverrides) {
            return this.configurationOverrides((ConfigurationOverrides)((ConfigurationOverrides.Builder)ConfigurationOverrides.builder().applyMutation(configurationOverrides)).build());
        }

        public Builder serverUrl(String var1);

        public Builder createdAt(Instant var1);

        public Builder securityGroup(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder stateDetails(String var1);

        public Builder failureReason(String var1);

        public Builder failureReason(FailureReason var1);

        public Builder tags(Map<String, String> var1);
    }
}

