/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emrcontainers.model.EmrContainersResponse;
import software.amazon.awssdk.services.emrcontainers.model.JobTemplate;
import software.amazon.awssdk.services.emrcontainers.model.JobTemplatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobTemplatesResponse
extends EmrContainersResponse
implements ToCopyableBuilder<Builder, ListJobTemplatesResponse> {
    private static final SdkField<List<JobTemplate>> TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("templates").getter(ListJobTemplatesResponse.getter(ListJobTemplatesResponse::templates)).setter(ListJobTemplatesResponse.setter(Builder::templates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobTemplatesResponse.getter(ListJobTemplatesResponse::nextToken)).setter(ListJobTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("templates", TEMPLATES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<JobTemplate> templates;
    private final String nextToken;

    private ListJobTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templates = builder.templates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTemplates() {
        return this.templates != null && !(this.templates instanceof SdkAutoConstructList);
    }

    public final List<JobTemplate> templates() {
        return this.templates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplates() ? this.templates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobTemplatesResponse)) {
            return false;
        }
        ListJobTemplatesResponse other = (ListJobTemplatesResponse)((Object)obj);
        return this.hasTemplates() == other.hasTemplates() && Objects.equals(this.templates(), other.templates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobTemplatesResponse").add("Templates", this.hasTemplates() ? this.templates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templates": {
                return Optional.ofNullable(clazz.cast(this.templates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListJobTemplatesResponse, T> g) {
        return obj -> g.apply((ListJobTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrContainersResponse.BuilderImpl
    implements Builder {
        private List<JobTemplate> templates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobTemplatesResponse model) {
            super(model);
            this.templates(model.templates);
            this.nextToken(model.nextToken);
        }

        public final List<JobTemplate.Builder> getTemplates() {
            List<JobTemplate.Builder> result = JobTemplatesCopier.copyToBuilder(this.templates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplates(Collection<JobTemplate.BuilderImpl> templates) {
            this.templates = JobTemplatesCopier.copyFromBuilder(templates);
        }

        @Override
        public final Builder templates(Collection<JobTemplate> templates) {
            this.templates = JobTemplatesCopier.copy(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(JobTemplate ... templates) {
            this.templates(Arrays.asList(templates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(Consumer<JobTemplate.Builder> ... templates) {
            this.templates(Stream.of(templates).map(c -> (JobTemplate)((JobTemplate.Builder)JobTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJobTemplatesResponse build() {
            return new ListJobTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrContainersResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobTemplatesResponse> {
        public Builder templates(Collection<JobTemplate> var1);

        public Builder templates(JobTemplate ... var1);

        public Builder templates(Consumer<JobTemplate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

