/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrcontainers.EmrContainersClient;
import software.amazon.awssdk.services.emrcontainers.internal.UserAgentUtils;
import software.amazon.awssdk.services.emrcontainers.model.ListSecurityConfigurationsRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListSecurityConfigurationsResponse;
import software.amazon.awssdk.services.emrcontainers.model.SecurityConfiguration;

public class ListSecurityConfigurationsIterable
implements SdkIterable<ListSecurityConfigurationsResponse> {
    private final EmrContainersClient client;
    private final ListSecurityConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityConfigurationsIterable(EmrContainersClient client, ListSecurityConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityConfigurationsResponseFetcher();
    }

    public Iterator<ListSecurityConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityConfiguration> securityConfigurations() {
        Function<ListSecurityConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityConfigurations() != null) {
                return response.securityConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityConfigurationsResponseFetcher
    implements SyncPageFetcher<ListSecurityConfigurationsResponse> {
        private ListSecurityConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityConfigurationsResponse nextPage(ListSecurityConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityConfigurationsIterable.this.client.listSecurityConfigurations(ListSecurityConfigurationsIterable.this.firstRequest);
            }
            return ListSecurityConfigurationsIterable.this.client.listSecurityConfigurations((ListSecurityConfigurationsRequest)((Object)ListSecurityConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

