/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrcontainers.EmrContainersClient;
import software.amazon.awssdk.services.emrcontainers.internal.UserAgentUtils;
import software.amazon.awssdk.services.emrcontainers.model.ListVirtualClustersRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListVirtualClustersResponse;
import software.amazon.awssdk.services.emrcontainers.model.VirtualCluster;

public class ListVirtualClustersIterable
implements SdkIterable<ListVirtualClustersResponse> {
    private final EmrContainersClient client;
    private final ListVirtualClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVirtualClustersIterable(EmrContainersClient client, ListVirtualClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVirtualClustersResponseFetcher();
    }

    public Iterator<ListVirtualClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VirtualCluster> virtualClusters() {
        Function<ListVirtualClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualClusters() != null) {
                return response.virtualClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVirtualClustersResponseFetcher
    implements SyncPageFetcher<ListVirtualClustersResponse> {
        private ListVirtualClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVirtualClustersResponse nextPage(ListVirtualClustersResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualClustersIterable.this.client.listVirtualClusters(ListVirtualClustersIterable.this.firstRequest);
            }
            return ListVirtualClustersIterable.this.client.listVirtualClusters((ListVirtualClustersRequest)((Object)ListVirtualClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

