/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrcontainers.EmrContainersClient;
import software.amazon.awssdk.services.emrcontainers.internal.UserAgentUtils;
import software.amazon.awssdk.services.emrcontainers.model.JobTemplate;
import software.amazon.awssdk.services.emrcontainers.model.ListJobTemplatesRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListJobTemplatesResponse;

public class ListJobTemplatesIterable
implements SdkIterable<ListJobTemplatesResponse> {
    private final EmrContainersClient client;
    private final ListJobTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListJobTemplatesIterable(EmrContainersClient client, ListJobTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListJobTemplatesResponseFetcher();
    }

    public Iterator<ListJobTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobTemplate> templates() {
        Function<ListJobTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templates() != null) {
                return response.templates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListJobTemplatesResponseFetcher
    implements SyncPageFetcher<ListJobTemplatesResponse> {
        private ListJobTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListJobTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListJobTemplatesResponse nextPage(ListJobTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListJobTemplatesIterable.this.client.listJobTemplates(ListJobTemplatesIterable.this.firstRequest);
            }
            return ListJobTemplatesIterable.this.client.listJobTemplates((ListJobTemplatesRequest)((Object)ListJobTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

