/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.ParametricCloudWatchMonitoringConfiguration;
import software.amazon.awssdk.services.emrcontainers.model.ParametricS3MonitoringConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParametricMonitoringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParametricMonitoringConfiguration> {
    private static final SdkField<String> PERSISTENT_APP_UI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("persistentAppUI").getter(ParametricMonitoringConfiguration.getter(ParametricMonitoringConfiguration::persistentAppUI)).setter(ParametricMonitoringConfiguration.setter(Builder::persistentAppUI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persistentAppUI").build()}).build();
    private static final SdkField<ParametricCloudWatchMonitoringConfiguration> CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchMonitoringConfiguration").getter(ParametricMonitoringConfiguration.getter(ParametricMonitoringConfiguration::cloudWatchMonitoringConfiguration)).setter(ParametricMonitoringConfiguration.setter(Builder::cloudWatchMonitoringConfiguration)).constructor(ParametricCloudWatchMonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchMonitoringConfiguration").build()}).build();
    private static final SdkField<ParametricS3MonitoringConfiguration> S3_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3MonitoringConfiguration").getter(ParametricMonitoringConfiguration.getter(ParametricMonitoringConfiguration::s3MonitoringConfiguration)).setter(ParametricMonitoringConfiguration.setter(Builder::s3MonitoringConfiguration)).constructor(ParametricS3MonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3MonitoringConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSISTENT_APP_UI_FIELD, CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD, S3_MONITORING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String persistentAppUI;
    private final ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;
    private final ParametricS3MonitoringConfiguration s3MonitoringConfiguration;

    private ParametricMonitoringConfiguration(BuilderImpl builder) {
        this.persistentAppUI = builder.persistentAppUI;
        this.cloudWatchMonitoringConfiguration = builder.cloudWatchMonitoringConfiguration;
        this.s3MonitoringConfiguration = builder.s3MonitoringConfiguration;
    }

    public final String persistentAppUI() {
        return this.persistentAppUI;
    }

    public final ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration() {
        return this.cloudWatchMonitoringConfiguration;
    }

    public final ParametricS3MonitoringConfiguration s3MonitoringConfiguration() {
        return this.s3MonitoringConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentAppUI());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchMonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3MonitoringConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParametricMonitoringConfiguration)) {
            return false;
        }
        ParametricMonitoringConfiguration other = (ParametricMonitoringConfiguration)obj;
        return Objects.equals(this.persistentAppUI(), other.persistentAppUI()) && Objects.equals(this.cloudWatchMonitoringConfiguration(), other.cloudWatchMonitoringConfiguration()) && Objects.equals(this.s3MonitoringConfiguration(), other.s3MonitoringConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ParametricMonitoringConfiguration").add("PersistentAppUI", (Object)this.persistentAppUI()).add("CloudWatchMonitoringConfiguration", (Object)this.cloudWatchMonitoringConfiguration()).add("S3MonitoringConfiguration", (Object)this.s3MonitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "persistentAppUI": {
                return Optional.ofNullable(clazz.cast(this.persistentAppUI()));
            }
            case "cloudWatchMonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMonitoringConfiguration()));
            }
            case "s3MonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3MonitoringConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParametricMonitoringConfiguration, T> g) {
        return obj -> g.apply((ParametricMonitoringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String persistentAppUI;
        private ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;
        private ParametricS3MonitoringConfiguration s3MonitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ParametricMonitoringConfiguration model) {
            this.persistentAppUI(model.persistentAppUI);
            this.cloudWatchMonitoringConfiguration(model.cloudWatchMonitoringConfiguration);
            this.s3MonitoringConfiguration(model.s3MonitoringConfiguration);
        }

        public final String getPersistentAppUI() {
            return this.persistentAppUI;
        }

        public final void setPersistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
        }

        @Override
        public final Builder persistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
            return this;
        }

        public final ParametricCloudWatchMonitoringConfiguration.Builder getCloudWatchMonitoringConfiguration() {
            return this.cloudWatchMonitoringConfiguration != null ? this.cloudWatchMonitoringConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchMonitoringConfiguration(ParametricCloudWatchMonitoringConfiguration.BuilderImpl cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration != null ? cloudWatchMonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchMonitoringConfiguration(ParametricCloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration;
            return this;
        }

        public final ParametricS3MonitoringConfiguration.Builder getS3MonitoringConfiguration() {
            return this.s3MonitoringConfiguration != null ? this.s3MonitoringConfiguration.toBuilder() : null;
        }

        public final void setS3MonitoringConfiguration(ParametricS3MonitoringConfiguration.BuilderImpl s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration != null ? s3MonitoringConfiguration.build() : null;
        }

        @Override
        public final Builder s3MonitoringConfiguration(ParametricS3MonitoringConfiguration s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration;
            return this;
        }

        public ParametricMonitoringConfiguration build() {
            return new ParametricMonitoringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParametricMonitoringConfiguration> {
        public Builder persistentAppUI(String var1);

        public Builder cloudWatchMonitoringConfiguration(ParametricCloudWatchMonitoringConfiguration var1);

        default public Builder cloudWatchMonitoringConfiguration(Consumer<ParametricCloudWatchMonitoringConfiguration.Builder> cloudWatchMonitoringConfiguration) {
            return this.cloudWatchMonitoringConfiguration((ParametricCloudWatchMonitoringConfiguration)((ParametricCloudWatchMonitoringConfiguration.Builder)ParametricCloudWatchMonitoringConfiguration.builder().applyMutation(cloudWatchMonitoringConfiguration)).build());
        }

        public Builder s3MonitoringConfiguration(ParametricS3MonitoringConfiguration var1);

        default public Builder s3MonitoringConfiguration(Consumer<ParametricS3MonitoringConfiguration.Builder> s3MonitoringConfiguration) {
            return this.s3MonitoringConfiguration((ParametricS3MonitoringConfiguration)((ParametricS3MonitoringConfiguration.Builder)ParametricS3MonitoringConfiguration.builder().applyMutation(s3MonitoringConfiguration)).build());
        }
    }
}

