/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.CloudWatchMonitoringConfiguration;
import software.amazon.awssdk.services.emrcontainers.model.PersistentAppUI;
import software.amazon.awssdk.services.emrcontainers.model.S3MonitoringConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringConfiguration> {
    private static final SdkField<String> PERSISTENT_APP_UI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("persistentAppUI").getter(MonitoringConfiguration.getter(MonitoringConfiguration::persistentAppUIAsString)).setter(MonitoringConfiguration.setter(Builder::persistentAppUI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("persistentAppUI").build()}).build();
    private static final SdkField<CloudWatchMonitoringConfiguration> CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchMonitoringConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::cloudWatchMonitoringConfiguration)).setter(MonitoringConfiguration.setter(Builder::cloudWatchMonitoringConfiguration)).constructor(CloudWatchMonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchMonitoringConfiguration").build()}).build();
    private static final SdkField<S3MonitoringConfiguration> S3_MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3MonitoringConfiguration").getter(MonitoringConfiguration.getter(MonitoringConfiguration::s3MonitoringConfiguration)).setter(MonitoringConfiguration.setter(Builder::s3MonitoringConfiguration)).constructor(S3MonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3MonitoringConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSISTENT_APP_UI_FIELD, CLOUD_WATCH_MONITORING_CONFIGURATION_FIELD, S3_MONITORING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String persistentAppUI;
    private final CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;
    private final S3MonitoringConfiguration s3MonitoringConfiguration;

    private MonitoringConfiguration(BuilderImpl builder) {
        this.persistentAppUI = builder.persistentAppUI;
        this.cloudWatchMonitoringConfiguration = builder.cloudWatchMonitoringConfiguration;
        this.s3MonitoringConfiguration = builder.s3MonitoringConfiguration;
    }

    public final PersistentAppUI persistentAppUI() {
        return PersistentAppUI.fromValue(this.persistentAppUI);
    }

    public final String persistentAppUIAsString() {
        return this.persistentAppUI;
    }

    public final CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration() {
        return this.cloudWatchMonitoringConfiguration;
    }

    public final S3MonitoringConfiguration s3MonitoringConfiguration() {
        return this.s3MonitoringConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.persistentAppUIAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchMonitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3MonitoringConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfiguration)) {
            return false;
        }
        MonitoringConfiguration other = (MonitoringConfiguration)obj;
        return Objects.equals(this.persistentAppUIAsString(), other.persistentAppUIAsString()) && Objects.equals(this.cloudWatchMonitoringConfiguration(), other.cloudWatchMonitoringConfiguration()) && Objects.equals(this.s3MonitoringConfiguration(), other.s3MonitoringConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringConfiguration").add("PersistentAppUI", (Object)this.persistentAppUIAsString()).add("CloudWatchMonitoringConfiguration", (Object)this.cloudWatchMonitoringConfiguration()).add("S3MonitoringConfiguration", (Object)this.s3MonitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "persistentAppUI": {
                return Optional.ofNullable(clazz.cast(this.persistentAppUIAsString()));
            }
            case "cloudWatchMonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMonitoringConfiguration()));
            }
            case "s3MonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3MonitoringConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfiguration, T> g) {
        return obj -> g.apply((MonitoringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String persistentAppUI;
        private CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration;
        private S3MonitoringConfiguration s3MonitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfiguration model) {
            this.persistentAppUI(model.persistentAppUI);
            this.cloudWatchMonitoringConfiguration(model.cloudWatchMonitoringConfiguration);
            this.s3MonitoringConfiguration(model.s3MonitoringConfiguration);
        }

        public final String getPersistentAppUI() {
            return this.persistentAppUI;
        }

        public final void setPersistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
        }

        @Override
        @Transient
        public final Builder persistentAppUI(String persistentAppUI) {
            this.persistentAppUI = persistentAppUI;
            return this;
        }

        @Override
        @Transient
        public final Builder persistentAppUI(PersistentAppUI persistentAppUI) {
            this.persistentAppUI(persistentAppUI == null ? null : persistentAppUI.toString());
            return this;
        }

        public final CloudWatchMonitoringConfiguration.Builder getCloudWatchMonitoringConfiguration() {
            return this.cloudWatchMonitoringConfiguration != null ? this.cloudWatchMonitoringConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration.BuilderImpl cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration != null ? cloudWatchMonitoringConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration cloudWatchMonitoringConfiguration) {
            this.cloudWatchMonitoringConfiguration = cloudWatchMonitoringConfiguration;
            return this;
        }

        public final S3MonitoringConfiguration.Builder getS3MonitoringConfiguration() {
            return this.s3MonitoringConfiguration != null ? this.s3MonitoringConfiguration.toBuilder() : null;
        }

        public final void setS3MonitoringConfiguration(S3MonitoringConfiguration.BuilderImpl s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration != null ? s3MonitoringConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder s3MonitoringConfiguration(S3MonitoringConfiguration s3MonitoringConfiguration) {
            this.s3MonitoringConfiguration = s3MonitoringConfiguration;
            return this;
        }

        public MonitoringConfiguration build() {
            return new MonitoringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringConfiguration> {
        public Builder persistentAppUI(String var1);

        public Builder persistentAppUI(PersistentAppUI var1);

        public Builder cloudWatchMonitoringConfiguration(CloudWatchMonitoringConfiguration var1);

        default public Builder cloudWatchMonitoringConfiguration(Consumer<CloudWatchMonitoringConfiguration.Builder> cloudWatchMonitoringConfiguration) {
            return this.cloudWatchMonitoringConfiguration((CloudWatchMonitoringConfiguration)((CloudWatchMonitoringConfiguration.Builder)CloudWatchMonitoringConfiguration.builder().applyMutation(cloudWatchMonitoringConfiguration)).build());
        }

        public Builder s3MonitoringConfiguration(S3MonitoringConfiguration var1);

        default public Builder s3MonitoringConfiguration(Consumer<S3MonitoringConfiguration.Builder> s3MonitoringConfiguration) {
            return this.s3MonitoringConfiguration((S3MonitoringConfiguration)((S3MonitoringConfiguration.Builder)S3MonitoringConfiguration.builder().applyMutation(s3MonitoringConfiguration)).build());
        }
    }
}

