/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ContainerProviderType {
    EKS("EKS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ContainerProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ContainerProviderType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerProviderType> knownValues() {
        return Stream.of(ContainerProviderType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

