/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrcontainers.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobRunsRequest extends EmrContainersRequest implements
        ToCopyableBuilder<ListJobRunsRequest.Builder, ListJobRunsRequest> {
    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualClusterId").getter(getter(ListJobRunsRequest::virtualClusterId))
            .setter(setter(Builder::virtualClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualClusterId").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdBefore")
            .getter(getter(ListJobRunsRequest::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAfter")
            .getter(getter(ListJobRunsRequest::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ListJobRunsRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("states")
            .getter(getter(ListJobRunsRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListJobRunsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobRunsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_CLUSTER_ID_FIELD,
            CREATED_BEFORE_FIELD, CREATED_AFTER_FIELD, NAME_FIELD, STATES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String virtualClusterId;

    private final Instant createdBefore;

    private final Instant createdAfter;

    private final String name;

    private final List<String> states;

    private final Integer maxResults;

    private final String nextToken;

    private ListJobRunsRequest(BuilderImpl builder) {
        super(builder);
        this.virtualClusterId = builder.virtualClusterId;
        this.createdBefore = builder.createdBefore;
        this.createdAfter = builder.createdAfter;
        this.name = builder.name;
        this.states = builder.states;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the virtual cluster for which to list the job run.
     * </p>
     * 
     * @return The ID of the virtual cluster for which to list the job run.
     */
    public final String virtualClusterId() {
        return virtualClusterId;
    }

    /**
     * <p>
     * The date and time before which the job runs were submitted.
     * </p>
     * 
     * @return The date and time before which the job runs were submitted.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * The date and time after which the job runs were submitted.
     * </p>
     * 
     * @return The date and time after which the job runs were submitted.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * The name of the job run.
     * </p>
     * 
     * @return The name of the job run.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The states of the job run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The states of the job run.
     */
    public final List<JobRunState> states() {
        return JobRunStatesCopier.copyStringToEnum(states);
    }

    /**
     * Returns true if the States property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The states of the job run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The states of the job run.
     */
    public final List<String> statesAsStrings() {
        return states;
    }

    /**
     * <p>
     * The maximum number of job runs that can be listed.
     * </p>
     * 
     * @return The maximum number of job runs that can be listed.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of job runs to return.
     * </p>
     * 
     * @return The token for the next set of job runs to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobRunsRequest)) {
            return false;
        }
        ListJobRunsRequest other = (ListJobRunsRequest) obj;
        return Objects.equals(virtualClusterId(), other.virtualClusterId())
                && Objects.equals(createdBefore(), other.createdBefore()) && Objects.equals(createdAfter(), other.createdAfter())
                && Objects.equals(name(), other.name()) && hasStates() == other.hasStates()
                && Objects.equals(statesAsStrings(), other.statesAsStrings()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobRunsRequest").add("VirtualClusterId", virtualClusterId())
                .add("CreatedBefore", createdBefore()).add("CreatedAfter", createdAfter()).add("Name", name())
                .add("States", hasStates() ? statesAsStrings() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualClusterId":
            return Optional.ofNullable(clazz.cast(virtualClusterId()));
        case "createdBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "createdAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "states":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobRunsRequest, T> g) {
        return obj -> g.apply((ListJobRunsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrContainersRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJobRunsRequest> {
        /**
         * <p>
         * The ID of the virtual cluster for which to list the job run.
         * </p>
         * 
         * @param virtualClusterId
         *        The ID of the virtual cluster for which to list the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualClusterId(String virtualClusterId);

        /**
         * <p>
         * The date and time before which the job runs were submitted.
         * </p>
         * 
         * @param createdBefore
         *        The date and time before which the job runs were submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * The date and time after which the job runs were submitted.
         * </p>
         * 
         * @param createdAfter
         *        The date and time after which the job runs were submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * The name of the job run.
         * </p>
         * 
         * @param name
         *        The name of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The states of the job run.
         * </p>
         * 
         * @param states
         *        The states of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * The states of the job run.
         * </p>
         * 
         * @param states
         *        The states of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * The states of the job run.
         * </p>
         * 
         * @param states
         *        The states of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<JobRunState> states);

        /**
         * <p>
         * The states of the job run.
         * </p>
         * 
         * @param states
         *        The states of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(JobRunState... states);

        /**
         * <p>
         * The maximum number of job runs that can be listed.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of job runs that can be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of job runs to return.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of job runs to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrContainersRequest.BuilderImpl implements Builder {
        private String virtualClusterId;

        private Instant createdBefore;

        private Instant createdAfter;

        private String name;

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobRunsRequest model) {
            super(model);
            virtualClusterId(model.virtualClusterId);
            createdBefore(model.createdBefore);
            createdAfter(model.createdAfter);
            name(model.name);
            statesWithStrings(model.states);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getVirtualClusterId() {
            return virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getStates() {
            if (states instanceof SdkAutoConstructList) {
                return null;
            }
            return states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = JobRunStatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<JobRunState> states) {
            this.states = JobRunStatesCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(JobRunState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final void setStates(Collection<String> states) {
            this.states = JobRunStatesCopier.copy(states);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobRunsRequest build() {
            return new ListJobRunsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
