/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrcontainers.model.ConfigurationOverrides;
import software.amazon.awssdk.services.emrcontainers.model.FailureReason;
import software.amazon.awssdk.services.emrcontainers.model.JobDriver;
import software.amazon.awssdk.services.emrcontainers.model.JobRunState;
import software.amazon.awssdk.services.emrcontainers.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobRun> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(JobRun.getter(JobRun::id)).setter(JobRun.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(JobRun.getter(JobRun::name)).setter(JobRun.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VIRTUAL_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualClusterId").getter(JobRun.getter(JobRun::virtualClusterId)).setter(JobRun.setter(Builder::virtualClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualClusterId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(JobRun.getter(JobRun::arn)).setter(JobRun.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(JobRun.getter(JobRun::stateAsString)).setter(JobRun.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(JobRun.getter(JobRun::clientToken)).setter(JobRun.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(JobRun.getter(JobRun::executionRoleArn)).setter(JobRun.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(JobRun.getter(JobRun::releaseLabel)).setter(JobRun.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<ConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationOverrides").getter(JobRun.getter(JobRun::configurationOverrides)).setter(JobRun.setter(Builder::configurationOverrides)).constructor(ConfigurationOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build()}).build();
    private static final SdkField<JobDriver> JOB_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDriver").getter(JobRun.getter(JobRun::jobDriver)).setter(JobRun.setter(Builder::jobDriver)).constructor(JobDriver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDriver").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(JobRun.getter(JobRun::createdAt)).setter(JobRun.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(JobRun.getter(JobRun::createdBy)).setter(JobRun.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("finishedAt").getter(JobRun.getter(JobRun::finishedAt)).setter(JobRun.setter(Builder::finishedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finishedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(JobRun.getter(JobRun::stateDetails)).setter(JobRun.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(JobRun.getter(JobRun::failureReasonAsString)).setter(JobRun.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(JobRun.getter(JobRun::tags)).setter(JobRun.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, VIRTUAL_CLUSTER_ID_FIELD, ARN_FIELD, STATE_FIELD, CLIENT_TOKEN_FIELD, EXECUTION_ROLE_ARN_FIELD, RELEASE_LABEL_FIELD, CONFIGURATION_OVERRIDES_FIELD, JOB_DRIVER_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, FINISHED_AT_FIELD, STATE_DETAILS_FIELD, FAILURE_REASON_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String virtualClusterId;
    private final String arn;
    private final String state;
    private final String clientToken;
    private final String executionRoleArn;
    private final String releaseLabel;
    private final ConfigurationOverrides configurationOverrides;
    private final JobDriver jobDriver;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant finishedAt;
    private final String stateDetails;
    private final String failureReason;
    private final Map<String, String> tags;

    private JobRun(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.virtualClusterId = builder.virtualClusterId;
        this.arn = builder.arn;
        this.state = builder.state;
        this.clientToken = builder.clientToken;
        this.executionRoleArn = builder.executionRoleArn;
        this.releaseLabel = builder.releaseLabel;
        this.configurationOverrides = builder.configurationOverrides;
        this.jobDriver = builder.jobDriver;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.finishedAt = builder.finishedAt;
        this.stateDetails = builder.stateDetails;
        this.failureReason = builder.failureReason;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String virtualClusterId() {
        return this.virtualClusterId;
    }

    public final String arn() {
        return this.arn;
    }

    public final JobRunState state() {
        return JobRunState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final ConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public final JobDriver jobDriver() {
        return this.jobDriver;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant finishedAt() {
        return this.finishedAt;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final FailureReason failureReason() {
        return FailureReason.fromValue(this.failureReason);
    }

    public final String failureReasonAsString() {
        return this.failureReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRun)) {
            return false;
        }
        JobRun other = (JobRun)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.virtualClusterId(), other.virtualClusterId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.configurationOverrides(), other.configurationOverrides()) && Objects.equals(this.jobDriver(), other.jobDriver()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.finishedAt(), other.finishedAt()) && Objects.equals(this.stateDetails(), other.stateDetails()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"JobRun").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("VirtualClusterId", (Object)this.virtualClusterId()).add("Arn", (Object)this.arn()).add("State", (Object)this.stateAsString()).add("ClientToken", (Object)this.clientToken()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ReleaseLabel", (Object)this.releaseLabel()).add("ConfigurationOverrides", (Object)this.configurationOverrides()).add("JobDriver", (Object)this.jobDriver()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("FinishedAt", (Object)this.finishedAt()).add("StateDetails", (Object)this.stateDetails()).add("FailureReason", (Object)this.failureReasonAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "virtualClusterId": {
                return Optional.ofNullable(clazz.cast(this.virtualClusterId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "configurationOverrides": {
                return Optional.ofNullable(clazz.cast(this.configurationOverrides()));
            }
            case "jobDriver": {
                return Optional.ofNullable(clazz.cast(this.jobDriver()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "finishedAt": {
                return Optional.ofNullable(clazz.cast(this.finishedAt()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReasonAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobRun, T> g) {
        return obj -> g.apply((JobRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String virtualClusterId;
        private String arn;
        private String state;
        private String clientToken;
        private String executionRoleArn;
        private String releaseLabel;
        private ConfigurationOverrides configurationOverrides;
        private JobDriver jobDriver;
        private Instant createdAt;
        private String createdBy;
        private Instant finishedAt;
        private String stateDetails;
        private String failureReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobRun model) {
            this.id(model.id);
            this.name(model.name);
            this.virtualClusterId(model.virtualClusterId);
            this.arn(model.arn);
            this.state(model.state);
            this.clientToken(model.clientToken);
            this.executionRoleArn(model.executionRoleArn);
            this.releaseLabel(model.releaseLabel);
            this.configurationOverrides(model.configurationOverrides);
            this.jobDriver(model.jobDriver);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.finishedAt(model.finishedAt);
            this.stateDetails(model.stateDetails);
            this.failureReason(model.failureReason);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVirtualClusterId() {
            return this.virtualClusterId;
        }

        @Override
        public final Builder virtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
            return this;
        }

        public final void setVirtualClusterId(String virtualClusterId) {
            this.virtualClusterId = virtualClusterId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        public final ConfigurationOverrides.Builder getConfigurationOverrides() {
            return this.configurationOverrides != null ? this.configurationOverrides.toBuilder() : null;
        }

        @Override
        public final Builder configurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final void setConfigurationOverrides(ConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        public final JobDriver.Builder getJobDriver() {
            return this.jobDriver != null ? this.jobDriver.toBuilder() : null;
        }

        @Override
        public final Builder jobDriver(JobDriver jobDriver) {
            this.jobDriver = jobDriver;
            return this;
        }

        public final void setJobDriver(JobDriver.BuilderImpl jobDriver) {
            this.jobDriver = jobDriver != null ? jobDriver.build() : null;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(FailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public JobRun build() {
            return new JobRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobRun> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder virtualClusterId(String var1);

        public Builder arn(String var1);

        public Builder state(String var1);

        public Builder state(JobRunState var1);

        public Builder clientToken(String var1);

        public Builder executionRoleArn(String var1);

        public Builder releaseLabel(String var1);

        public Builder configurationOverrides(ConfigurationOverrides var1);

        default public Builder configurationOverrides(Consumer<ConfigurationOverrides.Builder> configurationOverrides) {
            return this.configurationOverrides((ConfigurationOverrides)((ConfigurationOverrides.Builder)ConfigurationOverrides.builder().applyMutation(configurationOverrides)).build());
        }

        public Builder jobDriver(JobDriver var1);

        default public Builder jobDriver(Consumer<JobDriver.Builder> jobDriver) {
            return this.jobDriver((JobDriver)((JobDriver.Builder)JobDriver.builder().applyMutation(jobDriver)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder finishedAt(Instant var1);

        public Builder stateDetails(String var1);

        public Builder failureReason(String var1);

        public Builder failureReason(FailureReason var1);

        public Builder tags(Map<String, String> var1);
    }
}

