/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrcontainers.model.EksInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerInfo> {
    private static final SdkField<EksInfo> EKS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksInfo").getter(ContainerInfo.getter(ContainerInfo::eksInfo)).setter(ContainerInfo.setter(Builder::eksInfo)).constructor(EksInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final EksInfo eksInfo;

    private ContainerInfo(BuilderImpl builder) {
        this.eksInfo = builder.eksInfo;
    }

    public EksInfo eksInfo() {
        return this.eksInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInfo)) {
            return false;
        }
        ContainerInfo other = (ContainerInfo)obj;
        return Objects.equals(this.eksInfo(), other.eksInfo());
    }

    public String toString() {
        return ToString.builder((String)"ContainerInfo").add("EksInfo", (Object)this.eksInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eksInfo": {
                return Optional.ofNullable(clazz.cast(this.eksInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerInfo, T> g) {
        return obj -> g.apply((ContainerInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EksInfo eksInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerInfo model) {
            this.eksInfo(model.eksInfo);
        }

        public final EksInfo.Builder getEksInfo() {
            return this.eksInfo != null ? this.eksInfo.toBuilder() : null;
        }

        @Override
        public final Builder eksInfo(EksInfo eksInfo) {
            this.eksInfo = eksInfo;
            return this;
        }

        public final void setEksInfo(EksInfo.BuilderImpl eksInfo) {
            this.eksInfo = eksInfo != null ? eksInfo.build() : null;
        }

        public ContainerInfo build() {
            return new ContainerInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerInfo> {
        public Builder eksInfo(EksInfo var1);

        default public Builder eksInfo(Consumer<EksInfo.Builder> eksInfo) {
            return this.eksInfo((EksInfo)((EksInfo.Builder)EksInfo.builder().applyMutation(eksInfo)).build());
        }
    }
}

