/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsBlockDevice;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceListCopier;
import software.amazon.awssdk.services.emr.model.InstanceGroupStatus;
import software.amazon.awssdk.services.emr.model.InstanceGroupType;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.model.ShrinkPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceGroup> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroup.getter(InstanceGroup::id)).setter(InstanceGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroup.getter(InstanceGroup::name)).setter(InstanceGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> MARKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroup.getter(InstanceGroup::marketAsString)).setter(InstanceGroup.setter(Builder::market)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Market").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroup.getter(InstanceGroup::instanceGroupTypeAsString)).setter(InstanceGroup.setter(Builder::instanceGroupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupType").build()}).build();
    private static final SdkField<String> BID_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroup.getter(InstanceGroup::bidPrice)).setter(InstanceGroup.setter(Builder::bidPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BidPrice").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroup.getter(InstanceGroup::instanceType)).setter(InstanceGroup.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> REQUESTED_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceGroup.getter(InstanceGroup::requestedInstanceCount)).setter(InstanceGroup.setter(Builder::requestedInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedInstanceCount").build()}).build();
    private static final SdkField<Integer> RUNNING_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceGroup.getter(InstanceGroup::runningInstanceCount)).setter(InstanceGroup.setter(Builder::runningInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningInstanceCount").build()}).build();
    private static final SdkField<InstanceGroupStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceGroup.getter(InstanceGroup::status)).setter(InstanceGroup.setter(Builder::status)).constructor(InstanceGroupStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceGroup.getter(InstanceGroup::configurations)).setter(InstanceGroup.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> CONFIGURATIONS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(InstanceGroup.getter(InstanceGroup::configurationsVersion)).setter(InstanceGroup.setter(Builder::configurationsVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationsVersion").build()}).build();
    private static final SdkField<List<Configuration>> LAST_SUCCESSFULLY_APPLIED_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceGroup.getter(InstanceGroup::lastSuccessfullyAppliedConfigurations)).setter(InstanceGroup.setter(Builder::lastSuccessfullyAppliedConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfullyAppliedConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> LAST_SUCCESSFULLY_APPLIED_CONFIGURATIONS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(InstanceGroup.getter(InstanceGroup::lastSuccessfullyAppliedConfigurationsVersion)).setter(InstanceGroup.setter(Builder::lastSuccessfullyAppliedConfigurationsVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfullyAppliedConfigurationsVersion").build()}).build();
    private static final SdkField<List<EbsBlockDevice>> EBS_BLOCK_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceGroup.getter(InstanceGroup::ebsBlockDevices)).setter(InstanceGroup.setter(Builder::ebsBlockDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsBlockDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EbsBlockDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(InstanceGroup.getter(InstanceGroup::ebsOptimized)).setter(InstanceGroup.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()}).build();
    private static final SdkField<ShrinkPolicy> SHRINK_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceGroup.getter(InstanceGroup::shrinkPolicy)).setter(InstanceGroup.setter(Builder::shrinkPolicy)).constructor(ShrinkPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShrinkPolicy").build()}).build();
    private static final SdkField<AutoScalingPolicyDescription> AUTO_SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceGroup.getter(InstanceGroup::autoScalingPolicy)).setter(InstanceGroup.setter(Builder::autoScalingPolicy)).constructor(AutoScalingPolicyDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, MARKET_FIELD, INSTANCE_GROUP_TYPE_FIELD, BID_PRICE_FIELD, INSTANCE_TYPE_FIELD, REQUESTED_INSTANCE_COUNT_FIELD, RUNNING_INSTANCE_COUNT_FIELD, STATUS_FIELD, CONFIGURATIONS_FIELD, CONFIGURATIONS_VERSION_FIELD, LAST_SUCCESSFULLY_APPLIED_CONFIGURATIONS_FIELD, LAST_SUCCESSFULLY_APPLIED_CONFIGURATIONS_VERSION_FIELD, EBS_BLOCK_DEVICES_FIELD, EBS_OPTIMIZED_FIELD, SHRINK_POLICY_FIELD, AUTO_SCALING_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String market;
    private final String instanceGroupType;
    private final String bidPrice;
    private final String instanceType;
    private final Integer requestedInstanceCount;
    private final Integer runningInstanceCount;
    private final InstanceGroupStatus status;
    private final List<Configuration> configurations;
    private final Long configurationsVersion;
    private final List<Configuration> lastSuccessfullyAppliedConfigurations;
    private final Long lastSuccessfullyAppliedConfigurationsVersion;
    private final List<EbsBlockDevice> ebsBlockDevices;
    private final Boolean ebsOptimized;
    private final ShrinkPolicy shrinkPolicy;
    private final AutoScalingPolicyDescription autoScalingPolicy;

    private InstanceGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.market = builder.market;
        this.instanceGroupType = builder.instanceGroupType;
        this.bidPrice = builder.bidPrice;
        this.instanceType = builder.instanceType;
        this.requestedInstanceCount = builder.requestedInstanceCount;
        this.runningInstanceCount = builder.runningInstanceCount;
        this.status = builder.status;
        this.configurations = builder.configurations;
        this.configurationsVersion = builder.configurationsVersion;
        this.lastSuccessfullyAppliedConfigurations = builder.lastSuccessfullyAppliedConfigurations;
        this.lastSuccessfullyAppliedConfigurationsVersion = builder.lastSuccessfullyAppliedConfigurationsVersion;
        this.ebsBlockDevices = builder.ebsBlockDevices;
        this.ebsOptimized = builder.ebsOptimized;
        this.shrinkPolicy = builder.shrinkPolicy;
        this.autoScalingPolicy = builder.autoScalingPolicy;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public MarketType market() {
        return MarketType.fromValue(this.market);
    }

    public String marketAsString() {
        return this.market;
    }

    public InstanceGroupType instanceGroupType() {
        return InstanceGroupType.fromValue(this.instanceGroupType);
    }

    public String instanceGroupTypeAsString() {
        return this.instanceGroupType;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer requestedInstanceCount() {
        return this.requestedInstanceCount;
    }

    public Integer runningInstanceCount() {
        return this.runningInstanceCount;
    }

    public InstanceGroupStatus status() {
        return this.status;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public Long configurationsVersion() {
        return this.configurationsVersion;
    }

    public List<Configuration> lastSuccessfullyAppliedConfigurations() {
        return this.lastSuccessfullyAppliedConfigurations;
    }

    public Long lastSuccessfullyAppliedConfigurationsVersion() {
        return this.lastSuccessfullyAppliedConfigurationsVersion;
    }

    public List<EbsBlockDevice> ebsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public ShrinkPolicy shrinkPolicy() {
        return this.shrinkPolicy;
    }

    public AutoScalingPolicyDescription autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationsVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfullyAppliedConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfullyAppliedConfigurationsVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsBlockDevices());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.shrinkPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingPolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroup)) {
            return false;
        }
        InstanceGroup other = (InstanceGroup)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.marketAsString(), other.marketAsString()) && Objects.equals(this.instanceGroupTypeAsString(), other.instanceGroupTypeAsString()) && Objects.equals(this.bidPrice(), other.bidPrice()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.requestedInstanceCount(), other.requestedInstanceCount()) && Objects.equals(this.runningInstanceCount(), other.runningInstanceCount()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.configurationsVersion(), other.configurationsVersion()) && Objects.equals(this.lastSuccessfullyAppliedConfigurations(), other.lastSuccessfullyAppliedConfigurations()) && Objects.equals(this.lastSuccessfullyAppliedConfigurationsVersion(), other.lastSuccessfullyAppliedConfigurationsVersion()) && Objects.equals(this.ebsBlockDevices(), other.ebsBlockDevices()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.shrinkPolicy(), other.shrinkPolicy()) && Objects.equals(this.autoScalingPolicy(), other.autoScalingPolicy());
    }

    public String toString() {
        return ToString.builder((String)"InstanceGroup").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Market", (Object)this.marketAsString()).add("InstanceGroupType", (Object)this.instanceGroupTypeAsString()).add("BidPrice", (Object)this.bidPrice()).add("InstanceType", (Object)this.instanceType()).add("RequestedInstanceCount", (Object)this.requestedInstanceCount()).add("RunningInstanceCount", (Object)this.runningInstanceCount()).add("Status", (Object)this.status()).add("Configurations", this.configurations()).add("ConfigurationsVersion", (Object)this.configurationsVersion()).add("LastSuccessfullyAppliedConfigurations", this.lastSuccessfullyAppliedConfigurations()).add("LastSuccessfullyAppliedConfigurationsVersion", (Object)this.lastSuccessfullyAppliedConfigurationsVersion()).add("EbsBlockDevices", this.ebsBlockDevices()).add("EbsOptimized", (Object)this.ebsOptimized()).add("ShrinkPolicy", (Object)this.shrinkPolicy()).add("AutoScalingPolicy", (Object)this.autoScalingPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Market": {
                return Optional.ofNullable(clazz.cast(this.marketAsString()));
            }
            case "InstanceGroupType": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupTypeAsString()));
            }
            case "BidPrice": {
                return Optional.ofNullable(clazz.cast(this.bidPrice()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "RequestedInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.requestedInstanceCount()));
            }
            case "RunningInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.runningInstanceCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "ConfigurationsVersion": {
                return Optional.ofNullable(clazz.cast(this.configurationsVersion()));
            }
            case "LastSuccessfullyAppliedConfigurations": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfullyAppliedConfigurations()));
            }
            case "LastSuccessfullyAppliedConfigurationsVersion": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfullyAppliedConfigurationsVersion()));
            }
            case "EbsBlockDevices": {
                return Optional.ofNullable(clazz.cast(this.ebsBlockDevices()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "ShrinkPolicy": {
                return Optional.ofNullable(clazz.cast(this.shrinkPolicy()));
            }
            case "AutoScalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoScalingPolicy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroup, T> g) {
        return obj -> g.apply((InstanceGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String market;
        private String instanceGroupType;
        private String bidPrice;
        private String instanceType;
        private Integer requestedInstanceCount;
        private Integer runningInstanceCount;
        private InstanceGroupStatus status;
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();
        private Long configurationsVersion;
        private List<Configuration> lastSuccessfullyAppliedConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Long lastSuccessfullyAppliedConfigurationsVersion;
        private List<EbsBlockDevice> ebsBlockDevices = DefaultSdkAutoConstructList.getInstance();
        private Boolean ebsOptimized;
        private ShrinkPolicy shrinkPolicy;
        private AutoScalingPolicyDescription autoScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroup model) {
            this.id(model.id);
            this.name(model.name);
            this.market(model.market);
            this.instanceGroupType(model.instanceGroupType);
            this.bidPrice(model.bidPrice);
            this.instanceType(model.instanceType);
            this.requestedInstanceCount(model.requestedInstanceCount);
            this.runningInstanceCount(model.runningInstanceCount);
            this.status(model.status);
            this.configurations(model.configurations);
            this.configurationsVersion(model.configurationsVersion);
            this.lastSuccessfullyAppliedConfigurations(model.lastSuccessfullyAppliedConfigurations);
            this.lastSuccessfullyAppliedConfigurationsVersion(model.lastSuccessfullyAppliedConfigurationsVersion);
            this.ebsBlockDevices(model.ebsBlockDevices);
            this.ebsOptimized(model.ebsOptimized);
            this.shrinkPolicy(model.shrinkPolicy);
            this.autoScalingPolicy(model.autoScalingPolicy);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMarketAsString() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final String getInstanceGroupTypeAsString() {
            return this.instanceGroupType;
        }

        @Override
        public final Builder instanceGroupType(String instanceGroupType) {
            this.instanceGroupType = instanceGroupType;
            return this;
        }

        @Override
        public final Builder instanceGroupType(InstanceGroupType instanceGroupType) {
            this.instanceGroupType(instanceGroupType.toString());
            return this;
        }

        public final void setInstanceGroupType(String instanceGroupType) {
            this.instanceGroupType = instanceGroupType;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getRequestedInstanceCount() {
            return this.requestedInstanceCount;
        }

        @Override
        public final Builder requestedInstanceCount(Integer requestedInstanceCount) {
            this.requestedInstanceCount = requestedInstanceCount;
            return this;
        }

        public final void setRequestedInstanceCount(Integer requestedInstanceCount) {
            this.requestedInstanceCount = requestedInstanceCount;
        }

        public final Integer getRunningInstanceCount() {
            return this.runningInstanceCount;
        }

        @Override
        public final Builder runningInstanceCount(Integer runningInstanceCount) {
            this.runningInstanceCount = runningInstanceCount;
            return this;
        }

        public final void setRunningInstanceCount(Integer runningInstanceCount) {
            this.runningInstanceCount = runningInstanceCount;
        }

        public final InstanceGroupStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(InstanceGroupStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(InstanceGroupStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final Long getConfigurationsVersion() {
            return this.configurationsVersion;
        }

        @Override
        public final Builder configurationsVersion(Long configurationsVersion) {
            this.configurationsVersion = configurationsVersion;
            return this;
        }

        public final void setConfigurationsVersion(Long configurationsVersion) {
            this.configurationsVersion = configurationsVersion;
        }

        public final Collection<Configuration.Builder> getLastSuccessfullyAppliedConfigurations() {
            return this.lastSuccessfullyAppliedConfigurations != null ? (Collection)this.lastSuccessfullyAppliedConfigurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lastSuccessfullyAppliedConfigurations(Collection<Configuration> lastSuccessfullyAppliedConfigurations) {
            this.lastSuccessfullyAppliedConfigurations = ConfigurationListCopier.copy(lastSuccessfullyAppliedConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastSuccessfullyAppliedConfigurations(Configuration ... lastSuccessfullyAppliedConfigurations) {
            this.lastSuccessfullyAppliedConfigurations(Arrays.asList(lastSuccessfullyAppliedConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastSuccessfullyAppliedConfigurations(Consumer<Configuration.Builder> ... lastSuccessfullyAppliedConfigurations) {
            this.lastSuccessfullyAppliedConfigurations(Stream.of(lastSuccessfullyAppliedConfigurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLastSuccessfullyAppliedConfigurations(Collection<Configuration.BuilderImpl> lastSuccessfullyAppliedConfigurations) {
            this.lastSuccessfullyAppliedConfigurations = ConfigurationListCopier.copyFromBuilder(lastSuccessfullyAppliedConfigurations);
        }

        public final Long getLastSuccessfullyAppliedConfigurationsVersion() {
            return this.lastSuccessfullyAppliedConfigurationsVersion;
        }

        @Override
        public final Builder lastSuccessfullyAppliedConfigurationsVersion(Long lastSuccessfullyAppliedConfigurationsVersion) {
            this.lastSuccessfullyAppliedConfigurationsVersion = lastSuccessfullyAppliedConfigurationsVersion;
            return this;
        }

        public final void setLastSuccessfullyAppliedConfigurationsVersion(Long lastSuccessfullyAppliedConfigurationsVersion) {
            this.lastSuccessfullyAppliedConfigurationsVersion = lastSuccessfullyAppliedConfigurationsVersion;
        }

        public final Collection<EbsBlockDevice.Builder> getEbsBlockDevices() {
            return this.ebsBlockDevices != null ? (Collection)this.ebsBlockDevices.stream().map(EbsBlockDevice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ebsBlockDevices(Collection<EbsBlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = EbsBlockDeviceListCopier.copy(ebsBlockDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDevices(EbsBlockDevice ... ebsBlockDevices) {
            this.ebsBlockDevices(Arrays.asList(ebsBlockDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDevices(Consumer<EbsBlockDevice.Builder> ... ebsBlockDevices) {
            this.ebsBlockDevices(Stream.of(ebsBlockDevices).map(c -> (EbsBlockDevice)((EbsBlockDevice.Builder)EbsBlockDevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEbsBlockDevices(Collection<EbsBlockDevice.BuilderImpl> ebsBlockDevices) {
            this.ebsBlockDevices = EbsBlockDeviceListCopier.copyFromBuilder(ebsBlockDevices);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final ShrinkPolicy.Builder getShrinkPolicy() {
            return this.shrinkPolicy != null ? this.shrinkPolicy.toBuilder() : null;
        }

        @Override
        public final Builder shrinkPolicy(ShrinkPolicy shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy;
            return this;
        }

        public final void setShrinkPolicy(ShrinkPolicy.BuilderImpl shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy != null ? shrinkPolicy.build() : null;
        }

        public final AutoScalingPolicyDescription.Builder getAutoScalingPolicy() {
            return this.autoScalingPolicy != null ? this.autoScalingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicyDescription autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicyDescription.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        public InstanceGroup build() {
            return new InstanceGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceGroup> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceGroupType(String var1);

        public Builder instanceGroupType(InstanceGroupType var1);

        public Builder bidPrice(String var1);

        public Builder instanceType(String var1);

        public Builder requestedInstanceCount(Integer var1);

        public Builder runningInstanceCount(Integer var1);

        public Builder status(InstanceGroupStatus var1);

        default public Builder status(Consumer<InstanceGroupStatus.Builder> status) {
            return this.status((InstanceGroupStatus)((InstanceGroupStatus.Builder)InstanceGroupStatus.builder().applyMutation(status)).build());
        }

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);

        public Builder configurationsVersion(Long var1);

        public Builder lastSuccessfullyAppliedConfigurations(Collection<Configuration> var1);

        public Builder lastSuccessfullyAppliedConfigurations(Configuration ... var1);

        public Builder lastSuccessfullyAppliedConfigurations(Consumer<Configuration.Builder> ... var1);

        public Builder lastSuccessfullyAppliedConfigurationsVersion(Long var1);

        public Builder ebsBlockDevices(Collection<EbsBlockDevice> var1);

        public Builder ebsBlockDevices(EbsBlockDevice ... var1);

        public Builder ebsBlockDevices(Consumer<EbsBlockDevice.Builder> ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder shrinkPolicy(ShrinkPolicy var1);

        default public Builder shrinkPolicy(Consumer<ShrinkPolicy.Builder> shrinkPolicy) {
            return this.shrinkPolicy((ShrinkPolicy)((ShrinkPolicy.Builder)ShrinkPolicy.builder().applyMutation(shrinkPolicy)).build());
        }

        public Builder autoScalingPolicy(AutoScalingPolicyDescription var1);

        default public Builder autoScalingPolicy(Consumer<AutoScalingPolicyDescription.Builder> autoScalingPolicy) {
            return this.autoScalingPolicy((AutoScalingPolicyDescription)((AutoScalingPolicyDescription.Builder)AutoScalingPolicyDescription.builder().applyMutation(autoScalingPolicy)).build());
        }
    }
}

