/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3MonitoringConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3MonitoringConfiguration> {
    private static final SdkField<String> LOG_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogUri").getter(S3MonitoringConfiguration.getter(S3MonitoringConfiguration::logUri)).setter(S3MonitoringConfiguration.setter(Builder::logUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(S3MonitoringConfiguration.getter(S3MonitoringConfiguration::encryptionKeyArn)).setter(S3MonitoringConfiguration.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_URI_FIELD, ENCRYPTION_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3MonitoringConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logUri;
    private final String encryptionKeyArn;

    private S3MonitoringConfiguration(BuilderImpl builder) {
        this.logUri = builder.logUri;
        this.encryptionKeyArn = builder.encryptionKeyArn;
    }

    public final String logUri() {
        return this.logUri;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3MonitoringConfiguration)) {
            return false;
        }
        S3MonitoringConfiguration other = (S3MonitoringConfiguration)obj;
        return Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3MonitoringConfiguration").add("LogUri", (Object)this.logUri()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogUri": {
                return Optional.ofNullable(clazz.cast(this.logUri()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LogUri", LOG_URI_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3MonitoringConfiguration, T> g) {
        return obj -> g.apply((S3MonitoringConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logUri;
        private String encryptionKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3MonitoringConfiguration model) {
            this.logUri(model.logUri);
            this.encryptionKeyArn(model.encryptionKeyArn);
        }

        public final String getLogUri() {
            return this.logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public S3MonitoringConfiguration build() {
            return new S3MonitoringConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3MonitoringConfiguration> {
        public Builder logUri(String var1);

        public Builder encryptionKeyArn(String var1);
    }
}

