/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.InstanceGroupState;
import software.amazon.awssdk.services.emr.model.InstanceGroupStateChangeReason;
import software.amazon.awssdk.services.emr.model.InstanceGroupTimeline;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceGroupStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceGroupStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(InstanceGroupStatus.getter(InstanceGroupStatus::stateAsString)).setter(InstanceGroupStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<InstanceGroupStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateChangeReason").getter(InstanceGroupStatus.getter(InstanceGroupStatus::stateChangeReason)).setter(InstanceGroupStatus.setter(Builder::stateChangeReason)).constructor(InstanceGroupStateChangeReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final SdkField<InstanceGroupTimeline> TIMELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Timeline").getter(InstanceGroupStatus.getter(InstanceGroupStatus::timeline)).setter(InstanceGroupStatus.setter(Builder::timeline)).constructor(InstanceGroupTimeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_CHANGE_REASON_FIELD, TIMELINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceGroupStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String state;
    private final InstanceGroupStateChangeReason stateChangeReason;
    private final InstanceGroupTimeline timeline;

    private InstanceGroupStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    public final InstanceGroupState state() {
        return InstanceGroupState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final InstanceGroupStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public final InstanceGroupTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupStatus)) {
            return false;
        }
        InstanceGroupStatus other = (InstanceGroupStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.timeline(), other.timeline());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceGroupStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("Timeline", (Object)this.timeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "Timeline": {
                return Optional.ofNullable(clazz.cast(this.timeline()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("State", STATE_FIELD);
        map.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        map.put("Timeline", TIMELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroupStatus, T> g) {
        return obj -> g.apply((InstanceGroupStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private InstanceGroupStateChangeReason stateChangeReason;
        private InstanceGroupTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.timeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final InstanceGroupStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(InstanceGroupStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        public final Builder stateChangeReason(InstanceGroupStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final InstanceGroupTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        public final void setTimeline(InstanceGroupTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        public final Builder timeline(InstanceGroupTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public InstanceGroupStatus build() {
            return new InstanceGroupStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceGroupStatus> {
        public Builder state(String var1);

        public Builder state(InstanceGroupState var1);

        public Builder stateChangeReason(InstanceGroupStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<InstanceGroupStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((InstanceGroupStateChangeReason)((InstanceGroupStateChangeReason.Builder)InstanceGroupStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }

        public Builder timeline(InstanceGroupTimeline var1);

        default public Builder timeline(Consumer<InstanceGroupTimeline.Builder> timeline) {
            return this.timeline((InstanceGroupTimeline)((InstanceGroupTimeline.Builder)InstanceGroupTimeline.builder().applyMutation(timeline)).build());
        }
    }
}

