/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.internal.UserAgentUtils;
import software.amazon.awssdk.services.emr.model.ListStudiosRequest;
import software.amazon.awssdk.services.emr.model.ListStudiosResponse;
import software.amazon.awssdk.services.emr.model.StudioSummary;

public class ListStudiosPublisher
implements SdkPublisher<ListStudiosResponse> {
    private final EmrAsyncClient client;
    private final ListStudiosRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStudiosPublisher(EmrAsyncClient client, ListStudiosRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStudiosPublisher(EmrAsyncClient client, ListStudiosRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStudiosResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStudiosResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StudioSummary> studios() {
        Function<ListStudiosResponse, Iterator> getIterator = response -> {
            if (response != null && response.studios() != null) {
                return response.studios().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStudiosResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStudiosResponseFetcher
    implements AsyncPageFetcher<ListStudiosResponse> {
        private ListStudiosResponseFetcher() {
        }

        public boolean hasNextPage(ListStudiosResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListStudiosResponse> nextPage(ListStudiosResponse previousPage) {
            if (previousPage == null) {
                return ListStudiosPublisher.this.client.listStudios(ListStudiosPublisher.this.firstRequest);
            }
            return ListStudiosPublisher.this.client.listStudios((ListStudiosRequest)((Object)ListStudiosPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

