/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAutoScalingPolicyResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, PutAutoScalingPolicyResponse> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(PutAutoScalingPolicyResponse.getter(PutAutoScalingPolicyResponse::clusterId)).setter(PutAutoScalingPolicyResponse.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupId").getter(PutAutoScalingPolicyResponse.getter(PutAutoScalingPolicyResponse::instanceGroupId)).setter(PutAutoScalingPolicyResponse.setter(Builder::instanceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()}).build();
    private static final SdkField<AutoScalingPolicyDescription> AUTO_SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoScalingPolicy").getter(PutAutoScalingPolicyResponse.getter(PutAutoScalingPolicyResponse::autoScalingPolicy)).setter(PutAutoScalingPolicyResponse.setter(Builder::autoScalingPolicy)).constructor(AutoScalingPolicyDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(PutAutoScalingPolicyResponse.getter(PutAutoScalingPolicyResponse::clusterArn)).setter(PutAutoScalingPolicyResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, INSTANCE_GROUP_ID_FIELD, AUTO_SCALING_POLICY_FIELD, CLUSTER_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAutoScalingPolicyResponse.memberNameToFieldInitializer();
    private final String clusterId;
    private final String instanceGroupId;
    private final AutoScalingPolicyDescription autoScalingPolicy;
    private final String clusterArn;

    private PutAutoScalingPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.autoScalingPolicy = builder.autoScalingPolicy;
        this.clusterArn = builder.clusterArn;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String instanceGroupId() {
        return this.instanceGroupId;
    }

    public final AutoScalingPolicyDescription autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAutoScalingPolicyResponse)) {
            return false;
        }
        PutAutoScalingPolicyResponse other = (PutAutoScalingPolicyResponse)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.autoScalingPolicy(), other.autoScalingPolicy()) && Objects.equals(this.clusterArn(), other.clusterArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutAutoScalingPolicyResponse").add("ClusterId", (Object)this.clusterId()).add("InstanceGroupId", (Object)this.instanceGroupId()).add("AutoScalingPolicy", (Object)this.autoScalingPolicy()).add("ClusterArn", (Object)this.clusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "InstanceGroupId": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupId()));
            }
            case "AutoScalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoScalingPolicy()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("InstanceGroupId", INSTANCE_GROUP_ID_FIELD);
        map.put("AutoScalingPolicy", AUTO_SCALING_POLICY_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAutoScalingPolicyResponse, T> g) {
        return obj -> g.apply((PutAutoScalingPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceGroupId;
        private AutoScalingPolicyDescription autoScalingPolicy;
        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAutoScalingPolicyResponse model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceGroupId(model.instanceGroupId);
            this.autoScalingPolicy(model.autoScalingPolicy);
            this.clusterArn(model.clusterArn);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final AutoScalingPolicyDescription.Builder getAutoScalingPolicy() {
            return this.autoScalingPolicy != null ? this.autoScalingPolicy.toBuilder() : null;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicyDescription.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicyDescription autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        @Override
        public PutAutoScalingPolicyResponse build() {
            return new PutAutoScalingPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAutoScalingPolicyResponse> {
        public Builder clusterId(String var1);

        public Builder instanceGroupId(String var1);

        public Builder autoScalingPolicy(AutoScalingPolicyDescription var1);

        default public Builder autoScalingPolicy(Consumer<AutoScalingPolicyDescription.Builder> autoScalingPolicy) {
            return this.autoScalingPolicy((AutoScalingPolicyDescription)((AutoScalingPolicyDescription.Builder)AutoScalingPolicyDescription.builder().applyMutation(autoScalingPolicy)).build());
        }

        public Builder clusterArn(String var1);
    }
}

