/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.StudioSummary;
import software.amazon.awssdk.services.emr.model.StudioSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStudiosResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListStudiosResponse> {
    private static final SdkField<List<StudioSummary>> STUDIOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Studios").getter(ListStudiosResponse.getter(ListStudiosResponse::studios)).setter(ListStudiosResponse.setter(Builder::studios)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Studios").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StudioSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListStudiosResponse.getter(ListStudiosResponse::marker)).setter(ListStudiosResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIOS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Studios", STUDIOS_FIELD);
            this.put("Marker", MARKER_FIELD);
        }
    });
    private final List<StudioSummary> studios;
    private final String marker;

    private ListStudiosResponse(BuilderImpl builder) {
        super(builder);
        this.studios = builder.studios;
        this.marker = builder.marker;
    }

    public final boolean hasStudios() {
        return this.studios != null && !(this.studios instanceof SdkAutoConstructList);
    }

    public final List<StudioSummary> studios() {
        return this.studios;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStudios() ? this.studios() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudiosResponse)) {
            return false;
        }
        ListStudiosResponse other = (ListStudiosResponse)((Object)obj);
        return this.hasStudios() == other.hasStudios() && Objects.equals(this.studios(), other.studios()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListStudiosResponse").add("Studios", this.hasStudios() ? this.studios() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Studios": {
                return Optional.ofNullable(clazz.cast(this.studios()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListStudiosResponse, T> g) {
        return obj -> g.apply((ListStudiosResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<StudioSummary> studios = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudiosResponse model) {
            super(model);
            this.studios(model.studios);
            this.marker(model.marker);
        }

        public final List<StudioSummary.Builder> getStudios() {
            List<StudioSummary.Builder> result = StudioSummaryListCopier.copyToBuilder(this.studios);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStudios(Collection<StudioSummary.BuilderImpl> studios) {
            this.studios = StudioSummaryListCopier.copyFromBuilder(studios);
        }

        @Override
        public final Builder studios(Collection<StudioSummary> studios) {
            this.studios = StudioSummaryListCopier.copy(studios);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder studios(StudioSummary ... studios) {
            this.studios(Arrays.asList(studios));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder studios(Consumer<StudioSummary.Builder> ... studios) {
            this.studios(Stream.of(studios).map(c -> (StudioSummary)((StudioSummary.Builder)StudioSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListStudiosResponse build() {
            return new ListStudiosResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStudiosResponse> {
        public Builder studios(Collection<StudioSummary> var1);

        public Builder studios(StudioSummary ... var1);

        public Builder studios(Consumer<StudioSummary.Builder> ... var1);

        public Builder marker(String var1);
    }
}

