/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.OnDemandCapacityReservationOptions;
import software.amazon.awssdk.services.emr.model.OnDemandProvisioningAllocationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnDemandResizingSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnDemandResizingSpecification> {
    private static final SdkField<Integer> TIMEOUT_DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutDurationMinutes").getter(OnDemandResizingSpecification.getter(OnDemandResizingSpecification::timeoutDurationMinutes)).setter(OnDemandResizingSpecification.setter(Builder::timeoutDurationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutDurationMinutes").build()}).build();
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationStrategy").getter(OnDemandResizingSpecification.getter(OnDemandResizingSpecification::allocationStrategyAsString)).setter(OnDemandResizingSpecification.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy").build()}).build();
    private static final SdkField<OnDemandCapacityReservationOptions> CAPACITY_RESERVATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationOptions").getter(OnDemandResizingSpecification.getter(OnDemandResizingSpecification::capacityReservationOptions)).setter(OnDemandResizingSpecification.setter(Builder::capacityReservationOptions)).constructor(OnDemandCapacityReservationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_DURATION_MINUTES_FIELD, ALLOCATION_STRATEGY_FIELD, CAPACITY_RESERVATION_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer timeoutDurationMinutes;
    private final String allocationStrategy;
    private final OnDemandCapacityReservationOptions capacityReservationOptions;

    private OnDemandResizingSpecification(BuilderImpl builder) {
        this.timeoutDurationMinutes = builder.timeoutDurationMinutes;
        this.allocationStrategy = builder.allocationStrategy;
        this.capacityReservationOptions = builder.capacityReservationOptions;
    }

    public final Integer timeoutDurationMinutes() {
        return this.timeoutDurationMinutes;
    }

    public final OnDemandProvisioningAllocationStrategy allocationStrategy() {
        return OnDemandProvisioningAllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public final OnDemandCapacityReservationOptions capacityReservationOptions() {
        return this.capacityReservationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandResizingSpecification)) {
            return false;
        }
        OnDemandResizingSpecification other = (OnDemandResizingSpecification)obj;
        return Objects.equals(this.timeoutDurationMinutes(), other.timeoutDurationMinutes()) && Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.capacityReservationOptions(), other.capacityReservationOptions());
    }

    public final String toString() {
        return ToString.builder((String)"OnDemandResizingSpecification").add("TimeoutDurationMinutes", (Object)this.timeoutDurationMinutes()).add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("CapacityReservationOptions", (Object)this.capacityReservationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeoutDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutDurationMinutes()));
            }
            case "AllocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "CapacityReservationOptions": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandResizingSpecification, T> g) {
        return obj -> g.apply((OnDemandResizingSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutDurationMinutes;
        private String allocationStrategy;
        private OnDemandCapacityReservationOptions capacityReservationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandResizingSpecification model) {
            this.timeoutDurationMinutes(model.timeoutDurationMinutes);
            this.allocationStrategy(model.allocationStrategy);
            this.capacityReservationOptions(model.capacityReservationOptions);
        }

        public final Integer getTimeoutDurationMinutes() {
            return this.timeoutDurationMinutes;
        }

        public final void setTimeoutDurationMinutes(Integer timeoutDurationMinutes) {
            this.timeoutDurationMinutes = timeoutDurationMinutes;
        }

        @Override
        public final Builder timeoutDurationMinutes(Integer timeoutDurationMinutes) {
            this.timeoutDurationMinutes = timeoutDurationMinutes;
            return this;
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(OnDemandProvisioningAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final OnDemandCapacityReservationOptions.Builder getCapacityReservationOptions() {
            return this.capacityReservationOptions != null ? this.capacityReservationOptions.toBuilder() : null;
        }

        public final void setCapacityReservationOptions(OnDemandCapacityReservationOptions.BuilderImpl capacityReservationOptions) {
            this.capacityReservationOptions = capacityReservationOptions != null ? capacityReservationOptions.build() : null;
        }

        @Override
        public final Builder capacityReservationOptions(OnDemandCapacityReservationOptions capacityReservationOptions) {
            this.capacityReservationOptions = capacityReservationOptions;
            return this;
        }

        public OnDemandResizingSpecification build() {
            return new OnDemandResizingSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnDemandResizingSpecification> {
        public Builder timeoutDurationMinutes(Integer var1);

        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(OnDemandProvisioningAllocationStrategy var1);

        public Builder capacityReservationOptions(OnDemandCapacityReservationOptions var1);

        default public Builder capacityReservationOptions(Consumer<OnDemandCapacityReservationOptions.Builder> capacityReservationOptions) {
            return this.capacityReservationOptions((OnDemandCapacityReservationOptions)((OnDemandCapacityReservationOptions.Builder)OnDemandCapacityReservationOptions.builder().applyMutation(capacityReservationOptions)).build());
        }
    }
}

