/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.InstanceFleetResizingSpecifications;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfig;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceFleetModifyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceFleetModifyConfig> {
    private static final SdkField<String> INSTANCE_FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFleetId").getter(InstanceFleetModifyConfig.getter(InstanceFleetModifyConfig::instanceFleetId)).setter(InstanceFleetModifyConfig.setter(Builder::instanceFleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetId").build()}).build();
    private static final SdkField<Integer> TARGET_ON_DEMAND_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetOnDemandCapacity").getter(InstanceFleetModifyConfig.getter(InstanceFleetModifyConfig::targetOnDemandCapacity)).setter(InstanceFleetModifyConfig.setter(Builder::targetOnDemandCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOnDemandCapacity").build()}).build();
    private static final SdkField<Integer> TARGET_SPOT_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetSpotCapacity").getter(InstanceFleetModifyConfig.getter(InstanceFleetModifyConfig::targetSpotCapacity)).setter(InstanceFleetModifyConfig.setter(Builder::targetSpotCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSpotCapacity").build()}).build();
    private static final SdkField<InstanceFleetResizingSpecifications> RESIZE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResizeSpecifications").getter(InstanceFleetModifyConfig.getter(InstanceFleetModifyConfig::resizeSpecifications)).setter(InstanceFleetModifyConfig.setter(Builder::resizeSpecifications)).constructor(InstanceFleetResizingSpecifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeSpecifications").build()}).build();
    private static final SdkField<List<InstanceTypeConfig>> INSTANCE_TYPE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypeConfigs").getter(InstanceFleetModifyConfig.getter(InstanceFleetModifyConfig::instanceTypeConfigs)).setter(InstanceFleetModifyConfig.setter(Builder::instanceTypeConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(InstanceFleetModifyConfig.getter(InstanceFleetModifyConfig::context)).setter(InstanceFleetModifyConfig.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FLEET_ID_FIELD, TARGET_ON_DEMAND_CAPACITY_FIELD, TARGET_SPOT_CAPACITY_FIELD, RESIZE_SPECIFICATIONS_FIELD, INSTANCE_TYPE_CONFIGS_FIELD, CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceFleetId", INSTANCE_FLEET_ID_FIELD);
            this.put("TargetOnDemandCapacity", TARGET_ON_DEMAND_CAPACITY_FIELD);
            this.put("TargetSpotCapacity", TARGET_SPOT_CAPACITY_FIELD);
            this.put("ResizeSpecifications", RESIZE_SPECIFICATIONS_FIELD);
            this.put("InstanceTypeConfigs", INSTANCE_TYPE_CONFIGS_FIELD);
            this.put("Context", CONTEXT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String instanceFleetId;
    private final Integer targetOnDemandCapacity;
    private final Integer targetSpotCapacity;
    private final InstanceFleetResizingSpecifications resizeSpecifications;
    private final List<InstanceTypeConfig> instanceTypeConfigs;
    private final String context;

    private InstanceFleetModifyConfig(BuilderImpl builder) {
        this.instanceFleetId = builder.instanceFleetId;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
        this.resizeSpecifications = builder.resizeSpecifications;
        this.instanceTypeConfigs = builder.instanceTypeConfigs;
        this.context = builder.context;
    }

    public final String instanceFleetId() {
        return this.instanceFleetId;
    }

    public final Integer targetOnDemandCapacity() {
        return this.targetOnDemandCapacity;
    }

    public final Integer targetSpotCapacity() {
        return this.targetSpotCapacity;
    }

    public final InstanceFleetResizingSpecifications resizeSpecifications() {
        return this.resizeSpecifications;
    }

    public final boolean hasInstanceTypeConfigs() {
        return this.instanceTypeConfigs != null && !(this.instanceTypeConfigs instanceof SdkAutoConstructList);
    }

    public final List<InstanceTypeConfig> instanceTypeConfigs() {
        return this.instanceTypeConfigs;
    }

    public final String context() {
        return this.context;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSpotCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.resizeSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTypeConfigs() ? this.instanceTypeConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetModifyConfig)) {
            return false;
        }
        InstanceFleetModifyConfig other = (InstanceFleetModifyConfig)obj;
        return Objects.equals(this.instanceFleetId(), other.instanceFleetId()) && Objects.equals(this.targetOnDemandCapacity(), other.targetOnDemandCapacity()) && Objects.equals(this.targetSpotCapacity(), other.targetSpotCapacity()) && Objects.equals(this.resizeSpecifications(), other.resizeSpecifications()) && this.hasInstanceTypeConfigs() == other.hasInstanceTypeConfigs() && Objects.equals(this.instanceTypeConfigs(), other.instanceTypeConfigs()) && Objects.equals(this.context(), other.context());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceFleetModifyConfig").add("InstanceFleetId", (Object)this.instanceFleetId()).add("TargetOnDemandCapacity", (Object)this.targetOnDemandCapacity()).add("TargetSpotCapacity", (Object)this.targetSpotCapacity()).add("ResizeSpecifications", (Object)this.resizeSpecifications()).add("InstanceTypeConfigs", this.hasInstanceTypeConfigs() ? this.instanceTypeConfigs() : null).add("Context", (Object)this.context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFleetId": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetId()));
            }
            case "TargetOnDemandCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetOnDemandCapacity()));
            }
            case "TargetSpotCapacity": {
                return Optional.ofNullable(clazz.cast(this.targetSpotCapacity()));
            }
            case "ResizeSpecifications": {
                return Optional.ofNullable(clazz.cast(this.resizeSpecifications()));
            }
            case "InstanceTypeConfigs": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeConfigs()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetModifyConfig, T> g) {
        return obj -> g.apply((InstanceFleetModifyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceFleetId;
        private Integer targetOnDemandCapacity;
        private Integer targetSpotCapacity;
        private InstanceFleetResizingSpecifications resizeSpecifications;
        private List<InstanceTypeConfig> instanceTypeConfigs = DefaultSdkAutoConstructList.getInstance();
        private String context;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetModifyConfig model) {
            this.instanceFleetId(model.instanceFleetId);
            this.targetOnDemandCapacity(model.targetOnDemandCapacity);
            this.targetSpotCapacity(model.targetSpotCapacity);
            this.resizeSpecifications(model.resizeSpecifications);
            this.instanceTypeConfigs(model.instanceTypeConfigs);
            this.context(model.context);
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final Integer getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final Integer getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final InstanceFleetResizingSpecifications.Builder getResizeSpecifications() {
            return this.resizeSpecifications != null ? this.resizeSpecifications.toBuilder() : null;
        }

        public final void setResizeSpecifications(InstanceFleetResizingSpecifications.BuilderImpl resizeSpecifications) {
            this.resizeSpecifications = resizeSpecifications != null ? resizeSpecifications.build() : null;
        }

        @Override
        public final Builder resizeSpecifications(InstanceFleetResizingSpecifications resizeSpecifications) {
            this.resizeSpecifications = resizeSpecifications;
            return this;
        }

        public final List<InstanceTypeConfig.Builder> getInstanceTypeConfigs() {
            List<InstanceTypeConfig.Builder> result = InstanceTypeConfigListCopier.copyToBuilder(this.instanceTypeConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypeConfigs(Collection<InstanceTypeConfig.BuilderImpl> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copyFromBuilder(instanceTypeConfigs);
        }

        @Override
        public final Builder instanceTypeConfigs(Collection<InstanceTypeConfig> instanceTypeConfigs) {
            this.instanceTypeConfigs = InstanceTypeConfigListCopier.copy(instanceTypeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeConfigs(InstanceTypeConfig ... instanceTypeConfigs) {
            this.instanceTypeConfigs(Arrays.asList(instanceTypeConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeConfigs(Consumer<InstanceTypeConfig.Builder> ... instanceTypeConfigs) {
            this.instanceTypeConfigs(Stream.of(instanceTypeConfigs).map(c -> (InstanceTypeConfig)((InstanceTypeConfig.Builder)InstanceTypeConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public InstanceFleetModifyConfig build() {
            return new InstanceFleetModifyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceFleetModifyConfig> {
        public Builder instanceFleetId(String var1);

        public Builder targetOnDemandCapacity(Integer var1);

        public Builder targetSpotCapacity(Integer var1);

        public Builder resizeSpecifications(InstanceFleetResizingSpecifications var1);

        default public Builder resizeSpecifications(Consumer<InstanceFleetResizingSpecifications.Builder> resizeSpecifications) {
            return this.resizeSpecifications((InstanceFleetResizingSpecifications)((InstanceFleetResizingSpecifications.Builder)InstanceFleetResizingSpecifications.builder().applyMutation(resizeSpecifications)).build());
        }

        public Builder instanceTypeConfigs(Collection<InstanceTypeConfig> var1);

        public Builder instanceTypeConfigs(InstanceTypeConfig ... var1);

        public Builder instanceTypeConfigs(Consumer<InstanceTypeConfig.Builder> ... var1);

        public Builder context(String var1);
    }
}

