/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.ErrorDataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ErrorDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ErrorDetail> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(ErrorDetail.getter(ErrorDetail::errorCode)).setter(ErrorDetail.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<List<Map<String, String>>> ERROR_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorData").getter(ErrorDetail.getter(ErrorDetail::errorData)).setter(ErrorDetail.setter(Builder::errorData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(ErrorDetail.getter(ErrorDetail::errorMessage)).setter(ErrorDetail.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD, ERROR_DATA_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ErrorCode", ERROR_CODE_FIELD);
            this.put("ErrorData", ERROR_DATA_FIELD);
            this.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String errorCode;
    private final List<Map<String, String>> errorData;
    private final String errorMessage;

    private ErrorDetail(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorData = builder.errorData;
        this.errorMessage = builder.errorMessage;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final boolean hasErrorData() {
        return this.errorData != null && !(this.errorData instanceof SdkAutoConstructList);
    }

    public final List<Map<String, String>> errorData() {
        return this.errorData;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorData() ? this.errorData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorDetail)) {
            return false;
        }
        ErrorDetail other = (ErrorDetail)obj;
        return Objects.equals(this.errorCode(), other.errorCode()) && this.hasErrorData() == other.hasErrorData() && Objects.equals(this.errorData(), other.errorData()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ErrorDetail").add("ErrorCode", (Object)this.errorCode()).add("ErrorData", this.hasErrorData() ? this.errorData() : null).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "ErrorData": {
                return Optional.ofNullable(clazz.cast(this.errorData()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ErrorDetail, T> g) {
        return obj -> g.apply((ErrorDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private List<Map<String, String>> errorData = DefaultSdkAutoConstructList.getInstance();
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorDetail model) {
            this.errorCode(model.errorCode);
            this.errorData(model.errorData);
            this.errorMessage(model.errorMessage);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Collection<? extends Map<String, String>> getErrorData() {
            if (this.errorData instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errorData;
        }

        public final void setErrorData(Collection<? extends Map<String, String>> errorData) {
            this.errorData = ErrorDataCopier.copy(errorData);
        }

        @Override
        public final Builder errorData(Collection<? extends Map<String, String>> errorData) {
            this.errorData = ErrorDataCopier.copy(errorData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorData(Map<String, String> ... errorData) {
            this.errorData(Arrays.asList(errorData));
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ErrorDetail build() {
            return new ErrorDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ErrorDetail> {
        public Builder errorCode(String var1);

        public Builder errorData(Collection<? extends Map<String, String>> var1);

        public Builder errorData(Map<String, String> ... var1);

        public Builder errorMessage(String var1);
    }
}

