/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.ExecutionEngineType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionEngineConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionEngineConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ExecutionEngineConfig.getter(ExecutionEngineConfig::id)).setter(ExecutionEngineConfig.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ExecutionEngineConfig.getter(ExecutionEngineConfig::typeAsString)).setter(ExecutionEngineConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> MASTER_INSTANCE_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterInstanceSecurityGroupId").getter(ExecutionEngineConfig.getter(ExecutionEngineConfig::masterInstanceSecurityGroupId)).setter(ExecutionEngineConfig.setter(Builder::masterInstanceSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterInstanceSecurityGroupId").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(ExecutionEngineConfig.getter(ExecutionEngineConfig::executionRoleArn)).setter(ExecutionEngineConfig.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, MASTER_INSTANCE_SECURITY_GROUP_ID_FIELD, EXECUTION_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("MasterInstanceSecurityGroupId", MASTER_INSTANCE_SECURITY_GROUP_ID_FIELD);
            this.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String masterInstanceSecurityGroupId;
    private final String executionRoleArn;

    private ExecutionEngineConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.masterInstanceSecurityGroupId = builder.masterInstanceSecurityGroupId;
        this.executionRoleArn = builder.executionRoleArn;
    }

    public final String id() {
        return this.id;
    }

    public final ExecutionEngineType type() {
        return ExecutionEngineType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String masterInstanceSecurityGroupId() {
        return this.masterInstanceSecurityGroupId;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterInstanceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionEngineConfig)) {
            return false;
        }
        ExecutionEngineConfig other = (ExecutionEngineConfig)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.masterInstanceSecurityGroupId(), other.masterInstanceSecurityGroupId()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionEngineConfig").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("MasterInstanceSecurityGroupId", (Object)this.masterInstanceSecurityGroupId()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MasterInstanceSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.masterInstanceSecurityGroupId()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionEngineConfig, T> g) {
        return obj -> g.apply((ExecutionEngineConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String masterInstanceSecurityGroupId;
        private String executionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionEngineConfig model) {
            this.id(model.id);
            this.type(model.type);
            this.masterInstanceSecurityGroupId(model.masterInstanceSecurityGroupId);
            this.executionRoleArn(model.executionRoleArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ExecutionEngineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMasterInstanceSecurityGroupId() {
            return this.masterInstanceSecurityGroupId;
        }

        public final void setMasterInstanceSecurityGroupId(String masterInstanceSecurityGroupId) {
            this.masterInstanceSecurityGroupId = masterInstanceSecurityGroupId;
        }

        @Override
        public final Builder masterInstanceSecurityGroupId(String masterInstanceSecurityGroupId) {
            this.masterInstanceSecurityGroupId = masterInstanceSecurityGroupId;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public ExecutionEngineConfig build() {
            return new ExecutionEngineConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionEngineConfig> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(ExecutionEngineType var1);

        public Builder masterInstanceSecurityGroupId(String var1);

        public Builder executionRoleArn(String var1);
    }
}

