/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.InstanceFleetConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddInstanceFleetRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, AddInstanceFleetRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(AddInstanceFleetRequest.getter(AddInstanceFleetRequest::clusterId)).setter(AddInstanceFleetRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<InstanceFleetConfig> INSTANCE_FLEET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceFleet").getter(AddInstanceFleetRequest.getter(AddInstanceFleetRequest::instanceFleet)).setter(AddInstanceFleetRequest.setter(Builder::instanceFleet)).constructor(InstanceFleetConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, INSTANCE_FLEET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClusterId", CLUSTER_ID_FIELD);
            this.put("InstanceFleet", INSTANCE_FLEET_FIELD);
        }
    });
    private final String clusterId;
    private final InstanceFleetConfig instanceFleet;

    private AddInstanceFleetRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceFleet = builder.instanceFleet;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final InstanceFleetConfig instanceFleet() {
        return this.instanceFleet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceFleetRequest)) {
            return false;
        }
        AddInstanceFleetRequest other = (AddInstanceFleetRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceFleet(), other.instanceFleet());
    }

    public final String toString() {
        return ToString.builder((String)"AddInstanceFleetRequest").add("ClusterId", (Object)this.clusterId()).add("InstanceFleet", (Object)this.instanceFleet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "InstanceFleet": {
                return Optional.ofNullable(clazz.cast(this.instanceFleet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddInstanceFleetRequest, T> g) {
        return obj -> g.apply((AddInstanceFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private InstanceFleetConfig instanceFleet;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceFleetRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceFleet(model.instanceFleet);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final InstanceFleetConfig.Builder getInstanceFleet() {
            return this.instanceFleet != null ? this.instanceFleet.toBuilder() : null;
        }

        public final void setInstanceFleet(InstanceFleetConfig.BuilderImpl instanceFleet) {
            this.instanceFleet = instanceFleet != null ? instanceFleet.build() : null;
        }

        @Override
        public final Builder instanceFleet(InstanceFleetConfig instanceFleet) {
            this.instanceFleet = instanceFleet;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddInstanceFleetRequest build() {
            return new AddInstanceFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddInstanceFleetRequest> {
        public Builder clusterId(String var1);

        public Builder instanceFleet(InstanceFleetConfig var1);

        default public Builder instanceFleet(Consumer<InstanceFleetConfig.Builder> instanceFleet) {
            return this.instanceFleet((InstanceFleetConfig)((InstanceFleetConfig.Builder)InstanceFleetConfig.builder().applyMutation(instanceFleet)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

