/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.internal.UserAgentUtils;
import software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest;
import software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse;
import software.amazon.awssdk.services.emr.model.SessionMappingSummary;

public class ListStudioSessionMappingsPublisher
implements SdkPublisher<ListStudioSessionMappingsResponse> {
    private final EmrAsyncClient client;
    private final ListStudioSessionMappingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStudioSessionMappingsPublisher(EmrAsyncClient client, ListStudioSessionMappingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStudioSessionMappingsPublisher(EmrAsyncClient client, ListStudioSessionMappingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStudioSessionMappingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStudioSessionMappingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SessionMappingSummary> sessionMappings() {
        Function<ListStudioSessionMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.sessionMappings() != null) {
                return response.sessionMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStudioSessionMappingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStudioSessionMappingsResponseFetcher
    implements AsyncPageFetcher<ListStudioSessionMappingsResponse> {
        private ListStudioSessionMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListStudioSessionMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListStudioSessionMappingsResponse> nextPage(ListStudioSessionMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListStudioSessionMappingsPublisher.this.client.listStudioSessionMappings(ListStudioSessionMappingsPublisher.this.firstRequest);
            }
            return ListStudioSessionMappingsPublisher.this.client.listStudioSessionMappings((ListStudioSessionMappingsRequest)((Object)ListStudioSessionMappingsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

