/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detailed status of the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterStatus implements SdkPojo, Serializable, ToCopyableBuilder<ClusterStatus.Builder, ClusterStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ClusterStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<ClusterStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField
            .<ClusterStateChangeReason> builder(MarshallingType.SDK_POJO).memberName("StateChangeReason")
            .getter(getter(ClusterStatus::stateChangeReason)).setter(setter(Builder::stateChangeReason))
            .constructor(ClusterStateChangeReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final SdkField<ClusterTimeline> TIMELINE_FIELD = SdkField.<ClusterTimeline> builder(MarshallingType.SDK_POJO)
            .memberName("Timeline").getter(getter(ClusterStatus::timeline)).setter(setter(Builder::timeline))
            .constructor(ClusterTimeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_CHANGE_REASON_FIELD, TIMELINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final ClusterStateChangeReason stateChangeReason;

    private final ClusterTimeline timeline;

    private ClusterStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    /**
     * <p>
     * The current state of the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the cluster.
     * @see ClusterState
     */
    public final ClusterState state() {
        return ClusterState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the cluster.
     * @see ClusterState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the cluster status change.
     * </p>
     * 
     * @return The reason for the cluster status change.
     */
    public final ClusterStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * A timeline that represents the status of a cluster over the lifetime of the cluster.
     * </p>
     * 
     * @return A timeline that represents the status of a cluster over the lifetime of the cluster.
     */
    public final ClusterTimeline timeline() {
        return timeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(timeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterStatus)) {
            return false;
        }
        ClusterStatus other = (ClusterStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason()) && Objects.equals(timeline(), other.timeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterStatus").add("State", stateAsString()).add("StateChangeReason", stateChangeReason())
                .add("Timeline", timeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        case "Timeline":
            return Optional.ofNullable(clazz.cast(timeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterStatus, T> g) {
        return obj -> g.apply((ClusterStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterStatus> {
        /**
         * <p>
         * The current state of the cluster.
         * </p>
         * 
         * @param state
         *        The current state of the cluster.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the cluster.
         * </p>
         * 
         * @param state
         *        The current state of the cluster.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(ClusterState state);

        /**
         * <p>
         * The reason for the cluster status change.
         * </p>
         * 
         * @param stateChangeReason
         *        The reason for the cluster status change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(ClusterStateChangeReason stateChangeReason);

        /**
         * <p>
         * The reason for the cluster status change.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterStateChangeReason.Builder}
         * avoiding the need to create one manually via {@link ClusterStateChangeReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterStateChangeReason.Builder#build()} is called immediately
         * and its result is passed to {@link #stateChangeReason(ClusterStateChangeReason)}.
         * 
         * @param stateChangeReason
         *        a consumer that will call methods on {@link ClusterStateChangeReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeReason(ClusterStateChangeReason)
         */
        default Builder stateChangeReason(Consumer<ClusterStateChangeReason.Builder> stateChangeReason) {
            return stateChangeReason(ClusterStateChangeReason.builder().applyMutation(stateChangeReason).build());
        }

        /**
         * <p>
         * A timeline that represents the status of a cluster over the lifetime of the cluster.
         * </p>
         * 
         * @param timeline
         *        A timeline that represents the status of a cluster over the lifetime of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeline(ClusterTimeline timeline);

        /**
         * <p>
         * A timeline that represents the status of a cluster over the lifetime of the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterTimeline.Builder} avoiding the
         * need to create one manually via {@link ClusterTimeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterTimeline.Builder#build()} is called immediately and its
         * result is passed to {@link #timeline(ClusterTimeline)}.
         * 
         * @param timeline
         *        a consumer that will call methods on {@link ClusterTimeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeline(ClusterTimeline)
         */
        default Builder timeline(Consumer<ClusterTimeline.Builder> timeline) {
            return timeline(ClusterTimeline.builder().applyMutation(timeline).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private ClusterStateChangeReason stateChangeReason;

        private ClusterTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterStatus model) {
            state(model.state);
            stateChangeReason(model.stateChangeReason);
            timeline(model.timeline);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final ClusterStateChangeReason.Builder getStateChangeReason() {
            return stateChangeReason != null ? stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(ClusterStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        public final Builder stateChangeReason(ClusterStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final ClusterTimeline.Builder getTimeline() {
            return timeline != null ? timeline.toBuilder() : null;
        }

        public final void setTimeline(ClusterTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        public final Builder timeline(ClusterTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        @Override
        public ClusterStatus build() {
            return new ClusterStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
