/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest;
import software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse;
import software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest;
import software.amazon.awssdk.services.emr.model.AddJobFlowStepsResponse;
import software.amazon.awssdk.services.emr.model.AddTagsRequest;
import software.amazon.awssdk.services.emr.model.AddTagsResponse;
import software.amazon.awssdk.services.emr.model.CancelStepsRequest;
import software.amazon.awssdk.services.emr.model.CancelStepsResponse;
import software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.CreateStudioRequest;
import software.amazon.awssdk.services.emr.model.CreateStudioResponse;
import software.amazon.awssdk.services.emr.model.CreateStudioSessionMappingRequest;
import software.amazon.awssdk.services.emr.model.CreateStudioSessionMappingResponse;
import software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.DeleteStudioRequest;
import software.amazon.awssdk.services.emr.model.DeleteStudioResponse;
import software.amazon.awssdk.services.emr.model.DeleteStudioSessionMappingRequest;
import software.amazon.awssdk.services.emr.model.DeleteStudioSessionMappingResponse;
import software.amazon.awssdk.services.emr.model.DescribeClusterRequest;
import software.amazon.awssdk.services.emr.model.DescribeClusterResponse;
import software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionRequest;
import software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionResponse;
import software.amazon.awssdk.services.emr.model.DescribeReleaseLabelRequest;
import software.amazon.awssdk.services.emr.model.DescribeReleaseLabelResponse;
import software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.DescribeStepRequest;
import software.amazon.awssdk.services.emr.model.DescribeStepResponse;
import software.amazon.awssdk.services.emr.model.DescribeStudioRequest;
import software.amazon.awssdk.services.emr.model.DescribeStudioResponse;
import software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyRequest;
import software.amazon.awssdk.services.emr.model.GetAutoTerminationPolicyResponse;
import software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationRequest;
import software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationResponse;
import software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsRequest;
import software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsResponse;
import software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.GetStudioSessionMappingRequest;
import software.amazon.awssdk.services.emr.model.GetStudioSessionMappingResponse;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse;
import software.amazon.awssdk.services.emr.model.ListClustersRequest;
import software.amazon.awssdk.services.emr.model.ListClustersResponse;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.ListInstancesRequest;
import software.amazon.awssdk.services.emr.model.ListInstancesResponse;
import software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest;
import software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse;
import software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest;
import software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse;
import software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest;
import software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.services.emr.model.ListStepsResponse;
import software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest;
import software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse;
import software.amazon.awssdk.services.emr.model.ListStudiosRequest;
import software.amazon.awssdk.services.emr.model.ListStudiosResponse;
import software.amazon.awssdk.services.emr.model.ModifyClusterRequest;
import software.amazon.awssdk.services.emr.model.ModifyClusterResponse;
import software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest;
import software.amazon.awssdk.services.emr.model.ModifyInstanceFleetResponse;
import software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.PutAutoTerminationPolicyRequest;
import software.amazon.awssdk.services.emr.model.PutAutoTerminationPolicyResponse;
import software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationRequest;
import software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationResponse;
import software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveAutoTerminationPolicyRequest;
import software.amazon.awssdk.services.emr.model.RemoveAutoTerminationPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveTagsRequest;
import software.amazon.awssdk.services.emr.model.RemoveTagsResponse;
import software.amazon.awssdk.services.emr.model.RunJobFlowRequest;
import software.amazon.awssdk.services.emr.model.RunJobFlowResponse;
import software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest;
import software.amazon.awssdk.services.emr.model.SetTerminationProtectionResponse;
import software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest;
import software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersResponse;
import software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest;
import software.amazon.awssdk.services.emr.model.StartNotebookExecutionResponse;
import software.amazon.awssdk.services.emr.model.StopNotebookExecutionRequest;
import software.amazon.awssdk.services.emr.model.StopNotebookExecutionResponse;
import software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest;
import software.amazon.awssdk.services.emr.model.TerminateJobFlowsResponse;
import software.amazon.awssdk.services.emr.model.UpdateStudioRequest;
import software.amazon.awssdk.services.emr.model.UpdateStudioResponse;
import software.amazon.awssdk.services.emr.model.UpdateStudioSessionMappingRequest;
import software.amazon.awssdk.services.emr.model.UpdateStudioSessionMappingResponse;
import software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsPublisher;
import software.amazon.awssdk.services.emr.paginators.ListClustersPublisher;
import software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsPublisher;
import software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsPublisher;
import software.amazon.awssdk.services.emr.paginators.ListInstancesPublisher;
import software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsPublisher;
import software.amazon.awssdk.services.emr.paginators.ListReleaseLabelsPublisher;
import software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsPublisher;
import software.amazon.awssdk.services.emr.paginators.ListStepsPublisher;
import software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsPublisher;
import software.amazon.awssdk.services.emr.paginators.ListStudiosPublisher;
import software.amazon.awssdk.services.emr.waiters.EmrAsyncWaiter;

/**
 * Service client for accessing Amazon EMR asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon EMR is a web service that makes it easier to process large amounts of data efficiently. Amazon EMR uses Hadoop
 * processing combined with several Amazon Web Services services to do tasks such as web indexing, data mining, log file
 * analysis, machine learning, scientific simulation, and data warehouse management.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface EmrAsyncClient extends SdkClient {
    String SERVICE_NAME = "elasticmapreduce";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "elasticmapreduce";

    /**
     * <p>
     * Adds an instance fleet to a running cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.
     * </p>
     * </note>
     *
     * @param addInstanceFleetRequest
     * @return A Java Future containing the result of the AddInstanceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.AddInstanceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddInstanceFleetResponse> addInstanceFleet(AddInstanceFleetRequest addInstanceFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an instance fleet to a running cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddInstanceFleetRequest.Builder} avoiding the need
     * to create one manually via {@link AddInstanceFleetRequest#builder()}
     * </p>
     *
     * @param addInstanceFleetRequest
     *        A {@link Consumer} that will call methods on {@link AddInstanceFleetInput.Builder} to create a request.
     * @return A Java Future containing the result of the AddInstanceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.AddInstanceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddInstanceFleetResponse> addInstanceFleet(
            Consumer<AddInstanceFleetRequest.Builder> addInstanceFleetRequest) {
        return addInstanceFleet(AddInstanceFleetRequest.builder().applyMutation(addInstanceFleetRequest).build());
    }

    /**
     * <p>
     * Adds one or more instance groups to a running cluster.
     * </p>
     *
     * @param addInstanceGroupsRequest
     *        Input to an AddInstanceGroups call.
     * @return A Java Future containing the result of the AddInstanceGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.AddInstanceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddInstanceGroupsResponse> addInstanceGroups(AddInstanceGroupsRequest addInstanceGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more instance groups to a running cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddInstanceGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link AddInstanceGroupsRequest#builder()}
     * </p>
     *
     * @param addInstanceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link AddInstanceGroupsInput.Builder} to create a request.
     *        Input to an AddInstanceGroups call.
     * @return A Java Future containing the result of the AddInstanceGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.AddInstanceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddInstanceGroupsResponse> addInstanceGroups(
            Consumer<AddInstanceGroupsRequest.Builder> addInstanceGroupsRequest) {
        return addInstanceGroups(AddInstanceGroupsRequest.builder().applyMutation(addInstanceGroupsRequest).build());
    }

    /**
     * <p>
     * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.
     * </p>
     * <p>
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps
     * to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to
     * the master node and submitting queries directly to the software running on the master node, such as Hive and
     * Hadoop.
     * </p>
     * <p>
     * A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each
     * step is performed by the main function of the main class of the JAR file. The main class can be specified either
     * in the manifest of the JAR or by using the MainFunction parameter of the step.
     * </p>
     * <p>
     * Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must
     * exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run
     * successfully.
     * </p>
     * <p>
     * You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or
     * WAITING.
     * </p>
     * <note>
     * <p>
     * The string values passed into <code>HadoopJarStep</code> object cannot exceed a total of 10240 characters.
     * </p>
     * </note>
     *
     * @param addJobFlowStepsRequest
     *        The input argument to the <a>AddJobFlowSteps</a> operation.
     * @return A Java Future containing the result of the AddJobFlowSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.AddJobFlowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddJobFlowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddJobFlowStepsResponse> addJobFlowSteps(AddJobFlowStepsRequest addJobFlowStepsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.
     * </p>
     * <p>
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps
     * to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to
     * the master node and submitting queries directly to the software running on the master node, such as Hive and
     * Hadoop.
     * </p>
     * <p>
     * A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each
     * step is performed by the main function of the main class of the JAR file. The main class can be specified either
     * in the manifest of the JAR or by using the MainFunction parameter of the step.
     * </p>
     * <p>
     * Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must
     * exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run
     * successfully.
     * </p>
     * <p>
     * You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or
     * WAITING.
     * </p>
     * <note>
     * <p>
     * The string values passed into <code>HadoopJarStep</code> object cannot exceed a total of 10240 characters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddJobFlowStepsRequest.Builder} avoiding the need
     * to create one manually via {@link AddJobFlowStepsRequest#builder()}
     * </p>
     *
     * @param addJobFlowStepsRequest
     *        A {@link Consumer} that will call methods on {@link AddJobFlowStepsInput.Builder} to create a request. The
     *        input argument to the <a>AddJobFlowSteps</a> operation.
     * @return A Java Future containing the result of the AddJobFlowSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.AddJobFlowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddJobFlowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddJobFlowStepsResponse> addJobFlowSteps(
            Consumer<AddJobFlowStepsRequest.Builder> addJobFlowStepsRequest) {
        return addJobFlowSteps(AddJobFlowStepsRequest.builder().applyMutation(addJobFlowStepsRequest).build());
    }

    /**
     * <p>
     * Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate
     * resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more
     * information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag
     * Clusters</a>.
     * </p>
     *
     * @param addTagsRequest
     *        This input identifies an Amazon EMR resource and a list of tags to attach.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate
     * resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more
     * information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag
     * Clusters</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsInput.Builder} to create a request. This input
     *        identifies an Amazon EMR resource and a list of tags to attach.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later,
     * excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is
     * idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is
     * successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a
     * <code>PENDING</code> or <code>RUNNING</code> state. In earlier versions of Amazon EMR, you can only cancel steps
     * that are in a <code>PENDING</code> state.
     * </p>
     *
     * @param cancelStepsRequest
     *        The input argument to the <a>CancelSteps</a> operation.
     * @return A Java Future containing the result of the CancelSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.CancelSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelSteps" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelStepsResponse> cancelSteps(CancelStepsRequest cancelStepsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later,
     * excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is
     * idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is
     * successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a
     * <code>PENDING</code> or <code>RUNNING</code> state. In earlier versions of Amazon EMR, you can only cancel steps
     * that are in a <code>PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelStepsRequest.Builder} avoiding the need to
     * create one manually via {@link CancelStepsRequest#builder()}
     * </p>
     *
     * @param cancelStepsRequest
     *        A {@link Consumer} that will call methods on {@link CancelStepsInput.Builder} to create a request. The
     *        input argument to the <a>CancelSteps</a> operation.
     * @return A Java Future containing the result of the CancelSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.CancelSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelSteps" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelStepsResponse> cancelSteps(Consumer<CancelStepsRequest.Builder> cancelStepsRequest) {
        return cancelSteps(CancelStepsRequest.builder().applyMutation(cancelStepsRequest).build());
    }

    /**
     * <p>
     * Creates a security configuration, which is stored in the service and can be specified when a cluster is created.
     * </p>
     *
     * @param createSecurityConfigurationRequest
     * @return A Java Future containing the result of the CreateSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.CreateSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSecurityConfigurationResponse> createSecurityConfiguration(
            CreateSecurityConfigurationRequest createSecurityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a security configuration, which is stored in the service and can be specified when a cluster is created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param createSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSecurityConfigurationInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.CreateSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSecurityConfigurationResponse> createSecurityConfiguration(
            Consumer<CreateSecurityConfigurationRequest.Builder> createSecurityConfigurationRequest) {
        return createSecurityConfiguration(CreateSecurityConfigurationRequest.builder()
                .applyMutation(createSecurityConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon EMR Studio.
     * </p>
     *
     * @param createStudioRequest
     * @return A Java Future containing the result of the CreateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.CreateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStudioResponse> createStudio(CreateStudioRequest createStudioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon EMR Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStudioRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStudioRequest#builder()}
     * </p>
     *
     * @param createStudioRequest
     *        A {@link Consumer} that will call methods on {@link CreateStudioInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.CreateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateStudioResponse> createStudio(Consumer<CreateStudioRequest.Builder> createStudioRequest) {
        return createStudio(CreateStudioRequest.builder().applyMutation(createStudioRequest).build());
    }

    /**
     * <p>
     * Maps a user or group to the Amazon EMR Studio specified by <code>StudioId</code>, and applies a session policy to
     * refine Studio permissions for that user or group. Use <code>CreateStudioSessionMapping</code> to assign users to
     * a Studio when you use IAM Identity Center authentication. For instructions on how to assign users to a Studio
     * when you use IAM authentication, see <a href=
     * "https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups"
     * >Assign a user or group to your EMR Studio</a>.
     * </p>
     *
     * @param createStudioSessionMappingRequest
     * @return A Java Future containing the result of the CreateStudioSessionMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.CreateStudioSessionMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStudioSessionMappingResponse> createStudioSessionMapping(
            CreateStudioSessionMappingRequest createStudioSessionMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Maps a user or group to the Amazon EMR Studio specified by <code>StudioId</code>, and applies a session policy to
     * refine Studio permissions for that user or group. Use <code>CreateStudioSessionMapping</code> to assign users to
     * a Studio when you use IAM Identity Center authentication. For instructions on how to assign users to a Studio
     * when you use IAM authentication, see <a href=
     * "https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups"
     * >Assign a user or group to your EMR Studio</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStudioSessionMappingRequest.Builder} avoiding
     * the need to create one manually via {@link CreateStudioSessionMappingRequest#builder()}
     * </p>
     *
     * @param createStudioSessionMappingRequest
     *        A {@link Consumer} that will call methods on {@link CreateStudioSessionMappingInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateStudioSessionMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.CreateStudioSessionMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStudioSessionMappingResponse> createStudioSessionMapping(
            Consumer<CreateStudioSessionMappingRequest.Builder> createStudioSessionMappingRequest) {
        return createStudioSessionMapping(CreateStudioSessionMappingRequest.builder()
                .applyMutation(createStudioSessionMappingRequest).build());
    }

    /**
     * <p>
     * Deletes a security configuration.
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     * @return A Java Future containing the result of the DeleteSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DeleteSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityConfigurationResponse> deleteSecurityConfiguration(
            DeleteSecurityConfigurationRequest deleteSecurityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a security configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSecurityConfigurationInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSecurityConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DeleteSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityConfigurationResponse> deleteSecurityConfiguration(
            Consumer<DeleteSecurityConfigurationRequest.Builder> deleteSecurityConfigurationRequest) {
        return deleteSecurityConfiguration(DeleteSecurityConfigurationRequest.builder()
                .applyMutation(deleteSecurityConfigurationRequest).build());
    }

    /**
     * <p>
     * Removes an Amazon EMR Studio from the Studio metadata store.
     * </p>
     *
     * @param deleteStudioRequest
     * @return A Java Future containing the result of the DeleteStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DeleteStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStudioResponse> deleteStudio(DeleteStudioRequest deleteStudioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an Amazon EMR Studio from the Studio metadata store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStudioRequest#builder()}
     * </p>
     *
     * @param deleteStudioRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStudioInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DeleteStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteStudioResponse> deleteStudio(Consumer<DeleteStudioRequest.Builder> deleteStudioRequest) {
        return deleteStudio(DeleteStudioRequest.builder().applyMutation(deleteStudioRequest).build());
    }

    /**
     * <p>
     * Removes a user or group from an Amazon EMR Studio.
     * </p>
     *
     * @param deleteStudioSessionMappingRequest
     * @return A Java Future containing the result of the DeleteStudioSessionMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DeleteStudioSessionMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStudioSessionMappingResponse> deleteStudioSessionMapping(
            DeleteStudioSessionMappingRequest deleteStudioSessionMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a user or group from an Amazon EMR Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioSessionMappingRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteStudioSessionMappingRequest#builder()}
     * </p>
     *
     * @param deleteStudioSessionMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStudioSessionMappingInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteStudioSessionMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DeleteStudioSessionMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStudioSessionMappingResponse> deleteStudioSessionMapping(
            Consumer<DeleteStudioSessionMappingRequest.Builder> deleteStudioSessionMappingRequest) {
        return deleteStudioSessionMapping(DeleteStudioSessionMappingRequest.builder()
                .applyMutation(deleteStudioSessionMappingRequest).build());
    }

    /**
     * <p>
     * Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.
     * </p>
     *
     * @param describeClusterRequest
     *        This input determines which cluster to describe.
     * @return A Java Future containing the result of the DescribeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterResponse> describeCluster(DescribeClusterRequest describeClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterInput.Builder} to create a request.
     *        This input determines which cluster to describe.
     * @return A Java Future containing the result of the DescribeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterResponse> describeCluster(
            Consumer<DescribeClusterRequest.Builder> describeClusterRequest) {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     * <p>
     * Provides details of a notebook execution.
     * </p>
     *
     * @param describeNotebookExecutionRequest
     * @return A Java Future containing the result of the DescribeNotebookExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeNotebookExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotebookExecutionResponse> describeNotebookExecution(
            DescribeNotebookExecutionRequest describeNotebookExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details of a notebook execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotebookExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeNotebookExecutionRequest#builder()}
     * </p>
     *
     * @param describeNotebookExecutionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNotebookExecutionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeNotebookExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeNotebookExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotebookExecutionResponse> describeNotebookExecution(
            Consumer<DescribeNotebookExecutionRequest.Builder> describeNotebookExecutionRequest) {
        return describeNotebookExecution(DescribeNotebookExecutionRequest.builder()
                .applyMutation(describeNotebookExecutionRequest).build());
    }

    /**
     * <p>
     * Provides EMR release label details, such as releases available the region where the API request is run, and the
     * available applications for a specific EMR release label. Can also list EMR release versions that support a
     * specified version of Spark.
     * </p>
     *
     * @param describeReleaseLabelRequest
     * @return A Java Future containing the result of the DescribeReleaseLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeReleaseLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeReleaseLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReleaseLabelResponse> describeReleaseLabel(
            DescribeReleaseLabelRequest describeReleaseLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides EMR release label details, such as releases available the region where the API request is run, and the
     * available applications for a specific EMR release label. Can also list EMR release versions that support a
     * specified version of Spark.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReleaseLabelRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReleaseLabelRequest#builder()}
     * </p>
     *
     * @param describeReleaseLabelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReleaseLabelInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeReleaseLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeReleaseLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeReleaseLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReleaseLabelResponse> describeReleaseLabel(
            Consumer<DescribeReleaseLabelRequest.Builder> describeReleaseLabelRequest) {
        return describeReleaseLabel(DescribeReleaseLabelRequest.builder().applyMutation(describeReleaseLabelRequest).build());
    }

    /**
     * <p>
     * Provides the details of a security configuration by returning the configuration JSON.
     * </p>
     *
     * @param describeSecurityConfigurationRequest
     * @return A Java Future containing the result of the DescribeSecurityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSecurityConfigurationResponse> describeSecurityConfiguration(
            DescribeSecurityConfigurationRequest describeSecurityConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details of a security configuration by returning the configuration JSON.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param describeSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSecurityConfigurationInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeSecurityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeSecurityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSecurityConfigurationResponse> describeSecurityConfiguration(
            Consumer<DescribeSecurityConfigurationRequest.Builder> describeSecurityConfigurationRequest) {
        return describeSecurityConfiguration(DescribeSecurityConfigurationRequest.builder()
                .applyMutation(describeSecurityConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides more detail about the cluster step.
     * </p>
     *
     * @param describeStepRequest
     *        This input determines which step to describe.
     * @return A Java Future containing the result of the DescribeStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStep" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStepResponse> describeStep(DescribeStepRequest describeStepRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more detail about the cluster step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStepRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStepRequest#builder()}
     * </p>
     *
     * @param describeStepRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStepInput.Builder} to create a request. This
     *        input determines which step to describe.
     * @return A Java Future containing the result of the DescribeStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStep" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeStepResponse> describeStep(Consumer<DescribeStepRequest.Builder> describeStepRequest) {
        return describeStep(DescribeStepRequest.builder().applyMutation(describeStepRequest).build());
    }

    /**
     * <p>
     * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.
     * </p>
     *
     * @param describeStudioRequest
     * @return A Java Future containing the result of the DescribeStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStudio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStudioResponse> describeStudio(DescribeStudioRequest describeStudioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStudioRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStudioRequest#builder()}
     * </p>
     *
     * @param describeStudioRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStudioInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.DescribeStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStudio"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStudioResponse> describeStudio(Consumer<DescribeStudioRequest.Builder> describeStudioRequest) {
        return describeStudio(DescribeStudioRequest.builder().applyMutation(describeStudioRequest).build());
    }

    /**
     * <p>
     * Returns the auto-termination policy for an Amazon EMR cluster.
     * </p>
     *
     * @param getAutoTerminationPolicyRequest
     * @return A Java Future containing the result of the GetAutoTerminationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetAutoTerminationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetAutoTerminationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutoTerminationPolicyResponse> getAutoTerminationPolicy(
            GetAutoTerminationPolicyRequest getAutoTerminationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the auto-termination policy for an Amazon EMR cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutoTerminationPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetAutoTerminationPolicyRequest#builder()}
     * </p>
     *
     * @param getAutoTerminationPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetAutoTerminationPolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAutoTerminationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetAutoTerminationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetAutoTerminationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAutoTerminationPolicyResponse> getAutoTerminationPolicy(
            Consumer<GetAutoTerminationPolicyRequest.Builder> getAutoTerminationPolicyRequest) {
        return getAutoTerminationPolicy(GetAutoTerminationPolicyRequest.builder().applyMutation(getAutoTerminationPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the current
     * Region. For more information see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     *
     * @param getBlockPublicAccessConfigurationRequest
     * @return A Java Future containing the result of the GetBlockPublicAccessConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetBlockPublicAccessConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetBlockPublicAccessConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBlockPublicAccessConfigurationResponse> getBlockPublicAccessConfiguration(
            GetBlockPublicAccessConfigurationRequest getBlockPublicAccessConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the current
     * Region. For more information see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlockPublicAccessConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetBlockPublicAccessConfigurationRequest#builder()}
     * </p>
     *
     * @param getBlockPublicAccessConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetBlockPublicAccessConfigurationInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetBlockPublicAccessConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetBlockPublicAccessConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetBlockPublicAccessConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBlockPublicAccessConfigurationResponse> getBlockPublicAccessConfiguration(
            Consumer<GetBlockPublicAccessConfigurationRequest.Builder> getBlockPublicAccessConfigurationRequest) {
        return getBlockPublicAccessConfiguration(GetBlockPublicAccessConfigurationRequest.builder()
                .applyMutation(getBlockPublicAccessConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides Temporary, basic HTTP credentials that are associated with a given runtime IAM role and used by a
     * cluster with fine-grained access control activated. You can use these credentials to connect to cluster endpoints
     * that support username-based and password-based authentication.
     * </p>
     *
     * @param getClusterSessionCredentialsRequest
     * @return A Java Future containing the result of the GetClusterSessionCredentials operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetClusterSessionCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetClusterSessionCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClusterSessionCredentialsResponse> getClusterSessionCredentials(
            GetClusterSessionCredentialsRequest getClusterSessionCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides Temporary, basic HTTP credentials that are associated with a given runtime IAM role and used by a
     * cluster with fine-grained access control activated. You can use these credentials to connect to cluster endpoints
     * that support username-based and password-based authentication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterSessionCredentialsRequest.Builder}
     * avoiding the need to create one manually via {@link GetClusterSessionCredentialsRequest#builder()}
     * </p>
     *
     * @param getClusterSessionCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link GetClusterSessionCredentialsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetClusterSessionCredentials operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetClusterSessionCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetClusterSessionCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClusterSessionCredentialsResponse> getClusterSessionCredentials(
            Consumer<GetClusterSessionCredentialsRequest.Builder> getClusterSessionCredentialsRequest) {
        return getClusterSessionCredentials(GetClusterSessionCredentialsRequest.builder()
                .applyMutation(getClusterSessionCredentialsRequest).build());
    }

    /**
     * <p>
     * Fetches the attached managed scaling policy for an Amazon EMR cluster.
     * </p>
     *
     * @param getManagedScalingPolicyRequest
     * @return A Java Future containing the result of the GetManagedScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetManagedScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedScalingPolicyResponse> getManagedScalingPolicy(
            GetManagedScalingPolicyRequest getManagedScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the attached managed scaling policy for an Amazon EMR cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedScalingPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetManagedScalingPolicyRequest#builder()}
     * </p>
     *
     * @param getManagedScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetManagedScalingPolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetManagedScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetManagedScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetManagedScalingPolicyResponse> getManagedScalingPolicy(
            Consumer<GetManagedScalingPolicyRequest.Builder> getManagedScalingPolicyRequest) {
        return getManagedScalingPolicy(GetManagedScalingPolicyRequest.builder().applyMutation(getManagedScalingPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).
     * </p>
     *
     * @param getStudioSessionMappingRequest
     * @return A Java Future containing the result of the GetStudioSessionMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetStudioSessionMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStudioSessionMappingResponse> getStudioSessionMapping(
            GetStudioSessionMappingRequest getStudioSessionMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStudioSessionMappingRequest.Builder} avoiding
     * the need to create one manually via {@link GetStudioSessionMappingRequest#builder()}
     * </p>
     *
     * @param getStudioSessionMappingRequest
     *        A {@link Consumer} that will call methods on {@link GetStudioSessionMappingInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStudioSessionMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.GetStudioSessionMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStudioSessionMappingResponse> getStudioSessionMapping(
            Consumer<GetStudioSessionMappingRequest.Builder> getStudioSessionMappingRequest) {
        return getStudioSessionMapping(GetStudioSessionMappingRequest.builder().applyMutation(getStudioSessionMappingRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the bootstrap actions associated with a cluster.
     * </p>
     *
     * @param listBootstrapActionsRequest
     *        This input determines which bootstrap actions to retrieve.
     * @return A Java Future containing the result of the ListBootstrapActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListBootstrapActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBootstrapActionsResponse> listBootstrapActions(
            ListBootstrapActionsRequest listBootstrapActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the bootstrap actions associated with a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBootstrapActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBootstrapActionsRequest#builder()}
     * </p>
     *
     * @param listBootstrapActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBootstrapActionsInput.Builder} to create a
     *        request. This input determines which bootstrap actions to retrieve.
     * @return A Java Future containing the result of the ListBootstrapActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListBootstrapActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBootstrapActionsResponse> listBootstrapActions(
            Consumer<ListBootstrapActionsRequest.Builder> listBootstrapActionsRequest) {
        return listBootstrapActions(ListBootstrapActionsRequest.builder().applyMutation(listBootstrapActionsRequest).build());
    }

    /**
     * <p>
     * Provides information about the bootstrap actions associated with a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBootstrapActions(software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsPublisher publisher = client.listBootstrapActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsPublisher publisher = client.listBootstrapActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBootstrapActions(software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBootstrapActionsRequest
     *        This input determines which bootstrap actions to retrieve.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListBootstrapActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBootstrapActionsPublisher listBootstrapActionsPaginator(ListBootstrapActionsRequest listBootstrapActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the bootstrap actions associated with a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBootstrapActions(software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsPublisher publisher = client.listBootstrapActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsPublisher publisher = client.listBootstrapActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBootstrapActions(software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBootstrapActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBootstrapActionsRequest#builder()}
     * </p>
     *
     * @param listBootstrapActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBootstrapActionsInput.Builder} to create a
     *        request. This input determines which bootstrap actions to retrieve.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListBootstrapActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBootstrapActionsPublisher listBootstrapActionsPaginator(
            Consumer<ListBootstrapActionsRequest.Builder> listBootstrapActionsRequest) {
        return listBootstrapActionsPaginator(ListBootstrapActionsRequest.builder().applyMutation(listBootstrapActionsRequest)
                .build());
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of
     * clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This
     * call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the
     * cluster list across multiple ListClusters calls.
     * </p>
     *
     * @param listClustersRequest
     *        This input determines how the ListClusters action filters the list of clusters that it returns.
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of
     * clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This
     * call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the
     * cluster list across multiple ListClusters calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on {@link ListClustersInput.Builder} to create a request. This
     *        input determines how the ListClusters action filters the list of clusters that it returns.
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of
     * clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This
     * call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the
     * cluster list across multiple ListClusters calls.
     * </p>
     *
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListClustersResponse> listClusters() {
        return listClusters(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of
     * clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This
     * call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the
     * cluster list across multiple ListClusters calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator() {
        return listClustersPaginator(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of
     * clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This
     * call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the
     * cluster list across multiple ListClusters calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     *        This input determines how the ListClusters action filters the list of clusters that it returns.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(ListClustersRequest listClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of
     * clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This
     * call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the
     * cluster list across multiple ListClusters calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersPublisher publisher = client.listClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on {@link ListClustersInput.Builder} to create a request. This
     *        input determines how the ListClusters action filters the list of clusters that it returns.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersPublisher listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Lists all available details about the instance fleets in a cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note>
     *
     * @param listInstanceFleetsRequest
     * @return A Java Future containing the result of the ListInstanceFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstanceFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceFleetsResponse> listInstanceFleets(ListInstanceFleetsRequest listInstanceFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available details about the instance fleets in a cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceFleetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceFleetsRequest#builder()}
     * </p>
     *
     * @param listInstanceFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceFleetsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListInstanceFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstanceFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceFleetsResponse> listInstanceFleets(
            Consumer<ListInstanceFleetsRequest.Builder> listInstanceFleetsRequest) {
        return listInstanceFleets(ListInstanceFleetsRequest.builder().applyMutation(listInstanceFleetsRequest).build());
    }

    /**
     * <p>
     * Lists all available details about the instance fleets in a cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceFleets(software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsPublisher publisher = client.listInstanceFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsPublisher publisher = client.listInstanceFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceFleets(software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listInstanceFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstanceFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceFleetsPublisher listInstanceFleetsPaginator(ListInstanceFleetsRequest listInstanceFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available details about the instance fleets in a cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceFleets(software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsPublisher publisher = client.listInstanceFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsPublisher publisher = client.listInstanceFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceFleets(software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceFleetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceFleetsRequest#builder()}
     * </p>
     *
     * @param listInstanceFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceFleetsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstanceFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceFleetsPublisher listInstanceFleetsPaginator(
            Consumer<ListInstanceFleetsRequest.Builder> listInstanceFleetsRequest) {
        return listInstanceFleetsPaginator(ListInstanceFleetsRequest.builder().applyMutation(listInstanceFleetsRequest).build());
    }

    /**
     * <p>
     * Provides all available details about the instance groups in a cluster.
     * </p>
     *
     * @param listInstanceGroupsRequest
     *        This input determines which instance groups to retrieve.
     * @return A Java Future containing the result of the ListInstanceGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstanceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceGroupsResponse> listInstanceGroups(ListInstanceGroupsRequest listInstanceGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides all available details about the instance groups in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceGroupsRequest#builder()}
     * </p>
     *
     * @param listInstanceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceGroupsInput.Builder} to create a request.
     *        This input determines which instance groups to retrieve.
     * @return A Java Future containing the result of the ListInstanceGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstanceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceGroupsResponse> listInstanceGroups(
            Consumer<ListInstanceGroupsRequest.Builder> listInstanceGroupsRequest) {
        return listInstanceGroups(ListInstanceGroupsRequest.builder().applyMutation(listInstanceGroupsRequest).build());
    }

    /**
     * <p>
     * Provides all available details about the instance groups in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceGroups(software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsPublisher publisher = client.listInstanceGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsPublisher publisher = client.listInstanceGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceGroups(software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listInstanceGroupsRequest
     *        This input determines which instance groups to retrieve.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstanceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceGroupsPublisher listInstanceGroupsPaginator(ListInstanceGroupsRequest listInstanceGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides all available details about the instance groups in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceGroups(software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsPublisher publisher = client.listInstanceGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsPublisher publisher = client.listInstanceGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceGroups(software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceGroupsRequest#builder()}
     * </p>
     *
     * @param listInstanceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceGroupsInput.Builder} to create a request.
     *        This input determines which instance groups to retrieve.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstanceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceGroupsPublisher listInstanceGroupsPaginator(
            Consumer<ListInstanceGroupsRequest.Builder> listInstanceGroupsRequest) {
        return listInstanceGroupsPaginator(ListInstanceGroupsRequest.builder().applyMutation(listInstanceGroupsRequest).build());
    }

    /**
     * <p>
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a
     * maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT,
     * PROVISIONING, BOOTSTRAPPING, RUNNING.
     * </p>
     *
     * @param listInstancesRequest
     *        This input determines which instances to list.
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a
     * maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT,
     * PROVISIONING, BOOTSTRAPPING, RUNNING.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesInput.Builder} to create a request. This
     *        input determines which instances to list.
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a
     * maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT,
     * PROVISIONING, BOOTSTRAPPING, RUNNING.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.emr.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.emr.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     *        This input determines which instances to list.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(ListInstancesRequest listInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a
     * maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT,
     * PROVISIONING, BOOTSTRAPPING, RUNNING.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.emr.model.ListInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstancesPublisher publisher = client.listInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.emr.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesInput.Builder} to create a request. This
     *        input determines which instances to list.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstancesPublisher listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status,
     * time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a
     * longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.
     * </p>
     *
     * @param listNotebookExecutionsRequest
     * @return A Java Future containing the result of the ListNotebookExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListNotebookExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotebookExecutionsResponse> listNotebookExecutions(
            ListNotebookExecutionsRequest listNotebookExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status,
     * time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a
     * longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotebookExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotebookExecutionsRequest#builder()}
     * </p>
     *
     * @param listNotebookExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotebookExecutionsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNotebookExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListNotebookExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNotebookExecutionsResponse> listNotebookExecutions(
            Consumer<ListNotebookExecutionsRequest.Builder> listNotebookExecutionsRequest) {
        return listNotebookExecutions(ListNotebookExecutionsRequest.builder().applyMutation(listNotebookExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status,
     * time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a
     * longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookExecutions(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsPublisher publisher = client.listNotebookExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsPublisher publisher = client.listNotebookExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookExecutions(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotebookExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListNotebookExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookExecutionsPublisher listNotebookExecutionsPaginator(
            ListNotebookExecutionsRequest listNotebookExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status,
     * time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a
     * longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookExecutions(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsPublisher publisher = client.listNotebookExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsPublisher publisher = client.listNotebookExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookExecutions(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotebookExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotebookExecutionsRequest#builder()}
     * </p>
     *
     * @param listNotebookExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotebookExecutionsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListNotebookExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookExecutionsPublisher listNotebookExecutionsPaginator(
            Consumer<ListNotebookExecutionsRequest.Builder> listNotebookExecutionsRequest) {
        return listNotebookExecutionsPaginator(ListNotebookExecutionsRequest.builder()
                .applyMutation(listNotebookExecutionsRequest).build());
    }

    /**
     * <p>
     * Retrieves release labels of EMR services in the region where the API is called.
     * </p>
     *
     * @param listReleaseLabelsRequest
     * @return A Java Future containing the result of the ListReleaseLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListReleaseLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListReleaseLabels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReleaseLabelsResponse> listReleaseLabels(ListReleaseLabelsRequest listReleaseLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves release labels of EMR services in the region where the API is called.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReleaseLabelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReleaseLabelsRequest#builder()}
     * </p>
     *
     * @param listReleaseLabelsRequest
     *        A {@link Consumer} that will call methods on {@link ListReleaseLabelsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListReleaseLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListReleaseLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListReleaseLabels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReleaseLabelsResponse> listReleaseLabels(
            Consumer<ListReleaseLabelsRequest.Builder> listReleaseLabelsRequest) {
        return listReleaseLabels(ListReleaseLabelsRequest.builder().applyMutation(listReleaseLabelsRequest).build());
    }

    /**
     * <p>
     * Retrieves release labels of EMR services in the region where the API is called.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReleaseLabels(software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListReleaseLabelsPublisher publisher = client.listReleaseLabelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListReleaseLabelsPublisher publisher = client.listReleaseLabelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReleaseLabels(software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest)} operation.</b>
     * </p>
     *
     * @param listReleaseLabelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListReleaseLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListReleaseLabels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReleaseLabelsPublisher listReleaseLabelsPaginator(ListReleaseLabelsRequest listReleaseLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves release labels of EMR services in the region where the API is called.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReleaseLabels(software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListReleaseLabelsPublisher publisher = client.listReleaseLabelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListReleaseLabelsPublisher publisher = client.listReleaseLabelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReleaseLabels(software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReleaseLabelsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReleaseLabelsRequest#builder()}
     * </p>
     *
     * @param listReleaseLabelsRequest
     *        A {@link Consumer} that will call methods on {@link ListReleaseLabelsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListReleaseLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListReleaseLabels"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReleaseLabelsPublisher listReleaseLabelsPaginator(
            Consumer<ListReleaseLabelsRequest.Builder> listReleaseLabelsRequest) {
        return listReleaseLabelsPaginator(ListReleaseLabelsRequest.builder().applyMutation(listReleaseLabelsRequest).build());
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     *
     * @param listSecurityConfigurationsRequest
     * @return A Java Future containing the result of the ListSecurityConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSecurityConfigurationsResponse> listSecurityConfigurations(
            ListSecurityConfigurationsRequest listSecurityConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSecurityConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSecurityConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityConfigurationsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSecurityConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSecurityConfigurationsResponse> listSecurityConfigurations(
            Consumer<ListSecurityConfigurationsRequest.Builder> listSecurityConfigurationsRequest) {
        return listSecurityConfigurations(ListSecurityConfigurationsRequest.builder()
                .applyMutation(listSecurityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     *
     * @return A Java Future containing the result of the ListSecurityConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSecurityConfigurationsResponse> listSecurityConfigurations() {
        return listSecurityConfigurations(ListSecurityConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsPublisher publisher = client.listSecurityConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsPublisher publisher = client.listSecurityConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsPublisher listSecurityConfigurationsPaginator() {
        return listSecurityConfigurationsPaginator(ListSecurityConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsPublisher publisher = client.listSecurityConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsPublisher publisher = client.listSecurityConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsPublisher listSecurityConfigurationsPaginator(
            ListSecurityConfigurationsRequest listSecurityConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsPublisher publisher = client.listSecurityConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsPublisher publisher = client.listSecurityConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSecurityConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSecurityConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityConfigurationsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSecurityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsPublisher listSecurityConfigurationsPaginator(
            Consumer<ListSecurityConfigurationsRequest.Builder> listSecurityConfigurationsRequest) {
        return listSecurityConfigurationsPaginator(ListSecurityConfigurationsRequest.builder()
                .applyMutation(listSecurityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the
     * request or filter by <code>StepStates</code>. You can specify a maximum of 10 <code>stepIDs</code>. The CLI
     * automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the
     * CLI, specify a <code>Marker</code>, which is a pagination token that indicates the next set of steps to retrieve.
     * </p>
     *
     * @param listStepsRequest
     *        This input determines which steps to list.
     * @return A Java Future containing the result of the ListSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStepsResponse> listSteps(ListStepsRequest listStepsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the
     * request or filter by <code>StepStates</code>. You can specify a maximum of 10 <code>stepIDs</code>. The CLI
     * automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the
     * CLI, specify a <code>Marker</code>, which is a pagination token that indicates the next set of steps to retrieve.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStepsRequest#builder()}
     * </p>
     *
     * @param listStepsRequest
     *        A {@link Consumer} that will call methods on {@link ListStepsInput.Builder} to create a request. This
     *        input determines which steps to list.
     * @return A Java Future containing the result of the ListSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStepsResponse> listSteps(Consumer<ListStepsRequest.Builder> listStepsRequest) {
        return listSteps(ListStepsRequest.builder().applyMutation(listStepsRequest).build());
    }

    /**
     * <p>
     * Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the
     * request or filter by <code>StepStates</code>. You can specify a maximum of 10 <code>stepIDs</code>. The CLI
     * automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the
     * CLI, specify a <code>Marker</code>, which is a pagination token that indicates the next set of steps to retrieve.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSteps(software.amazon.awssdk.services.emr.model.ListStepsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStepsPublisher publisher = client.listStepsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStepsPublisher publisher = client.listStepsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListStepsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListStepsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSteps(software.amazon.awssdk.services.emr.model.ListStepsRequest)} operation.</b>
     * </p>
     *
     * @param listStepsRequest
     *        This input determines which steps to list.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepsPublisher listStepsPaginator(ListStepsRequest listStepsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the
     * request or filter by <code>StepStates</code>. You can specify a maximum of 10 <code>stepIDs</code>. The CLI
     * automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the
     * CLI, specify a <code>Marker</code>, which is a pagination token that indicates the next set of steps to retrieve.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSteps(software.amazon.awssdk.services.emr.model.ListStepsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStepsPublisher publisher = client.listStepsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStepsPublisher publisher = client.listStepsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListStepsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListStepsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSteps(software.amazon.awssdk.services.emr.model.ListStepsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStepsRequest#builder()}
     * </p>
     *
     * @param listStepsRequest
     *        A {@link Consumer} that will call methods on {@link ListStepsInput.Builder} to create a request. This
     *        input determines which steps to list.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStepsPublisher listStepsPaginator(Consumer<ListStepsRequest.Builder> listStepsRequest) {
        return listStepsPaginator(ListStepsRequest.builder().applyMutation(listStepsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by <code>StudioId</code>
     * .
     * </p>
     *
     * @param listStudioSessionMappingsRequest
     * @return A Java Future containing the result of the ListStudioSessionMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListStudioSessionMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStudioSessionMappingsResponse> listStudioSessionMappings(
            ListStudioSessionMappingsRequest listStudioSessionMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by <code>StudioId</code>
     * .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudioSessionMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStudioSessionMappingsRequest#builder()}
     * </p>
     *
     * @param listStudioSessionMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListStudioSessionMappingsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListStudioSessionMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListStudioSessionMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStudioSessionMappingsResponse> listStudioSessionMappings(
            Consumer<ListStudioSessionMappingsRequest.Builder> listStudioSessionMappingsRequest) {
        return listStudioSessionMappings(ListStudioSessionMappingsRequest.builder()
                .applyMutation(listStudioSessionMappingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by <code>StudioId</code>
     * .
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStudioSessionMappings(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsPublisher publisher = client.listStudioSessionMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsPublisher publisher = client.listStudioSessionMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioSessionMappings(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStudioSessionMappingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListStudioSessionMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStudioSessionMappingsPublisher listStudioSessionMappingsPaginator(
            ListStudioSessionMappingsRequest listStudioSessionMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by <code>StudioId</code>
     * .
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStudioSessionMappings(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsPublisher publisher = client.listStudioSessionMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsPublisher publisher = client.listStudioSessionMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioSessionMappings(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudioSessionMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStudioSessionMappingsRequest#builder()}
     * </p>
     *
     * @param listStudioSessionMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListStudioSessionMappingsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListStudioSessionMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStudioSessionMappingsPublisher listStudioSessionMappingsPaginator(
            Consumer<ListStudioSessionMappingsRequest.Builder> listStudioSessionMappingsRequest) {
        return listStudioSessionMappingsPaginator(ListStudioSessionMappingsRequest.builder()
                .applyMutation(listStudioSessionMappingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes
     * details such as ID, Studio Access URL, and creation time for each Studio.
     * </p>
     *
     * @param listStudiosRequest
     * @return A Java Future containing the result of the ListStudios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStudiosResponse> listStudios(ListStudiosRequest listStudiosRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes
     * details such as ID, Studio Access URL, and creation time for each Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudiosRequest.Builder} avoiding the need to
     * create one manually via {@link ListStudiosRequest#builder()}
     * </p>
     *
     * @param listStudiosRequest
     *        A {@link Consumer} that will call methods on {@link ListStudiosInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListStudios operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStudiosResponse> listStudios(Consumer<ListStudiosRequest.Builder> listStudiosRequest) {
        return listStudios(ListStudiosRequest.builder().applyMutation(listStudiosRequest).build());
    }

    /**
     * <p>
     * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes
     * details such as ID, Studio Access URL, and creation time for each Studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStudios(software.amazon.awssdk.services.emr.model.ListStudiosRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListStudiosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListStudiosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudios(software.amazon.awssdk.services.emr.model.ListStudiosRequest)} operation.</b>
     * </p>
     *
     * @param listStudiosRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStudiosPublisher listStudiosPaginator(ListStudiosRequest listStudiosRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes
     * details such as ID, Studio Access URL, and creation time for each Studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStudios(software.amazon.awssdk.services.emr.model.ListStudiosRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudiosPublisher publisher = client.listStudiosPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.emr.model.ListStudiosResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.emr.model.ListStudiosResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudios(software.amazon.awssdk.services.emr.model.ListStudiosRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudiosRequest.Builder} avoiding the need to
     * create one manually via {@link ListStudiosRequest#builder()}
     * </p>
     *
     * @param listStudiosRequest
     *        A {@link Consumer} that will call methods on {@link ListStudiosInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStudiosPublisher listStudiosPaginator(Consumer<ListStudiosRequest.Builder> listStudiosRequest) {
        return listStudiosPaginator(ListStudiosRequest.builder().applyMutation(listStudiosRequest).build());
    }

    /**
     * <p>
     * Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.
     * </p>
     *
     * @param modifyClusterRequest
     * @return A Java Future containing the result of the ModifyCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ModifyCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterResponse> modifyCluster(ModifyClusterRequest modifyClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyClusterRequest#builder()}
     * </p>
     *
     * @param modifyClusterRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterInput.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ModifyCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterResponse> modifyCluster(Consumer<ModifyClusterRequest.Builder> modifyClusterRequest) {
        return modifyCluster(ModifyClusterRequest.builder().applyMutation(modifyClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified
     * InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note>
     *
     * @param modifyInstanceFleetRequest
     * @return A Java Future containing the result of the ModifyInstanceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ModifyInstanceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyInstanceFleetResponse> modifyInstanceFleet(
            ModifyInstanceFleetRequest modifyInstanceFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified
     * InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyInstanceFleetRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyInstanceFleetRequest#builder()}
     * </p>
     *
     * @param modifyInstanceFleetRequest
     *        A {@link Consumer} that will call methods on {@link ModifyInstanceFleetInput.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyInstanceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ModifyInstanceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyInstanceFleetResponse> modifyInstanceFleet(
            Consumer<ModifyInstanceFleetRequest.Builder> modifyInstanceFleetRequest) {
        return modifyInstanceFleet(ModifyInstanceFleetRequest.builder().applyMutation(modifyInstanceFleetRequest).build());
    }

    /**
     * <p>
     * ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input
     * parameters include the new target instance count for the group and the instance group ID. The call will either
     * succeed or fail atomically.
     * </p>
     *
     * @param modifyInstanceGroupsRequest
     *        Change the size of some instance groups.
     * @return A Java Future containing the result of the ModifyInstanceGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ModifyInstanceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyInstanceGroupsResponse> modifyInstanceGroups(
            ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input
     * parameters include the new target instance count for the group and the instance group ID. The call will either
     * succeed or fail atomically.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyInstanceGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyInstanceGroupsRequest#builder()}
     * </p>
     *
     * @param modifyInstanceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ModifyInstanceGroupsInput.Builder} to create a
     *        request. Change the size of some instance groups.
     * @return A Java Future containing the result of the ModifyInstanceGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.ModifyInstanceGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyInstanceGroupsResponse> modifyInstanceGroups(
            Consumer<ModifyInstanceGroupsRequest.Builder> modifyInstanceGroupsRequest) {
        return modifyInstanceGroups(ModifyInstanceGroupsRequest.builder().applyMutation(modifyInstanceGroupsRequest).build());
    }

    /**
     * <p>
     * Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR
     * cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances
     * in response to the value of a CloudWatch metric.
     * </p>
     *
     * @param putAutoScalingPolicyRequest
     * @return A Java Future containing the result of the PutAutoScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.PutAutoScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAutoScalingPolicyResponse> putAutoScalingPolicy(
            PutAutoScalingPolicyRequest putAutoScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR
     * cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances
     * in response to the value of a CloudWatch metric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAutoScalingPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutAutoScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putAutoScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutAutoScalingPolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAutoScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.PutAutoScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAutoScalingPolicyResponse> putAutoScalingPolicy(
            Consumer<PutAutoScalingPolicyRequest.Builder> putAutoScalingPolicyRequest) {
        return putAutoScalingPolicy(PutAutoScalingPolicyRequest.builder().applyMutation(putAutoScalingPolicyRequest).build());
    }

    /**
     * <note>
     * <p>
     * Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html">Using an
     * auto-termination policy</a>.
     * </p>
     * </note>
     * <p>
     * Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the
     * amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster
     * termination options, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster
     * termination</a>.
     * </p>
     *
     * @param putAutoTerminationPolicyRequest
     * @return A Java Future containing the result of the PutAutoTerminationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.PutAutoTerminationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoTerminationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAutoTerminationPolicyResponse> putAutoTerminationPolicy(
            PutAutoTerminationPolicyRequest putAutoTerminationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html">Using an
     * auto-termination policy</a>.
     * </p>
     * </note>
     * <p>
     * Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the
     * amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster
     * termination options, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster
     * termination</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAutoTerminationPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutAutoTerminationPolicyRequest#builder()}
     * </p>
     *
     * @param putAutoTerminationPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutAutoTerminationPolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutAutoTerminationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.PutAutoTerminationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoTerminationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAutoTerminationPolicyResponse> putAutoTerminationPolicy(
            Consumer<PutAutoTerminationPolicyRequest.Builder> putAutoTerminationPolicyRequest) {
        return putAutoTerminationPolicy(PutAutoTerminationPolicyRequest.builder().applyMutation(putAutoTerminationPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the
     * current Region. For more information see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     *
     * @param putBlockPublicAccessConfigurationRequest
     * @return A Java Future containing the result of the PutBlockPublicAccessConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.PutBlockPublicAccessConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutBlockPublicAccessConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBlockPublicAccessConfigurationResponse> putBlockPublicAccessConfiguration(
            PutBlockPublicAccessConfigurationRequest putBlockPublicAccessConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the
     * current Region. For more information see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBlockPublicAccessConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBlockPublicAccessConfigurationRequest#builder()}
     * </p>
     *
     * @param putBlockPublicAccessConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutBlockPublicAccessConfigurationInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutBlockPublicAccessConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.PutBlockPublicAccessConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutBlockPublicAccessConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBlockPublicAccessConfigurationResponse> putBlockPublicAccessConfiguration(
            Consumer<PutBlockPublicAccessConfigurationRequest.Builder> putBlockPublicAccessConfigurationRequest) {
        return putBlockPublicAccessConfiguration(PutBlockPublicAccessConfigurationRequest.builder()
                .applyMutation(putBlockPublicAccessConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the
     * limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only
     * applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * </p>
     *
     * @param putManagedScalingPolicyRequest
     * @return A Java Future containing the result of the PutManagedScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.PutManagedScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutManagedScalingPolicyResponse> putManagedScalingPolicy(
            PutManagedScalingPolicyRequest putManagedScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the
     * limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only
     * applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutManagedScalingPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutManagedScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putManagedScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutManagedScalingPolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutManagedScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.PutManagedScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutManagedScalingPolicyResponse> putManagedScalingPolicy(
            Consumer<PutManagedScalingPolicyRequest.Builder> putManagedScalingPolicyRequest) {
        return putManagedScalingPolicy(PutManagedScalingPolicyRequest.builder().applyMutation(putManagedScalingPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Removes an automatic scaling policy from a specified instance group within an EMR cluster.
     * </p>
     *
     * @param removeAutoScalingPolicyRequest
     * @return A Java Future containing the result of the RemoveAutoScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RemoveAutoScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveAutoScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAutoScalingPolicyResponse> removeAutoScalingPolicy(
            RemoveAutoScalingPolicyRequest removeAutoScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an automatic scaling policy from a specified instance group within an EMR cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAutoScalingPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveAutoScalingPolicyRequest#builder()}
     * </p>
     *
     * @param removeAutoScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link RemoveAutoScalingPolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveAutoScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RemoveAutoScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveAutoScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAutoScalingPolicyResponse> removeAutoScalingPolicy(
            Consumer<RemoveAutoScalingPolicyRequest.Builder> removeAutoScalingPolicyRequest) {
        return removeAutoScalingPolicy(RemoveAutoScalingPolicyRequest.builder().applyMutation(removeAutoScalingPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Removes an auto-termination policy from an Amazon EMR cluster.
     * </p>
     *
     * @param removeAutoTerminationPolicyRequest
     * @return A Java Future containing the result of the RemoveAutoTerminationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RemoveAutoTerminationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveAutoTerminationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAutoTerminationPolicyResponse> removeAutoTerminationPolicy(
            RemoveAutoTerminationPolicyRequest removeAutoTerminationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an auto-termination policy from an Amazon EMR cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAutoTerminationPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveAutoTerminationPolicyRequest#builder()}
     * </p>
     *
     * @param removeAutoTerminationPolicyRequest
     *        A {@link Consumer} that will call methods on {@link RemoveAutoTerminationPolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveAutoTerminationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RemoveAutoTerminationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveAutoTerminationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAutoTerminationPolicyResponse> removeAutoTerminationPolicy(
            Consumer<RemoveAutoTerminationPolicyRequest.Builder> removeAutoTerminationPolicyRequest) {
        return removeAutoTerminationPolicy(RemoveAutoTerminationPolicyRequest.builder()
                .applyMutation(removeAutoTerminationPolicyRequest).build());
    }

    /**
     * <p>
     * Removes a managed scaling policy from a specified EMR cluster.
     * </p>
     *
     * @param removeManagedScalingPolicyRequest
     * @return A Java Future containing the result of the RemoveManagedScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RemoveManagedScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveManagedScalingPolicyResponse> removeManagedScalingPolicy(
            RemoveManagedScalingPolicyRequest removeManagedScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a managed scaling policy from a specified EMR cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveManagedScalingPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveManagedScalingPolicyRequest#builder()}
     * </p>
     *
     * @param removeManagedScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link RemoveManagedScalingPolicyInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveManagedScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RemoveManagedScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveManagedScalingPolicyResponse> removeManagedScalingPolicy(
            Consumer<RemoveManagedScalingPolicyRequest.Builder> removeManagedScalingPolicyRequest) {
        return removeManagedScalingPolicy(RemoveManagedScalingPolicyRequest.builder()
                .applyMutation(removeManagedScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to
     * associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation
     * costs. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>.
     * </p>
     * <p>
     * The following example removes the stack tag with value Prod from a cluster:
     * </p>
     *
     * @param removeTagsRequest
     *        This input identifies an Amazon EMR resource and a list of tags to remove.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveTags" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to
     * associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation
     * costs. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>.
     * </p>
     * <p>
     * The following example removes the stack tag with value Prod from a cluster:
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsInput.Builder} to create a request. This
     *        input identifies an Amazon EMR resource and a list of tags to remove.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveTags" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveTagsResponse> removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the
     * steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last
     * step of the job flow to store results in Amazon S3. If the <a>JobFlowInstancesConfig</a>
     * <code>KeepJobFlowAliveWhenNoSteps</code> parameter is set to <code>TRUE</code>, the cluster transitions to the
     * WAITING state rather than shutting down after the steps have completed.
     * </p>
     * <p>
     * For additional protection, you can set the <a>JobFlowInstancesConfig</a> <code>TerminationProtected</code>
     * parameter to <code>TRUE</code> to lock the cluster and prevent it from being terminated by API call, user
     * intervention, or in the event of a job flow error.
     * </p>
     * <p>
     * A maximum of 256 steps are allowed in each job flow.
     * </p>
     * <p>
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps
     * to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to
     * connect to the master node and submitting queries directly to the software running on the master node, such as
     * Hive and Hadoop.
     * </p>
     * <p>
     * For long-running clusters, we recommend that you periodically store your results.
     * </p>
     * <note>
     * <p>
     * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not
     * both.
     * </p>
     * </note>
     *
     * @param runJobFlowRequest
     *        Input to the <a>RunJobFlow</a> operation.
     * @return A Java Future containing the result of the RunJobFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RunJobFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RunJobFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RunJobFlowResponse> runJobFlow(RunJobFlowRequest runJobFlowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the
     * steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last
     * step of the job flow to store results in Amazon S3. If the <a>JobFlowInstancesConfig</a>
     * <code>KeepJobFlowAliveWhenNoSteps</code> parameter is set to <code>TRUE</code>, the cluster transitions to the
     * WAITING state rather than shutting down after the steps have completed.
     * </p>
     * <p>
     * For additional protection, you can set the <a>JobFlowInstancesConfig</a> <code>TerminationProtected</code>
     * parameter to <code>TRUE</code> to lock the cluster and prevent it from being terminated by API call, user
     * intervention, or in the event of a job flow error.
     * </p>
     * <p>
     * A maximum of 256 steps are allowed in each job flow.
     * </p>
     * <p>
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps
     * to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to
     * connect to the master node and submitting queries directly to the software running on the master node, such as
     * Hive and Hadoop.
     * </p>
     * <p>
     * For long-running clusters, we recommend that you periodically store your results.
     * </p>
     * <note>
     * <p>
     * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not
     * both.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RunJobFlowRequest.Builder} avoiding the need to
     * create one manually via {@link RunJobFlowRequest#builder()}
     * </p>
     *
     * @param runJobFlowRequest
     *        A {@link Consumer} that will call methods on {@link RunJobFlowInput.Builder} to create a request. Input to
     *        the <a>RunJobFlow</a> operation.
     * @return A Java Future containing the result of the RunJobFlow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.RunJobFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RunJobFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RunJobFlowResponse> runJobFlow(Consumer<RunJobFlowRequest.Builder> runJobFlowRequest) {
        return runJobFlow(RunJobFlowRequest.builder().applyMutation(runJobFlowRequest).build());
    }

    /**
     * <p>
     * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by
     * user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful
     * completion of the job flow. Calling <code>SetTerminationProtection</code> on a cluster is similar to calling the
     * Amazon EC2 <code>DisableAPITermination</code> API on all EC2 instances in a cluster.
     * </p>
     * <p>
     * <code>SetTerminationProtection</code> is used to prevent accidental termination of a cluster and to ensure that
     * in the event of an error, the instances persist so that you can recover any data stored in their ephemeral
     * instance storage.
     * </p>
     * <p>
     * To terminate a cluster that has been locked by setting <code>SetTerminationProtection</code> to <code>true</code>
     * , you must first unlock the job flow by a subsequent call to <code>SetTerminationProtection</code> in which you
     * set the value to <code>false</code>.
     * </p>
     * <p>
     * For more information, see<a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html">Managing
     * Cluster Termination</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     *
     * @param setTerminationProtectionRequest
     *        The input argument to the <a>TerminationProtection</a> operation.
     * @return A Java Future containing the result of the SetTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.SetTerminationProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTerminationProtectionResponse> setTerminationProtection(
            SetTerminationProtectionRequest setTerminationProtectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by
     * user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful
     * completion of the job flow. Calling <code>SetTerminationProtection</code> on a cluster is similar to calling the
     * Amazon EC2 <code>DisableAPITermination</code> API on all EC2 instances in a cluster.
     * </p>
     * <p>
     * <code>SetTerminationProtection</code> is used to prevent accidental termination of a cluster and to ensure that
     * in the event of an error, the instances persist so that you can recover any data stored in their ephemeral
     * instance storage.
     * </p>
     * <p>
     * To terminate a cluster that has been locked by setting <code>SetTerminationProtection</code> to <code>true</code>
     * , you must first unlock the job flow by a subsequent call to <code>SetTerminationProtection</code> in which you
     * set the value to <code>false</code>.
     * </p>
     * <p>
     * For more information, see<a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html">Managing
     * Cluster Termination</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTerminationProtectionRequest.Builder} avoiding
     * the need to create one manually via {@link SetTerminationProtectionRequest#builder()}
     * </p>
     *
     * @param setTerminationProtectionRequest
     *        A {@link Consumer} that will call methods on {@link SetTerminationProtectionInput.Builder} to create a
     *        request. The input argument to the <a>TerminationProtection</a> operation.
     * @return A Java Future containing the result of the SetTerminationProtection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.SetTerminationProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetTerminationProtectionResponse> setTerminationProtection(
            Consumer<SetTerminationProtectionRequest.Builder> setTerminationProtectionRequest) {
        return setTerminationProtection(SetTerminationProtectionRequest.builder().applyMutation(setTerminationProtectionRequest)
                .build());
    }

    /**
     * <important>
     * <p>
     * The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your
     * account. To restrict cluster access using an IAM policy, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html">Identity and Access
     * Management for EMR</a>.
     * </p>
     * </important>
     * <p>
     * Sets the <a>Cluster&#36VisibleToAllUsers</a> value for an EMR cluster. When <code>true</code>, IAM principals in
     * the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When
     * <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user
     * can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.
     * </p>
     * <p>
     * This action works on running clusters. When you create a cluster, use the
     * <a>RunJobFlowInput&#36VisibleToAllUsers</a> parameter.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users"
     * >Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.
     * </p>
     *
     * @param setVisibleToAllUsersRequest
     *        The input to the SetVisibleToAllUsers action.
     * @return A Java Future containing the result of the SetVisibleToAllUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.SetVisibleToAllUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetVisibleToAllUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetVisibleToAllUsersResponse> setVisibleToAllUsers(
            SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <important>
     * <p>
     * The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your
     * account. To restrict cluster access using an IAM policy, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html">Identity and Access
     * Management for EMR</a>.
     * </p>
     * </important>
     * <p>
     * Sets the <a>Cluster&#36VisibleToAllUsers</a> value for an EMR cluster. When <code>true</code>, IAM principals in
     * the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When
     * <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user
     * can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.
     * </p>
     * <p>
     * This action works on running clusters. When you create a cluster, use the
     * <a>RunJobFlowInput&#36VisibleToAllUsers</a> parameter.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users"
     * >Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetVisibleToAllUsersRequest.Builder} avoiding the
     * need to create one manually via {@link SetVisibleToAllUsersRequest#builder()}
     * </p>
     *
     * @param setVisibleToAllUsersRequest
     *        A {@link Consumer} that will call methods on {@link SetVisibleToAllUsersInput.Builder} to create a
     *        request. The input to the SetVisibleToAllUsers action.
     * @return A Java Future containing the result of the SetVisibleToAllUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.SetVisibleToAllUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetVisibleToAllUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetVisibleToAllUsersResponse> setVisibleToAllUsers(
            Consumer<SetVisibleToAllUsersRequest.Builder> setVisibleToAllUsersRequest) {
        return setVisibleToAllUsers(SetVisibleToAllUsersRequest.builder().applyMutation(setVisibleToAllUsersRequest).build());
    }

    /**
     * <p>
     * Starts a notebook execution.
     * </p>
     *
     * @param startNotebookExecutionRequest
     * @return A Java Future containing the result of the StartNotebookExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.StartNotebookExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StartNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartNotebookExecutionResponse> startNotebookExecution(
            StartNotebookExecutionRequest startNotebookExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a notebook execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartNotebookExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartNotebookExecutionRequest#builder()}
     * </p>
     *
     * @param startNotebookExecutionRequest
     *        A {@link Consumer} that will call methods on {@link StartNotebookExecutionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartNotebookExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.StartNotebookExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StartNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartNotebookExecutionResponse> startNotebookExecution(
            Consumer<StartNotebookExecutionRequest.Builder> startNotebookExecutionRequest) {
        return startNotebookExecution(StartNotebookExecutionRequest.builder().applyMutation(startNotebookExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Stops a notebook execution.
     * </p>
     *
     * @param stopNotebookExecutionRequest
     * @return A Java Future containing the result of the StopNotebookExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.StopNotebookExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StopNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopNotebookExecutionResponse> stopNotebookExecution(
            StopNotebookExecutionRequest stopNotebookExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a notebook execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopNotebookExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StopNotebookExecutionRequest#builder()}
     * </p>
     *
     * @param stopNotebookExecutionRequest
     *        A {@link Consumer} that will call methods on {@link StopNotebookExecutionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopNotebookExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.StopNotebookExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StopNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopNotebookExecutionResponse> stopNotebookExecution(
            Consumer<StopNotebookExecutionRequest.Builder> stopNotebookExecutionRequest) {
        return stopNotebookExecution(StopNotebookExecutionRequest.builder().applyMutation(stopNotebookExecutionRequest).build());
    }

    /**
     * <p>
     * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet
     * completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not
     * already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.
     * </p>
     * <p>
     * The maximum number of clusters allowed is 10. The call to <code>TerminateJobFlows</code> is asynchronous.
     * Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely
     * terminate and release allocated resources, such as Amazon EC2 instances.
     * </p>
     *
     * @param terminateJobFlowsRequest
     *        Input to the <a>TerminateJobFlows</a> operation.
     * @return A Java Future containing the result of the TerminateJobFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.TerminateJobFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/TerminateJobFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateJobFlowsResponse> terminateJobFlows(TerminateJobFlowsRequest terminateJobFlowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet
     * completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not
     * already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.
     * </p>
     * <p>
     * The maximum number of clusters allowed is 10. The call to <code>TerminateJobFlows</code> is asynchronous.
     * Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely
     * terminate and release allocated resources, such as Amazon EC2 instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateJobFlowsRequest.Builder} avoiding the need
     * to create one manually via {@link TerminateJobFlowsRequest#builder()}
     * </p>
     *
     * @param terminateJobFlowsRequest
     *        A {@link Consumer} that will call methods on {@link TerminateJobFlowsInput.Builder} to create a request.
     *        Input to the <a>TerminateJobFlows</a> operation.
     * @return A Java Future containing the result of the TerminateJobFlows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.TerminateJobFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/TerminateJobFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateJobFlowsResponse> terminateJobFlows(
            Consumer<TerminateJobFlowsRequest.Builder> terminateJobFlowsRequest) {
        return terminateJobFlows(TerminateJobFlowsRequest.builder().applyMutation(terminateJobFlowsRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.
     * </p>
     *
     * @param updateStudioRequest
     * @return A Java Future containing the result of the UpdateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.UpdateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStudioResponse> updateStudio(UpdateStudioRequest updateStudioRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStudioRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStudioRequest#builder()}
     * </p>
     *
     * @param updateStudioRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStudioInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateStudio operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException This exception occurs when there is an internal failure in the Amazon EMR
     *         service.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.UpdateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateStudioResponse> updateStudio(Consumer<UpdateStudioRequest.Builder> updateStudioRequest) {
        return updateStudio(UpdateStudioRequest.builder().applyMutation(updateStudioRequest).build());
    }

    /**
     * <p>
     * Updates the session policy attached to the user or group for the specified Amazon EMR Studio.
     * </p>
     *
     * @param updateStudioSessionMappingRequest
     * @return A Java Future containing the result of the UpdateStudioSessionMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.UpdateStudioSessionMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStudioSessionMappingResponse> updateStudioSessionMapping(
            UpdateStudioSessionMappingRequest updateStudioSessionMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the session policy attached to the user or group for the specified Amazon EMR Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStudioSessionMappingRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateStudioSessionMappingRequest#builder()}
     * </p>
     *
     * @param updateStudioSessionMappingRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStudioSessionMappingInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateStudioSessionMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException Indicates that an error occurred while processing the request and that
     *         the request was not completed.</li>
     *         <li>InvalidRequestException This exception occurs when there is something wrong with user input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>EmrException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample EmrAsyncClient.UpdateStudioSessionMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStudioSessionMappingResponse> updateStudioSessionMapping(
            Consumer<UpdateStudioSessionMappingRequest.Builder> updateStudioSessionMappingRequest) {
        return updateStudioSessionMapping(UpdateStudioSessionMappingRequest.builder()
                .applyMutation(updateStudioSessionMappingRequest).build());
    }

    /**
     * Create an instance of {@link EmrAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link EmrAsyncWaiter}
     */
    default EmrAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link EmrAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EmrAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EmrAsyncClient}.
     */
    static EmrAsyncClientBuilder builder() {
        return new DefaultEmrAsyncClientBuilder();
    }
}
