/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Modify the size or configurations of an instance group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceGroupModifyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceGroupModifyConfig.Builder, InstanceGroupModifyConfig> {
    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupId").getter(getter(InstanceGroupModifyConfig::instanceGroupId))
            .setter(setter(Builder::instanceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(InstanceGroupModifyConfig::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<List<String>> EC2_INSTANCE_IDS_TO_TERMINATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EC2InstanceIdsToTerminate")
            .getter(getter(InstanceGroupModifyConfig::ec2InstanceIdsToTerminate))
            .setter(setter(Builder::ec2InstanceIdsToTerminate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceIdsToTerminate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ShrinkPolicy> SHRINK_POLICY_FIELD = SdkField.<ShrinkPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("ShrinkPolicy").getter(getter(InstanceGroupModifyConfig::shrinkPolicy))
            .setter(setter(Builder::shrinkPolicy)).constructor(ShrinkPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShrinkPolicy").build()).build();

    private static final SdkField<String> RECONFIGURATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReconfigurationType").getter(getter(InstanceGroupModifyConfig::reconfigurationTypeAsString))
            .setter(setter(Builder::reconfigurationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReconfigurationType").build())
            .build();

    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField
            .<List<Configuration>> builder(MarshallingType.LIST)
            .memberName("Configurations")
            .getter(getter(InstanceGroupModifyConfig::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Configuration> builder(MarshallingType.SDK_POJO)
                                            .constructor(Configuration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_ID_FIELD,
            INSTANCE_COUNT_FIELD, EC2_INSTANCE_IDS_TO_TERMINATE_FIELD, SHRINK_POLICY_FIELD, RECONFIGURATION_TYPE_FIELD,
            CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceGroupId;

    private final Integer instanceCount;

    private final List<String> ec2InstanceIdsToTerminate;

    private final ShrinkPolicy shrinkPolicy;

    private final String reconfigurationType;

    private final List<Configuration> configurations;

    private InstanceGroupModifyConfig(BuilderImpl builder) {
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceCount = builder.instanceCount;
        this.ec2InstanceIdsToTerminate = builder.ec2InstanceIdsToTerminate;
        this.shrinkPolicy = builder.shrinkPolicy;
        this.reconfigurationType = builder.reconfigurationType;
        this.configurations = builder.configurations;
    }

    /**
     * <p>
     * Unique ID of the instance group to modify.
     * </p>
     * 
     * @return Unique ID of the instance group to modify.
     */
    public final String instanceGroupId() {
        return instanceGroupId;
    }

    /**
     * <p>
     * Target size for the instance group.
     * </p>
     * 
     * @return Target size for the instance group.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the EC2InstanceIdsToTerminate property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEc2InstanceIdsToTerminate() {
        return ec2InstanceIdsToTerminate != null && !(ec2InstanceIdsToTerminate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The EC2 InstanceIds to terminate. After you terminate the instances, the instance group will not return to its
     * original requested size.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InstanceIdsToTerminate} method.
     * </p>
     * 
     * @return The EC2 InstanceIds to terminate. After you terminate the instances, the instance group will not return
     *         to its original requested size.
     */
    public final List<String> ec2InstanceIdsToTerminate() {
        return ec2InstanceIdsToTerminate;
    }

    /**
     * <p>
     * Policy for customizing shrink operations.
     * </p>
     * 
     * @return Policy for customizing shrink operations.
     */
    public final ShrinkPolicy shrinkPolicy() {
        return shrinkPolicy;
    }

    /**
     * <p>
     * Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reconfigurationType} will return {@link ReconfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reconfigurationTypeAsString}.
     * </p>
     * 
     * @return Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
     * @see ReconfigurationType
     */
    public final ReconfigurationType reconfigurationType() {
        return ReconfigurationType.fromValue(reconfigurationType);
    }

    /**
     * <p>
     * Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reconfigurationType} will return {@link ReconfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reconfigurationTypeAsString}.
     * </p>
     * 
     * @return Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
     * @see ReconfigurationType
     */
    public final String reconfigurationTypeAsString() {
        return reconfigurationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configurations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of new or modified configurations to apply for an instance group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return A list of new or modified configurations to apply for an instance group.
     */
    public final List<Configuration> configurations() {
        return configurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceIdsToTerminate() ? ec2InstanceIdsToTerminate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(shrinkPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(reconfigurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupModifyConfig)) {
            return false;
        }
        InstanceGroupModifyConfig other = (InstanceGroupModifyConfig) obj;
        return Objects.equals(instanceGroupId(), other.instanceGroupId())
                && Objects.equals(instanceCount(), other.instanceCount())
                && hasEc2InstanceIdsToTerminate() == other.hasEc2InstanceIdsToTerminate()
                && Objects.equals(ec2InstanceIdsToTerminate(), other.ec2InstanceIdsToTerminate())
                && Objects.equals(shrinkPolicy(), other.shrinkPolicy())
                && Objects.equals(reconfigurationTypeAsString(), other.reconfigurationTypeAsString())
                && hasConfigurations() == other.hasConfigurations() && Objects.equals(configurations(), other.configurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceGroupModifyConfig").add("InstanceGroupId", instanceGroupId())
                .add("InstanceCount", instanceCount())
                .add("EC2InstanceIdsToTerminate", hasEc2InstanceIdsToTerminate() ? ec2InstanceIdsToTerminate() : null)
                .add("ShrinkPolicy", shrinkPolicy()).add("ReconfigurationType", reconfigurationTypeAsString())
                .add("Configurations", hasConfigurations() ? configurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroupId":
            return Optional.ofNullable(clazz.cast(instanceGroupId()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "EC2InstanceIdsToTerminate":
            return Optional.ofNullable(clazz.cast(ec2InstanceIdsToTerminate()));
        case "ShrinkPolicy":
            return Optional.ofNullable(clazz.cast(shrinkPolicy()));
        case "ReconfigurationType":
            return Optional.ofNullable(clazz.cast(reconfigurationTypeAsString()));
        case "Configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroupModifyConfig, T> g) {
        return obj -> g.apply((InstanceGroupModifyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceGroupModifyConfig> {
        /**
         * <p>
         * Unique ID of the instance group to modify.
         * </p>
         * 
         * @param instanceGroupId
         *        Unique ID of the instance group to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupId(String instanceGroupId);

        /**
         * <p>
         * Target size for the instance group.
         * </p>
         * 
         * @param instanceCount
         *        Target size for the instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The EC2 InstanceIds to terminate. After you terminate the instances, the instance group will not return to
         * its original requested size.
         * </p>
         * 
         * @param ec2InstanceIdsToTerminate
         *        The EC2 InstanceIds to terminate. After you terminate the instances, the instance group will not
         *        return to its original requested size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceIdsToTerminate(Collection<String> ec2InstanceIdsToTerminate);

        /**
         * <p>
         * The EC2 InstanceIds to terminate. After you terminate the instances, the instance group will not return to
         * its original requested size.
         * </p>
         * 
         * @param ec2InstanceIdsToTerminate
         *        The EC2 InstanceIds to terminate. After you terminate the instances, the instance group will not
         *        return to its original requested size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceIdsToTerminate(String... ec2InstanceIdsToTerminate);

        /**
         * <p>
         * Policy for customizing shrink operations.
         * </p>
         * 
         * @param shrinkPolicy
         *        Policy for customizing shrink operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shrinkPolicy(ShrinkPolicy shrinkPolicy);

        /**
         * <p>
         * Policy for customizing shrink operations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShrinkPolicy.Builder} avoiding the need
         * to create one manually via {@link ShrinkPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShrinkPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #shrinkPolicy(ShrinkPolicy)}.
         * 
         * @param shrinkPolicy
         *        a consumer that will call methods on {@link ShrinkPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shrinkPolicy(ShrinkPolicy)
         */
        default Builder shrinkPolicy(Consumer<ShrinkPolicy.Builder> shrinkPolicy) {
            return shrinkPolicy(ShrinkPolicy.builder().applyMutation(shrinkPolicy).build());
        }

        /**
         * <p>
         * Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
         * </p>
         * 
         * @param reconfigurationType
         *        Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
         * @see ReconfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconfigurationType
         */
        Builder reconfigurationType(String reconfigurationType);

        /**
         * <p>
         * Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
         * </p>
         * 
         * @param reconfigurationType
         *        Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.
         * @see ReconfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReconfigurationType
         */
        Builder reconfigurationType(ReconfigurationType reconfigurationType);

        /**
         * <p>
         * A list of new or modified configurations to apply for an instance group.
         * </p>
         * 
         * @param configurations
         *        A list of new or modified configurations to apply for an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<Configuration> configurations);

        /**
         * <p>
         * A list of new or modified configurations to apply for an instance group.
         * </p>
         * 
         * @param configurations
         *        A list of new or modified configurations to apply for an instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Configuration... configurations);

        /**
         * <p>
         * A list of new or modified configurations to apply for an instance group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.Configuration.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.emr.model.Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #configurations(List<Configuration>)}.
         * 
         * @param configurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurations(java.util.Collection<Configuration>)
         */
        Builder configurations(Consumer<Configuration.Builder>... configurations);
    }

    static final class BuilderImpl implements Builder {
        private String instanceGroupId;

        private Integer instanceCount;

        private List<String> ec2InstanceIdsToTerminate = DefaultSdkAutoConstructList.getInstance();

        private ShrinkPolicy shrinkPolicy;

        private String reconfigurationType;

        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupModifyConfig model) {
            instanceGroupId(model.instanceGroupId);
            instanceCount(model.instanceCount);
            ec2InstanceIdsToTerminate(model.ec2InstanceIdsToTerminate);
            shrinkPolicy(model.shrinkPolicy);
            reconfigurationType(model.reconfigurationType);
            configurations(model.configurations);
        }

        public final String getInstanceGroupId() {
            return instanceGroupId;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Collection<String> getEc2InstanceIdsToTerminate() {
            if (ec2InstanceIdsToTerminate instanceof SdkAutoConstructList) {
                return null;
            }
            return ec2InstanceIdsToTerminate;
        }

        public final void setEc2InstanceIdsToTerminate(Collection<String> ec2InstanceIdsToTerminate) {
            this.ec2InstanceIdsToTerminate = EC2InstanceIdsToTerminateListCopier.copy(ec2InstanceIdsToTerminate);
        }

        @Override
        public final Builder ec2InstanceIdsToTerminate(Collection<String> ec2InstanceIdsToTerminate) {
            this.ec2InstanceIdsToTerminate = EC2InstanceIdsToTerminateListCopier.copy(ec2InstanceIdsToTerminate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceIdsToTerminate(String... ec2InstanceIdsToTerminate) {
            ec2InstanceIdsToTerminate(Arrays.asList(ec2InstanceIdsToTerminate));
            return this;
        }

        public final ShrinkPolicy.Builder getShrinkPolicy() {
            return shrinkPolicy != null ? shrinkPolicy.toBuilder() : null;
        }

        public final void setShrinkPolicy(ShrinkPolicy.BuilderImpl shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy != null ? shrinkPolicy.build() : null;
        }

        @Override
        public final Builder shrinkPolicy(ShrinkPolicy shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy;
            return this;
        }

        public final String getReconfigurationType() {
            return reconfigurationType;
        }

        public final void setReconfigurationType(String reconfigurationType) {
            this.reconfigurationType = reconfigurationType;
        }

        @Override
        public final Builder reconfigurationType(String reconfigurationType) {
            this.reconfigurationType = reconfigurationType;
            return this;
        }

        @Override
        public final Builder reconfigurationType(ReconfigurationType reconfigurationType) {
            this.reconfigurationType(reconfigurationType == null ? null : reconfigurationType.toString());
            return this;
        }

        public final List<Configuration.Builder> getConfigurations() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder>... configurations) {
            configurations(Stream.of(configurations).map(c -> Configuration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InstanceGroupModifyConfig build() {
            return new InstanceGroupModifyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
