/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.OnDemandResizingSpecification;
import software.amazon.awssdk.services.emr.model.SpotResizingSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceFleetResizingSpecifications
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceFleetResizingSpecifications> {
    private static final SdkField<SpotResizingSpecification> SPOT_RESIZE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpotResizeSpecification").getter(InstanceFleetResizingSpecifications.getter(InstanceFleetResizingSpecifications::spotResizeSpecification)).setter(InstanceFleetResizingSpecifications.setter(Builder::spotResizeSpecification)).constructor(SpotResizingSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotResizeSpecification").build()}).build();
    private static final SdkField<OnDemandResizingSpecification> ON_DEMAND_RESIZE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandResizeSpecification").getter(InstanceFleetResizingSpecifications.getter(InstanceFleetResizingSpecifications::onDemandResizeSpecification)).setter(InstanceFleetResizingSpecifications.setter(Builder::onDemandResizeSpecification)).constructor(OnDemandResizingSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandResizeSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_RESIZE_SPECIFICATION_FIELD, ON_DEMAND_RESIZE_SPECIFICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final SpotResizingSpecification spotResizeSpecification;
    private final OnDemandResizingSpecification onDemandResizeSpecification;

    private InstanceFleetResizingSpecifications(BuilderImpl builder) {
        this.spotResizeSpecification = builder.spotResizeSpecification;
        this.onDemandResizeSpecification = builder.onDemandResizeSpecification;
    }

    public final SpotResizingSpecification spotResizeSpecification() {
        return this.spotResizeSpecification;
    }

    public final OnDemandResizingSpecification onDemandResizeSpecification() {
        return this.onDemandResizeSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spotResizeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandResizeSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetResizingSpecifications)) {
            return false;
        }
        InstanceFleetResizingSpecifications other = (InstanceFleetResizingSpecifications)obj;
        return Objects.equals(this.spotResizeSpecification(), other.spotResizeSpecification()) && Objects.equals(this.onDemandResizeSpecification(), other.onDemandResizeSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceFleetResizingSpecifications").add("SpotResizeSpecification", (Object)this.spotResizeSpecification()).add("OnDemandResizeSpecification", (Object)this.onDemandResizeSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotResizeSpecification": {
                return Optional.ofNullable(clazz.cast(this.spotResizeSpecification()));
            }
            case "OnDemandResizeSpecification": {
                return Optional.ofNullable(clazz.cast(this.onDemandResizeSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetResizingSpecifications, T> g) {
        return obj -> g.apply((InstanceFleetResizingSpecifications)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SpotResizingSpecification spotResizeSpecification;
        private OnDemandResizingSpecification onDemandResizeSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetResizingSpecifications model) {
            this.spotResizeSpecification(model.spotResizeSpecification);
            this.onDemandResizeSpecification(model.onDemandResizeSpecification);
        }

        public final SpotResizingSpecification.Builder getSpotResizeSpecification() {
            return this.spotResizeSpecification != null ? this.spotResizeSpecification.toBuilder() : null;
        }

        public final void setSpotResizeSpecification(SpotResizingSpecification.BuilderImpl spotResizeSpecification) {
            this.spotResizeSpecification = spotResizeSpecification != null ? spotResizeSpecification.build() : null;
        }

        @Override
        public final Builder spotResizeSpecification(SpotResizingSpecification spotResizeSpecification) {
            this.spotResizeSpecification = spotResizeSpecification;
            return this;
        }

        public final OnDemandResizingSpecification.Builder getOnDemandResizeSpecification() {
            return this.onDemandResizeSpecification != null ? this.onDemandResizeSpecification.toBuilder() : null;
        }

        public final void setOnDemandResizeSpecification(OnDemandResizingSpecification.BuilderImpl onDemandResizeSpecification) {
            this.onDemandResizeSpecification = onDemandResizeSpecification != null ? onDemandResizeSpecification.build() : null;
        }

        @Override
        public final Builder onDemandResizeSpecification(OnDemandResizingSpecification onDemandResizeSpecification) {
            this.onDemandResizeSpecification = onDemandResizeSpecification;
            return this;
        }

        public InstanceFleetResizingSpecifications build() {
            return new InstanceFleetResizingSpecifications(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceFleetResizingSpecifications> {
        public Builder spotResizeSpecification(SpotResizingSpecification var1);

        default public Builder spotResizeSpecification(Consumer<SpotResizingSpecification.Builder> spotResizeSpecification) {
            return this.spotResizeSpecification((SpotResizingSpecification)((SpotResizingSpecification.Builder)SpotResizingSpecification.builder().applyMutation(spotResizeSpecification)).build());
        }

        public Builder onDemandResizeSpecification(OnDemandResizingSpecification var1);

        default public Builder onDemandResizeSpecification(Consumer<OnDemandResizingSpecification.Builder> onDemandResizeSpecification) {
            return this.onDemandResizeSpecification((OnDemandResizingSpecification)((OnDemandResizingSpecification.Builder)OnDemandResizingSpecification.builder().applyMutation(onDemandResizeSpecification)).build());
        }
    }
}

