/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.internal.UserAgentUtils;
import software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest;
import software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse;
import software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary;

public class ListSecurityConfigurationsPublisher
implements SdkPublisher<ListSecurityConfigurationsResponse> {
    private final EmrAsyncClient client;
    private final ListSecurityConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityConfigurationsPublisher(EmrAsyncClient client, ListSecurityConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityConfigurationsPublisher(EmrAsyncClient client, ListSecurityConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SecurityConfigurationSummary> securityConfigurations() {
        Function<ListSecurityConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityConfigurations() != null) {
                return response.securityConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListSecurityConfigurationsResponse> {
        private ListSecurityConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListSecurityConfigurationsResponse> nextPage(ListSecurityConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityConfigurationsPublisher.this.client.listSecurityConfigurations(ListSecurityConfigurationsPublisher.this.firstRequest);
            }
            return ListSecurityConfigurationsPublisher.this.client.listSecurityConfigurations((ListSecurityConfigurationsRequest)((Object)ListSecurityConfigurationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

