/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.Command;
import software.amazon.awssdk.services.emr.model.CommandListCopier;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBootstrapActionsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListBootstrapActionsResponse> {
    private static final SdkField<List<Command>> BOOTSTRAP_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BootstrapActions").getter(ListBootstrapActionsResponse.getter(ListBootstrapActionsResponse::bootstrapActions)).setter(ListBootstrapActionsResponse.setter(Builder::bootstrapActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootstrapActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Command::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListBootstrapActionsResponse.getter(ListBootstrapActionsResponse::marker)).setter(ListBootstrapActionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_ACTIONS_FIELD, MARKER_FIELD));
    private final List<Command> bootstrapActions;
    private final String marker;

    private ListBootstrapActionsResponse(BuilderImpl builder) {
        super(builder);
        this.bootstrapActions = builder.bootstrapActions;
        this.marker = builder.marker;
    }

    public final boolean hasBootstrapActions() {
        return this.bootstrapActions != null && !(this.bootstrapActions instanceof SdkAutoConstructList);
    }

    public final List<Command> bootstrapActions() {
        return this.bootstrapActions;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBootstrapActions() ? this.bootstrapActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBootstrapActionsResponse)) {
            return false;
        }
        ListBootstrapActionsResponse other = (ListBootstrapActionsResponse)((Object)obj);
        return this.hasBootstrapActions() == other.hasBootstrapActions() && Objects.equals(this.bootstrapActions(), other.bootstrapActions()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListBootstrapActionsResponse").add("BootstrapActions", this.hasBootstrapActions() ? this.bootstrapActions() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BootstrapActions": {
                return Optional.ofNullable(clazz.cast(this.bootstrapActions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBootstrapActionsResponse, T> g) {
        return obj -> g.apply((ListBootstrapActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<Command> bootstrapActions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBootstrapActionsResponse model) {
            super(model);
            this.bootstrapActions(model.bootstrapActions);
            this.marker(model.marker);
        }

        public final List<Command.Builder> getBootstrapActions() {
            List<Command.Builder> result = CommandListCopier.copyToBuilder(this.bootstrapActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBootstrapActions(Collection<Command.BuilderImpl> bootstrapActions) {
            this.bootstrapActions = CommandListCopier.copyFromBuilder(bootstrapActions);
        }

        @Override
        public final Builder bootstrapActions(Collection<Command> bootstrapActions) {
            this.bootstrapActions = CommandListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(Command ... bootstrapActions) {
            this.bootstrapActions(Arrays.asList(bootstrapActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(Consumer<Command.Builder> ... bootstrapActions) {
            this.bootstrapActions(Stream.of(bootstrapActions).map(c -> (Command)((Command.Builder)Command.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListBootstrapActionsResponse build() {
            return new ListBootstrapActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBootstrapActionsResponse> {
        public Builder bootstrapActions(Collection<Command> var1);

        public Builder bootstrapActions(Command ... var1);

        public Builder bootstrapActions(Consumer<Command.Builder> ... var1);

        public Builder marker(String var1);
    }
}

