/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.model.InstanceGroup;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse;

public class ListInstanceGroupsPublisher
implements SdkPublisher<ListInstanceGroupsResponse> {
    private final EmrAsyncClient client;
    private final ListInstanceGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceGroupsPublisher(EmrAsyncClient client, ListInstanceGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceGroupsPublisher(EmrAsyncClient client, ListInstanceGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceGroup> instanceGroups() {
        Function<ListInstanceGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceGroups() != null) {
                return response.instanceGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstanceGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInstanceGroupsResponseFetcher
    implements AsyncPageFetcher<ListInstanceGroupsResponse> {
        private ListInstanceGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<ListInstanceGroupsResponse> nextPage(ListInstanceGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceGroupsPublisher.this.client.listInstanceGroups(ListInstanceGroupsPublisher.this.firstRequest);
            }
            return ListInstanceGroupsPublisher.this.client.listInstanceGroups((ListInstanceGroupsRequest)((Object)ListInstanceGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

