/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.model.ListReleaseLabelsRequest;
import software.amazon.awssdk.services.emr.model.ListReleaseLabelsResponse;

public class ListReleaseLabelsIterable
implements SdkIterable<ListReleaseLabelsResponse> {
    private final EmrClient client;
    private final ListReleaseLabelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReleaseLabelsIterable(EmrClient client, ListReleaseLabelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReleaseLabelsResponseFetcher();
    }

    public Iterator<ListReleaseLabelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListReleaseLabelsResponseFetcher
    implements SyncPageFetcher<ListReleaseLabelsResponse> {
        private ListReleaseLabelsResponseFetcher() {
        }

        public boolean hasNextPage(ListReleaseLabelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReleaseLabelsResponse nextPage(ListReleaseLabelsResponse previousPage) {
            if (previousPage == null) {
                return ListReleaseLabelsIterable.this.client.listReleaseLabels(ListReleaseLabelsIterable.this.firstRequest);
            }
            return ListReleaseLabelsIterable.this.client.listReleaseLabels((ListReleaseLabelsRequest)((Object)ListReleaseLabelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

