/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.model.Command;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse;

public class ListBootstrapActionsIterable
implements SdkIterable<ListBootstrapActionsResponse> {
    private final EmrClient client;
    private final ListBootstrapActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBootstrapActionsIterable(EmrClient client, ListBootstrapActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBootstrapActionsResponseFetcher();
    }

    public Iterator<ListBootstrapActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Command> bootstrapActions() {
        Function<ListBootstrapActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.bootstrapActions() != null) {
                return response.bootstrapActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBootstrapActionsResponseFetcher
    implements SyncPageFetcher<ListBootstrapActionsResponse> {
        private ListBootstrapActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBootstrapActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListBootstrapActionsResponse nextPage(ListBootstrapActionsResponse previousPage) {
            if (previousPage == null) {
                return ListBootstrapActionsIterable.this.client.listBootstrapActions(ListBootstrapActionsIterable.this.firstRequest);
            }
            return ListBootstrapActionsIterable.this.client.listBootstrapActions((ListBootstrapActionsRequest)((Object)ListBootstrapActionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

