/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest;
import software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse;
import software.amazon.awssdk.services.emr.model.NotebookExecutionSummary;

public class ListNotebookExecutionsIterable
implements SdkIterable<ListNotebookExecutionsResponse> {
    private final EmrClient client;
    private final ListNotebookExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotebookExecutionsIterable(EmrClient client, ListNotebookExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNotebookExecutionsResponseFetcher();
    }

    public Iterator<ListNotebookExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotebookExecutionSummary> notebookExecutions() {
        Function<ListNotebookExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notebookExecutions() != null) {
                return response.notebookExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNotebookExecutionsResponseFetcher
    implements SyncPageFetcher<ListNotebookExecutionsResponse> {
        private ListNotebookExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotebookExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListNotebookExecutionsResponse nextPage(ListNotebookExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListNotebookExecutionsIterable.this.client.listNotebookExecutions(ListNotebookExecutionsIterable.this.firstRequest);
            }
            return ListNotebookExecutionsIterable.this.client.listNotebookExecutions((ListNotebookExecutionsRequest)((Object)ListNotebookExecutionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

