/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.InstanceFleetConfig;
import software.amazon.awssdk.services.emr.model.InstanceFleetConfigListCopier;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfig;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfigListCopier;
import software.amazon.awssdk.services.emr.model.PlacementType;
import software.amazon.awssdk.services.emr.model.SecurityGroupsListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringMaxLen256ListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobFlowInstancesConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobFlowInstancesConfig> {
    private static final SdkField<String> MASTER_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterInstanceType").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::masterInstanceType)).setter(JobFlowInstancesConfig.setter(Builder::masterInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterInstanceType").build()}).build();
    private static final SdkField<String> SLAVE_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlaveInstanceType").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::slaveInstanceType)).setter(JobFlowInstancesConfig.setter(Builder::slaveInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlaveInstanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::instanceCount)).setter(JobFlowInstancesConfig.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<List<InstanceGroupConfig>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroups").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::instanceGroups)).setter(JobFlowInstancesConfig.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceGroupConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InstanceFleetConfig>> INSTANCE_FLEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceFleets").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::instanceFleets)).setter(JobFlowInstancesConfig.setter(Builder::instanceFleets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceFleetConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EC2_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2KeyName").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::ec2KeyName)).setter(JobFlowInstancesConfig.setter(Builder::ec2KeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2KeyName").build()}).build();
    private static final SdkField<PlacementType> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::placement)).setter(JobFlowInstancesConfig.setter(Builder::placement)).constructor(PlacementType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()}).build();
    private static final SdkField<Boolean> KEEP_JOB_FLOW_ALIVE_WHEN_NO_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("KeepJobFlowAliveWhenNoSteps").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::keepJobFlowAliveWhenNoSteps)).setter(JobFlowInstancesConfig.setter(Builder::keepJobFlowAliveWhenNoSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeepJobFlowAliveWhenNoSteps").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtected").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::terminationProtected)).setter(JobFlowInstancesConfig.setter(Builder::terminationProtected)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtected").build()}).build();
    private static final SdkField<String> HADOOP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HadoopVersion").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::hadoopVersion)).setter(JobFlowInstancesConfig.setter(Builder::hadoopVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HadoopVersion").build()}).build();
    private static final SdkField<String> EC2_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2SubnetId").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::ec2SubnetId)).setter(JobFlowInstancesConfig.setter(Builder::ec2SubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2SubnetId").build()}).build();
    private static final SdkField<List<String>> EC2_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ec2SubnetIds").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::ec2SubnetIds)).setter(JobFlowInstancesConfig.setter(Builder::ec2SubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EMR_MANAGED_MASTER_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmrManagedMasterSecurityGroup").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::emrManagedMasterSecurityGroup)).setter(JobFlowInstancesConfig.setter(Builder::emrManagedMasterSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrManagedMasterSecurityGroup").build()}).build();
    private static final SdkField<String> EMR_MANAGED_SLAVE_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmrManagedSlaveSecurityGroup").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::emrManagedSlaveSecurityGroup)).setter(JobFlowInstancesConfig.setter(Builder::emrManagedSlaveSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmrManagedSlaveSecurityGroup").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessSecurityGroup").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::serviceAccessSecurityGroup)).setter(JobFlowInstancesConfig.setter(Builder::serviceAccessSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessSecurityGroup").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_MASTER_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalMasterSecurityGroups").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::additionalMasterSecurityGroups)).setter(JobFlowInstancesConfig.setter(Builder::additionalMasterSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMasterSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_SLAVE_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalSlaveSecurityGroups").getter(JobFlowInstancesConfig.getter(JobFlowInstancesConfig::additionalSlaveSecurityGroups)).setter(JobFlowInstancesConfig.setter(Builder::additionalSlaveSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalSlaveSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_INSTANCE_TYPE_FIELD, SLAVE_INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, INSTANCE_GROUPS_FIELD, INSTANCE_FLEETS_FIELD, EC2_KEY_NAME_FIELD, PLACEMENT_FIELD, KEEP_JOB_FLOW_ALIVE_WHEN_NO_STEPS_FIELD, TERMINATION_PROTECTED_FIELD, HADOOP_VERSION_FIELD, EC2_SUBNET_ID_FIELD, EC2_SUBNET_IDS_FIELD, EMR_MANAGED_MASTER_SECURITY_GROUP_FIELD, EMR_MANAGED_SLAVE_SECURITY_GROUP_FIELD, SERVICE_ACCESS_SECURITY_GROUP_FIELD, ADDITIONAL_MASTER_SECURITY_GROUPS_FIELD, ADDITIONAL_SLAVE_SECURITY_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String masterInstanceType;
    private final String slaveInstanceType;
    private final Integer instanceCount;
    private final List<InstanceGroupConfig> instanceGroups;
    private final List<InstanceFleetConfig> instanceFleets;
    private final String ec2KeyName;
    private final PlacementType placement;
    private final Boolean keepJobFlowAliveWhenNoSteps;
    private final Boolean terminationProtected;
    private final String hadoopVersion;
    private final String ec2SubnetId;
    private final List<String> ec2SubnetIds;
    private final String emrManagedMasterSecurityGroup;
    private final String emrManagedSlaveSecurityGroup;
    private final String serviceAccessSecurityGroup;
    private final List<String> additionalMasterSecurityGroups;
    private final List<String> additionalSlaveSecurityGroups;

    private JobFlowInstancesConfig(BuilderImpl builder) {
        this.masterInstanceType = builder.masterInstanceType;
        this.slaveInstanceType = builder.slaveInstanceType;
        this.instanceCount = builder.instanceCount;
        this.instanceGroups = builder.instanceGroups;
        this.instanceFleets = builder.instanceFleets;
        this.ec2KeyName = builder.ec2KeyName;
        this.placement = builder.placement;
        this.keepJobFlowAliveWhenNoSteps = builder.keepJobFlowAliveWhenNoSteps;
        this.terminationProtected = builder.terminationProtected;
        this.hadoopVersion = builder.hadoopVersion;
        this.ec2SubnetId = builder.ec2SubnetId;
        this.ec2SubnetIds = builder.ec2SubnetIds;
        this.emrManagedMasterSecurityGroup = builder.emrManagedMasterSecurityGroup;
        this.emrManagedSlaveSecurityGroup = builder.emrManagedSlaveSecurityGroup;
        this.serviceAccessSecurityGroup = builder.serviceAccessSecurityGroup;
        this.additionalMasterSecurityGroups = builder.additionalMasterSecurityGroups;
        this.additionalSlaveSecurityGroups = builder.additionalSlaveSecurityGroups;
    }

    public final String masterInstanceType() {
        return this.masterInstanceType;
    }

    public final String slaveInstanceType() {
        return this.slaveInstanceType;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public final List<InstanceGroupConfig> instanceGroups() {
        return this.instanceGroups;
    }

    public final boolean hasInstanceFleets() {
        return this.instanceFleets != null && !(this.instanceFleets instanceof SdkAutoConstructList);
    }

    public final List<InstanceFleetConfig> instanceFleets() {
        return this.instanceFleets;
    }

    public final String ec2KeyName() {
        return this.ec2KeyName;
    }

    public final PlacementType placement() {
        return this.placement;
    }

    public final Boolean keepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public final Boolean terminationProtected() {
        return this.terminationProtected;
    }

    public final String hadoopVersion() {
        return this.hadoopVersion;
    }

    public final String ec2SubnetId() {
        return this.ec2SubnetId;
    }

    public final boolean hasEc2SubnetIds() {
        return this.ec2SubnetIds != null && !(this.ec2SubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> ec2SubnetIds() {
        return this.ec2SubnetIds;
    }

    public final String emrManagedMasterSecurityGroup() {
        return this.emrManagedMasterSecurityGroup;
    }

    public final String emrManagedSlaveSecurityGroup() {
        return this.emrManagedSlaveSecurityGroup;
    }

    public final String serviceAccessSecurityGroup() {
        return this.serviceAccessSecurityGroup;
    }

    public final boolean hasAdditionalMasterSecurityGroups() {
        return this.additionalMasterSecurityGroups != null && !(this.additionalMasterSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> additionalMasterSecurityGroups() {
        return this.additionalMasterSecurityGroups;
    }

    public final boolean hasAdditionalSlaveSecurityGroups() {
        return this.additionalSlaveSecurityGroups != null && !(this.additionalSlaveSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> additionalSlaveSecurityGroups() {
        return this.additionalSlaveSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.masterInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.slaveInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroups() ? this.instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceFleets() ? this.instanceFleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2KeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.keepJobFlowAliveWhenNoSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtected());
        hashCode = 31 * hashCode + Objects.hashCode(this.hadoopVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SubnetIds() ? this.ec2SubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.emrManagedMasterSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.emrManagedSlaveSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalMasterSecurityGroups() ? this.additionalMasterSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalSlaveSecurityGroups() ? this.additionalSlaveSecurityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowInstancesConfig)) {
            return false;
        }
        JobFlowInstancesConfig other = (JobFlowInstancesConfig)obj;
        return Objects.equals(this.masterInstanceType(), other.masterInstanceType()) && Objects.equals(this.slaveInstanceType(), other.slaveInstanceType()) && Objects.equals(this.instanceCount(), other.instanceCount()) && this.hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(this.instanceGroups(), other.instanceGroups()) && this.hasInstanceFleets() == other.hasInstanceFleets() && Objects.equals(this.instanceFleets(), other.instanceFleets()) && Objects.equals(this.ec2KeyName(), other.ec2KeyName()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.keepJobFlowAliveWhenNoSteps(), other.keepJobFlowAliveWhenNoSteps()) && Objects.equals(this.terminationProtected(), other.terminationProtected()) && Objects.equals(this.hadoopVersion(), other.hadoopVersion()) && Objects.equals(this.ec2SubnetId(), other.ec2SubnetId()) && this.hasEc2SubnetIds() == other.hasEc2SubnetIds() && Objects.equals(this.ec2SubnetIds(), other.ec2SubnetIds()) && Objects.equals(this.emrManagedMasterSecurityGroup(), other.emrManagedMasterSecurityGroup()) && Objects.equals(this.emrManagedSlaveSecurityGroup(), other.emrManagedSlaveSecurityGroup()) && Objects.equals(this.serviceAccessSecurityGroup(), other.serviceAccessSecurityGroup()) && this.hasAdditionalMasterSecurityGroups() == other.hasAdditionalMasterSecurityGroups() && Objects.equals(this.additionalMasterSecurityGroups(), other.additionalMasterSecurityGroups()) && this.hasAdditionalSlaveSecurityGroups() == other.hasAdditionalSlaveSecurityGroups() && Objects.equals(this.additionalSlaveSecurityGroups(), other.additionalSlaveSecurityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"JobFlowInstancesConfig").add("MasterInstanceType", (Object)this.masterInstanceType()).add("SlaveInstanceType", (Object)this.slaveInstanceType()).add("InstanceCount", (Object)this.instanceCount()).add("InstanceGroups", this.hasInstanceGroups() ? this.instanceGroups() : null).add("InstanceFleets", this.hasInstanceFleets() ? this.instanceFleets() : null).add("Ec2KeyName", (Object)this.ec2KeyName()).add("Placement", (Object)this.placement()).add("KeepJobFlowAliveWhenNoSteps", (Object)this.keepJobFlowAliveWhenNoSteps()).add("TerminationProtected", (Object)this.terminationProtected()).add("HadoopVersion", (Object)this.hadoopVersion()).add("Ec2SubnetId", (Object)this.ec2SubnetId()).add("Ec2SubnetIds", this.hasEc2SubnetIds() ? this.ec2SubnetIds() : null).add("EmrManagedMasterSecurityGroup", (Object)this.emrManagedMasterSecurityGroup()).add("EmrManagedSlaveSecurityGroup", (Object)this.emrManagedSlaveSecurityGroup()).add("ServiceAccessSecurityGroup", (Object)this.serviceAccessSecurityGroup()).add("AdditionalMasterSecurityGroups", this.hasAdditionalMasterSecurityGroups() ? this.additionalMasterSecurityGroups() : null).add("AdditionalSlaveSecurityGroups", this.hasAdditionalSlaveSecurityGroups() ? this.additionalSlaveSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MasterInstanceType": {
                return Optional.ofNullable(clazz.cast(this.masterInstanceType()));
            }
            case "SlaveInstanceType": {
                return Optional.ofNullable(clazz.cast(this.slaveInstanceType()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
            case "InstanceFleets": {
                return Optional.ofNullable(clazz.cast(this.instanceFleets()));
            }
            case "Ec2KeyName": {
                return Optional.ofNullable(clazz.cast(this.ec2KeyName()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "KeepJobFlowAliveWhenNoSteps": {
                return Optional.ofNullable(clazz.cast(this.keepJobFlowAliveWhenNoSteps()));
            }
            case "TerminationProtected": {
                return Optional.ofNullable(clazz.cast(this.terminationProtected()));
            }
            case "HadoopVersion": {
                return Optional.ofNullable(clazz.cast(this.hadoopVersion()));
            }
            case "Ec2SubnetId": {
                return Optional.ofNullable(clazz.cast(this.ec2SubnetId()));
            }
            case "Ec2SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.ec2SubnetIds()));
            }
            case "EmrManagedMasterSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.emrManagedMasterSecurityGroup()));
            }
            case "EmrManagedSlaveSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.emrManagedSlaveSecurityGroup()));
            }
            case "ServiceAccessSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessSecurityGroup()));
            }
            case "AdditionalMasterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.additionalMasterSecurityGroups()));
            }
            case "AdditionalSlaveSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.additionalSlaveSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobFlowInstancesConfig, T> g) {
        return obj -> g.apply((JobFlowInstancesConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String masterInstanceType;
        private String slaveInstanceType;
        private Integer instanceCount;
        private List<InstanceGroupConfig> instanceGroups = DefaultSdkAutoConstructList.getInstance();
        private List<InstanceFleetConfig> instanceFleets = DefaultSdkAutoConstructList.getInstance();
        private String ec2KeyName;
        private PlacementType placement;
        private Boolean keepJobFlowAliveWhenNoSteps;
        private Boolean terminationProtected;
        private String hadoopVersion;
        private String ec2SubnetId;
        private List<String> ec2SubnetIds = DefaultSdkAutoConstructList.getInstance();
        private String emrManagedMasterSecurityGroup;
        private String emrManagedSlaveSecurityGroup;
        private String serviceAccessSecurityGroup;
        private List<String> additionalMasterSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> additionalSlaveSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobFlowInstancesConfig model) {
            this.masterInstanceType(model.masterInstanceType);
            this.slaveInstanceType(model.slaveInstanceType);
            this.instanceCount(model.instanceCount);
            this.instanceGroups(model.instanceGroups);
            this.instanceFleets(model.instanceFleets);
            this.ec2KeyName(model.ec2KeyName);
            this.placement(model.placement);
            this.keepJobFlowAliveWhenNoSteps(model.keepJobFlowAliveWhenNoSteps);
            this.terminationProtected(model.terminationProtected);
            this.hadoopVersion(model.hadoopVersion);
            this.ec2SubnetId(model.ec2SubnetId);
            this.ec2SubnetIds(model.ec2SubnetIds);
            this.emrManagedMasterSecurityGroup(model.emrManagedMasterSecurityGroup);
            this.emrManagedSlaveSecurityGroup(model.emrManagedSlaveSecurityGroup);
            this.serviceAccessSecurityGroup(model.serviceAccessSecurityGroup);
            this.additionalMasterSecurityGroups(model.additionalMasterSecurityGroups);
            this.additionalSlaveSecurityGroups(model.additionalSlaveSecurityGroups);
        }

        public final String getMasterInstanceType() {
            return this.masterInstanceType;
        }

        public final void setMasterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
        }

        @Override
        @Transient
        public final Builder masterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
            return this;
        }

        public final String getSlaveInstanceType() {
            return this.slaveInstanceType;
        }

        public final void setSlaveInstanceType(String slaveInstanceType) {
            this.slaveInstanceType = slaveInstanceType;
        }

        @Override
        @Transient
        public final Builder slaveInstanceType(String slaveInstanceType) {
            this.slaveInstanceType = slaveInstanceType;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        @Transient
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final List<InstanceGroupConfig.Builder> getInstanceGroups() {
            List<InstanceGroupConfig.Builder> result = InstanceGroupConfigListCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<InstanceGroupConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        @Transient
        public final Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroupConfig.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (InstanceGroupConfig)((InstanceGroupConfig.Builder)InstanceGroupConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceFleetConfig.Builder> getInstanceFleets() {
            List<InstanceFleetConfig.Builder> result = InstanceFleetConfigListCopier.copyToBuilder(this.instanceFleets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceFleets(Collection<InstanceFleetConfig.BuilderImpl> instanceFleets) {
            this.instanceFleets = InstanceFleetConfigListCopier.copyFromBuilder(instanceFleets);
        }

        @Override
        @Transient
        public final Builder instanceFleets(Collection<InstanceFleetConfig> instanceFleets) {
            this.instanceFleets = InstanceFleetConfigListCopier.copy(instanceFleets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceFleets(InstanceFleetConfig ... instanceFleets) {
            this.instanceFleets(Arrays.asList(instanceFleets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceFleets(Consumer<InstanceFleetConfig.Builder> ... instanceFleets) {
            this.instanceFleets(Stream.of(instanceFleets).map(c -> (InstanceFleetConfig)((InstanceFleetConfig.Builder)InstanceFleetConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEc2KeyName() {
            return this.ec2KeyName;
        }

        public final void setEc2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
        }

        @Override
        @Transient
        public final Builder ec2KeyName(String ec2KeyName) {
            this.ec2KeyName = ec2KeyName;
            return this;
        }

        public final PlacementType.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(PlacementType.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        @Transient
        public final Builder placement(PlacementType placement) {
            this.placement = placement;
            return this;
        }

        public final Boolean getKeepJobFlowAliveWhenNoSteps() {
            return this.keepJobFlowAliveWhenNoSteps;
        }

        public final void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        }

        @Override
        @Transient
        public final Builder keepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
            this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
            return this;
        }

        public final Boolean getTerminationProtected() {
            return this.terminationProtected;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        @Override
        @Transient
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final String getHadoopVersion() {
            return this.hadoopVersion;
        }

        public final void setHadoopVersion(String hadoopVersion) {
            this.hadoopVersion = hadoopVersion;
        }

        @Override
        @Transient
        public final Builder hadoopVersion(String hadoopVersion) {
            this.hadoopVersion = hadoopVersion;
            return this;
        }

        public final String getEc2SubnetId() {
            return this.ec2SubnetId;
        }

        public final void setEc2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
        }

        @Override
        @Transient
        public final Builder ec2SubnetId(String ec2SubnetId) {
            this.ec2SubnetId = ec2SubnetId;
            return this;
        }

        public final Collection<String> getEc2SubnetIds() {
            if (this.ec2SubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2SubnetIds;
        }

        public final void setEc2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = XmlStringMaxLen256ListCopier.copy(ec2SubnetIds);
        }

        @Override
        @Transient
        public final Builder ec2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = XmlStringMaxLen256ListCopier.copy(ec2SubnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2SubnetIds(String ... ec2SubnetIds) {
            this.ec2SubnetIds(Arrays.asList(ec2SubnetIds));
            return this;
        }

        public final String getEmrManagedMasterSecurityGroup() {
            return this.emrManagedMasterSecurityGroup;
        }

        public final void setEmrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
        }

        @Override
        @Transient
        public final Builder emrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
            this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
            return this;
        }

        public final String getEmrManagedSlaveSecurityGroup() {
            return this.emrManagedSlaveSecurityGroup;
        }

        public final void setEmrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
        }

        @Override
        @Transient
        public final Builder emrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
            this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
            return this;
        }

        public final String getServiceAccessSecurityGroup() {
            return this.serviceAccessSecurityGroup;
        }

        public final void setServiceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
        }

        @Override
        @Transient
        public final Builder serviceAccessSecurityGroup(String serviceAccessSecurityGroup) {
            this.serviceAccessSecurityGroup = serviceAccessSecurityGroup;
            return this;
        }

        public final Collection<String> getAdditionalMasterSecurityGroups() {
            if (this.additionalMasterSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalMasterSecurityGroups;
        }

        public final void setAdditionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = SecurityGroupsListCopier.copy(additionalMasterSecurityGroups);
        }

        @Override
        @Transient
        public final Builder additionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups = SecurityGroupsListCopier.copy(additionalMasterSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalMasterSecurityGroups(String ... additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups(Arrays.asList(additionalMasterSecurityGroups));
            return this;
        }

        public final Collection<String> getAdditionalSlaveSecurityGroups() {
            if (this.additionalSlaveSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalSlaveSecurityGroups;
        }

        public final void setAdditionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = SecurityGroupsListCopier.copy(additionalSlaveSecurityGroups);
        }

        @Override
        @Transient
        public final Builder additionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups = SecurityGroupsListCopier.copy(additionalSlaveSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalSlaveSecurityGroups(String ... additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups(Arrays.asList(additionalSlaveSecurityGroups));
            return this;
        }

        public JobFlowInstancesConfig build() {
            return new JobFlowInstancesConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobFlowInstancesConfig> {
        public Builder masterInstanceType(String var1);

        public Builder slaveInstanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceGroups(Collection<InstanceGroupConfig> var1);

        public Builder instanceGroups(InstanceGroupConfig ... var1);

        public Builder instanceGroups(Consumer<InstanceGroupConfig.Builder> ... var1);

        public Builder instanceFleets(Collection<InstanceFleetConfig> var1);

        public Builder instanceFleets(InstanceFleetConfig ... var1);

        public Builder instanceFleets(Consumer<InstanceFleetConfig.Builder> ... var1);

        public Builder ec2KeyName(String var1);

        public Builder placement(PlacementType var1);

        default public Builder placement(Consumer<PlacementType.Builder> placement) {
            return this.placement((PlacementType)((PlacementType.Builder)PlacementType.builder().applyMutation(placement)).build());
        }

        public Builder keepJobFlowAliveWhenNoSteps(Boolean var1);

        public Builder terminationProtected(Boolean var1);

        public Builder hadoopVersion(String var1);

        public Builder ec2SubnetId(String var1);

        public Builder ec2SubnetIds(Collection<String> var1);

        public Builder ec2SubnetIds(String ... var1);

        public Builder emrManagedMasterSecurityGroup(String var1);

        public Builder emrManagedSlaveSecurityGroup(String var1);

        public Builder serviceAccessSecurityGroup(String var1);

        public Builder additionalMasterSecurityGroups(Collection<String> var1);

        public Builder additionalMasterSecurityGroups(String ... var1);

        public Builder additionalSlaveSecurityGroups(Collection<String> var1);

        public Builder additionalSlaveSecurityGroups(String ... var1);
    }
}

