/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfig;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddInstanceGroupsRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, AddInstanceGroupsRequest> {
    private static final SdkField<List<InstanceGroupConfig>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroups").getter(AddInstanceGroupsRequest.getter(AddInstanceGroupsRequest::instanceGroups)).setter(AddInstanceGroupsRequest.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceGroupConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobFlowId").getter(AddInstanceGroupsRequest.getter(AddInstanceGroupsRequest::jobFlowId)).setter(AddInstanceGroupsRequest.setter(Builder::jobFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUPS_FIELD, JOB_FLOW_ID_FIELD));
    private final List<InstanceGroupConfig> instanceGroups;
    private final String jobFlowId;

    private AddInstanceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceGroups = builder.instanceGroups;
        this.jobFlowId = builder.jobFlowId;
    }

    public final boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public final List<InstanceGroupConfig> instanceGroups() {
        return this.instanceGroups;
    }

    public final String jobFlowId() {
        return this.jobFlowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroups() ? this.instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsRequest)) {
            return false;
        }
        AddInstanceGroupsRequest other = (AddInstanceGroupsRequest)((Object)obj);
        return this.hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(this.instanceGroups(), other.instanceGroups()) && Objects.equals(this.jobFlowId(), other.jobFlowId());
    }

    public final String toString() {
        return ToString.builder((String)"AddInstanceGroupsRequest").add("InstanceGroups", this.hasInstanceGroups() ? this.instanceGroups() : null).add("JobFlowId", (Object)this.jobFlowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
            case "JobFlowId": {
                return Optional.ofNullable(clazz.cast(this.jobFlowId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddInstanceGroupsRequest, T> g) {
        return obj -> g.apply((AddInstanceGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private List<InstanceGroupConfig> instanceGroups = DefaultSdkAutoConstructList.getInstance();
        private String jobFlowId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceGroupsRequest model) {
            super(model);
            this.instanceGroups(model.instanceGroups);
            this.jobFlowId(model.jobFlowId);
        }

        public final List<InstanceGroupConfig.Builder> getInstanceGroups() {
            List<InstanceGroupConfig.Builder> result = InstanceGroupConfigListCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroupConfig.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (InstanceGroupConfig)((InstanceGroupConfig.Builder)InstanceGroupConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copyFromBuilder(instanceGroups);
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddInstanceGroupsRequest build() {
            return new AddInstanceGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddInstanceGroupsRequest> {
        public Builder instanceGroups(Collection<InstanceGroupConfig> var1);

        public Builder instanceGroups(InstanceGroupConfig ... var1);

        public Builder instanceGroups(Consumer<InstanceGroupConfig.Builder> ... var1);

        public Builder jobFlowId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

