/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupportedProductConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupportedProductConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SupportedProductConfig.getter(SupportedProductConfig::name)).setter(SupportedProductConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Args").getter(SupportedProductConfig.getter(SupportedProductConfig::args)).setter(SupportedProductConfig.setter(Builder::args)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> args;

    private SupportedProductConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.args = builder.args;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasArgs() {
        return this.args != null && !(this.args instanceof SdkAutoConstructList);
    }

    public final List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArgs() ? this.args() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedProductConfig)) {
            return false;
        }
        SupportedProductConfig other = (SupportedProductConfig)obj;
        return Objects.equals(this.name(), other.name()) && this.hasArgs() == other.hasArgs() && Objects.equals(this.args(), other.args());
    }

    public final String toString() {
        return ToString.builder((String)"SupportedProductConfig").add("Name", (Object)this.name()).add("Args", this.hasArgs() ? this.args() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Args": {
                return Optional.ofNullable(clazz.cast(this.args()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SupportedProductConfig, T> g) {
        return obj -> g.apply((SupportedProductConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> args = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedProductConfig model) {
            this.name(model.name);
            this.args(model.args);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getArgs() {
            if (this.args instanceof SdkAutoConstructList) {
                return null;
            }
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
        }

        public SupportedProductConfig build() {
            return new SupportedProductConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupportedProductConfig> {
        public Builder name(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

