/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingAction implements SdkPojo, Serializable, ToCopyableBuilder<ScalingAction.Builder, ScalingAction> {
    private static final SdkField<String> MARKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Market")
            .getter(getter(ScalingAction::marketAsString)).setter(setter(Builder::market))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Market").build()).build();

    private static final SdkField<SimpleScalingPolicyConfiguration> SIMPLE_SCALING_POLICY_CONFIGURATION_FIELD = SdkField
            .<SimpleScalingPolicyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SimpleScalingPolicyConfiguration")
            .getter(getter(ScalingAction::simpleScalingPolicyConfiguration))
            .setter(setter(Builder::simpleScalingPolicyConfiguration))
            .constructor(SimpleScalingPolicyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleScalingPolicyConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKET_FIELD,
            SIMPLE_SCALING_POLICY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String market;

    private final SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration;

    private ScalingAction(BuilderImpl builder) {
        this.market = builder.market;
        this.simpleScalingPolicyConfiguration = builder.simpleScalingPolicyConfiguration;
    }

    /**
     * <p>
     * Not available for instance groups. Instance groups use the market type specified for the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #market} will
     * return {@link MarketType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #marketAsString}.
     * </p>
     * 
     * @return Not available for instance groups. Instance groups use the market type specified for the group.
     * @see MarketType
     */
    public final MarketType market() {
        return MarketType.fromValue(market);
    }

    /**
     * <p>
     * Not available for instance groups. Instance groups use the market type specified for the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #market} will
     * return {@link MarketType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #marketAsString}.
     * </p>
     * 
     * @return Not available for instance groups. Instance groups use the market type specified for the group.
     * @see MarketType
     */
    public final String marketAsString() {
        return market;
    }

    /**
     * <p>
     * The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the
     * adjustment.
     * </p>
     * 
     * @return The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the
     *         adjustment.
     */
    public final SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration() {
        return simpleScalingPolicyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marketAsString());
        hashCode = 31 * hashCode + Objects.hashCode(simpleScalingPolicyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingAction)) {
            return false;
        }
        ScalingAction other = (ScalingAction) obj;
        return Objects.equals(marketAsString(), other.marketAsString())
                && Objects.equals(simpleScalingPolicyConfiguration(), other.simpleScalingPolicyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingAction").add("Market", marketAsString())
                .add("SimpleScalingPolicyConfiguration", simpleScalingPolicyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Market":
            return Optional.ofNullable(clazz.cast(marketAsString()));
        case "SimpleScalingPolicyConfiguration":
            return Optional.ofNullable(clazz.cast(simpleScalingPolicyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingAction, T> g) {
        return obj -> g.apply((ScalingAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingAction> {
        /**
         * <p>
         * Not available for instance groups. Instance groups use the market type specified for the group.
         * </p>
         * 
         * @param market
         *        Not available for instance groups. Instance groups use the market type specified for the group.
         * @see MarketType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketType
         */
        Builder market(String market);

        /**
         * <p>
         * Not available for instance groups. Instance groups use the market type specified for the group.
         * </p>
         * 
         * @param market
         *        Not available for instance groups. Instance groups use the market type specified for the group.
         * @see MarketType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketType
         */
        Builder market(MarketType market);

        /**
         * <p>
         * The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the
         * adjustment.
         * </p>
         * 
         * @param simpleScalingPolicyConfiguration
         *        The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the
         *        adjustment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration);

        /**
         * <p>
         * The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the
         * adjustment.
         * </p>
         * This is a convenience that creates an instance of the {@link SimpleScalingPolicyConfiguration.Builder}
         * avoiding the need to create one manually via {@link SimpleScalingPolicyConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleScalingPolicyConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration)}.
         * 
         * @param simpleScalingPolicyConfiguration
         *        a consumer that will call methods on {@link SimpleScalingPolicyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration)
         */
        default Builder simpleScalingPolicyConfiguration(
                Consumer<SimpleScalingPolicyConfiguration.Builder> simpleScalingPolicyConfiguration) {
            return simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration.builder()
                    .applyMutation(simpleScalingPolicyConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String market;

        private SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingAction model) {
            market(model.market);
            simpleScalingPolicyConfiguration(model.simpleScalingPolicyConfiguration);
        }

        public final String getMarket() {
            return market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market == null ? null : market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final SimpleScalingPolicyConfiguration.Builder getSimpleScalingPolicyConfiguration() {
            return simpleScalingPolicyConfiguration != null ? simpleScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration) {
            this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
            return this;
        }

        public final void setSimpleScalingPolicyConfiguration(
                SimpleScalingPolicyConfiguration.BuilderImpl simpleScalingPolicyConfiguration) {
            this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration != null ? simpleScalingPolicyConfiguration
                    .build() : null;
        }

        @Override
        public ScalingAction build() {
            return new ScalingAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
