/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>CancelSteps</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelStepsResponse extends EmrResponse implements
        ToCopyableBuilder<CancelStepsResponse.Builder, CancelStepsResponse> {
    private static final SdkField<List<CancelStepsInfo>> CANCEL_STEPS_INFO_LIST_FIELD = SdkField
            .<List<CancelStepsInfo>> builder(MarshallingType.LIST)
            .memberName("CancelStepsInfoList")
            .getter(getter(CancelStepsResponse::cancelStepsInfoList))
            .setter(setter(Builder::cancelStepsInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelStepsInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CancelStepsInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(CancelStepsInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCEL_STEPS_INFO_LIST_FIELD));

    private final List<CancelStepsInfo> cancelStepsInfoList;

    private CancelStepsResponse(BuilderImpl builder) {
        super(builder);
        this.cancelStepsInfoList = builder.cancelStepsInfoList;
    }

    /**
     * Returns true if the CancelStepsInfoList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCancelStepsInfoList() {
        return cancelStepsInfoList != null && !(cancelStepsInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>CancelStepsInfo</a>, which shows the status of specified cancel requests for each
     * <code>StepID</code> specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCancelStepsInfoList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a>CancelStepsInfo</a>, which shows the status of specified cancel requests for each
     *         <code>StepID</code> specified.
     */
    public final List<CancelStepsInfo> cancelStepsInfoList() {
        return cancelStepsInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCancelStepsInfoList() ? cancelStepsInfoList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsResponse)) {
            return false;
        }
        CancelStepsResponse other = (CancelStepsResponse) obj;
        return hasCancelStepsInfoList() == other.hasCancelStepsInfoList()
                && Objects.equals(cancelStepsInfoList(), other.cancelStepsInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelStepsResponse")
                .add("CancelStepsInfoList", hasCancelStepsInfoList() ? cancelStepsInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CancelStepsInfoList":
            return Optional.ofNullable(clazz.cast(cancelStepsInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelStepsResponse, T> g) {
        return obj -> g.apply((CancelStepsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelStepsResponse> {
        /**
         * <p>
         * A list of <a>CancelStepsInfo</a>, which shows the status of specified cancel requests for each
         * <code>StepID</code> specified.
         * </p>
         * 
         * @param cancelStepsInfoList
         *        A list of <a>CancelStepsInfo</a>, which shows the status of specified cancel requests for each
         *        <code>StepID</code> specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelStepsInfoList(Collection<CancelStepsInfo> cancelStepsInfoList);

        /**
         * <p>
         * A list of <a>CancelStepsInfo</a>, which shows the status of specified cancel requests for each
         * <code>StepID</code> specified.
         * </p>
         * 
         * @param cancelStepsInfoList
         *        A list of <a>CancelStepsInfo</a>, which shows the status of specified cancel requests for each
         *        <code>StepID</code> specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelStepsInfoList(CancelStepsInfo... cancelStepsInfoList);

        /**
         * <p>
         * A list of <a>CancelStepsInfo</a>, which shows the status of specified cancel requests for each
         * <code>StepID</code> specified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CancelStepsInfo>.Builder} avoiding the need
         * to create one manually via {@link List<CancelStepsInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CancelStepsInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #cancelStepsInfoList(List<CancelStepsInfo>)}.
         * 
         * @param cancelStepsInfoList
         *        a consumer that will call methods on {@link List<CancelStepsInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cancelStepsInfoList(List<CancelStepsInfo>)
         */
        Builder cancelStepsInfoList(Consumer<CancelStepsInfo.Builder>... cancelStepsInfoList);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<CancelStepsInfo> cancelStepsInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsResponse model) {
            super(model);
            cancelStepsInfoList(model.cancelStepsInfoList);
        }

        public final Collection<CancelStepsInfo.Builder> getCancelStepsInfoList() {
            if (cancelStepsInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return cancelStepsInfoList != null ? cancelStepsInfoList.stream().map(CancelStepsInfo::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cancelStepsInfoList(Collection<CancelStepsInfo> cancelStepsInfoList) {
            this.cancelStepsInfoList = CancelStepsInfoListCopier.copy(cancelStepsInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelStepsInfoList(CancelStepsInfo... cancelStepsInfoList) {
            cancelStepsInfoList(Arrays.asList(cancelStepsInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelStepsInfoList(Consumer<CancelStepsInfo.Builder>... cancelStepsInfoList) {
            cancelStepsInfoList(Stream.of(cancelStepsInfoList).map(c -> CancelStepsInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCancelStepsInfoList(Collection<CancelStepsInfo.BuilderImpl> cancelStepsInfoList) {
            this.cancelStepsInfoList = CancelStepsInfoListCopier.copyFromBuilder(cancelStepsInfoList);
        }

        @Override
        public CancelStepsResponse build() {
            return new CancelStepsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
