/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.emr.model.AddInstanceFleetRequest;
import software.amazon.awssdk.services.emr.model.AddInstanceFleetResponse;
import software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.AddInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.AddJobFlowStepsRequest;
import software.amazon.awssdk.services.emr.model.AddJobFlowStepsResponse;
import software.amazon.awssdk.services.emr.model.AddTagsRequest;
import software.amazon.awssdk.services.emr.model.AddTagsResponse;
import software.amazon.awssdk.services.emr.model.CancelStepsRequest;
import software.amazon.awssdk.services.emr.model.CancelStepsResponse;
import software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.CreateSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.CreateStudioRequest;
import software.amazon.awssdk.services.emr.model.CreateStudioResponse;
import software.amazon.awssdk.services.emr.model.CreateStudioSessionMappingRequest;
import software.amazon.awssdk.services.emr.model.CreateStudioSessionMappingResponse;
import software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.DeleteSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.DeleteStudioRequest;
import software.amazon.awssdk.services.emr.model.DeleteStudioResponse;
import software.amazon.awssdk.services.emr.model.DeleteStudioSessionMappingRequest;
import software.amazon.awssdk.services.emr.model.DeleteStudioSessionMappingResponse;
import software.amazon.awssdk.services.emr.model.DescribeClusterRequest;
import software.amazon.awssdk.services.emr.model.DescribeClusterResponse;
import software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionRequest;
import software.amazon.awssdk.services.emr.model.DescribeNotebookExecutionResponse;
import software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationRequest;
import software.amazon.awssdk.services.emr.model.DescribeSecurityConfigurationResponse;
import software.amazon.awssdk.services.emr.model.DescribeStepRequest;
import software.amazon.awssdk.services.emr.model.DescribeStepResponse;
import software.amazon.awssdk.services.emr.model.DescribeStudioRequest;
import software.amazon.awssdk.services.emr.model.DescribeStudioResponse;
import software.amazon.awssdk.services.emr.model.EmrException;
import software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationRequest;
import software.amazon.awssdk.services.emr.model.GetBlockPublicAccessConfigurationResponse;
import software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.GetManagedScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.GetStudioSessionMappingRequest;
import software.amazon.awssdk.services.emr.model.GetStudioSessionMappingResponse;
import software.amazon.awssdk.services.emr.model.InternalServerErrorException;
import software.amazon.awssdk.services.emr.model.InternalServerException;
import software.amazon.awssdk.services.emr.model.InvalidRequestException;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse;
import software.amazon.awssdk.services.emr.model.ListClustersRequest;
import software.amazon.awssdk.services.emr.model.ListClustersResponse;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.ListInstancesRequest;
import software.amazon.awssdk.services.emr.model.ListInstancesResponse;
import software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest;
import software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse;
import software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest;
import software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.services.emr.model.ListStepsResponse;
import software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest;
import software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse;
import software.amazon.awssdk.services.emr.model.ListStudiosRequest;
import software.amazon.awssdk.services.emr.model.ListStudiosResponse;
import software.amazon.awssdk.services.emr.model.ModifyClusterRequest;
import software.amazon.awssdk.services.emr.model.ModifyClusterResponse;
import software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest;
import software.amazon.awssdk.services.emr.model.ModifyInstanceFleetResponse;
import software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsResponse;
import software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationRequest;
import software.amazon.awssdk.services.emr.model.PutBlockPublicAccessConfigurationResponse;
import software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.PutManagedScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.RemoveAutoScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyRequest;
import software.amazon.awssdk.services.emr.model.RemoveManagedScalingPolicyResponse;
import software.amazon.awssdk.services.emr.model.RemoveTagsRequest;
import software.amazon.awssdk.services.emr.model.RemoveTagsResponse;
import software.amazon.awssdk.services.emr.model.RunJobFlowRequest;
import software.amazon.awssdk.services.emr.model.RunJobFlowResponse;
import software.amazon.awssdk.services.emr.model.SetTerminationProtectionRequest;
import software.amazon.awssdk.services.emr.model.SetTerminationProtectionResponse;
import software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersRequest;
import software.amazon.awssdk.services.emr.model.SetVisibleToAllUsersResponse;
import software.amazon.awssdk.services.emr.model.StartNotebookExecutionRequest;
import software.amazon.awssdk.services.emr.model.StartNotebookExecutionResponse;
import software.amazon.awssdk.services.emr.model.StopNotebookExecutionRequest;
import software.amazon.awssdk.services.emr.model.StopNotebookExecutionResponse;
import software.amazon.awssdk.services.emr.model.TerminateJobFlowsRequest;
import software.amazon.awssdk.services.emr.model.TerminateJobFlowsResponse;
import software.amazon.awssdk.services.emr.model.UpdateStudioSessionMappingRequest;
import software.amazon.awssdk.services.emr.model.UpdateStudioSessionMappingResponse;
import software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsIterable;
import software.amazon.awssdk.services.emr.paginators.ListClustersIterable;
import software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsIterable;
import software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsIterable;
import software.amazon.awssdk.services.emr.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsIterable;
import software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable;
import software.amazon.awssdk.services.emr.paginators.ListStepsIterable;
import software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsIterable;
import software.amazon.awssdk.services.emr.paginators.ListStudiosIterable;
import software.amazon.awssdk.services.emr.waiters.EmrWaiter;

/**
 * Service client for accessing Amazon EMR. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon EMR is a web service that makes it easier to process large amounts of data efficiently. Amazon EMR uses Hadoop
 * processing combined with several AWS services to do tasks such as web indexing, data mining, log file analysis,
 * machine learning, scientific simulation, and data warehouse management.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface EmrClient extends SdkClient {
    String SERVICE_NAME = "elasticmapreduce";

    /**
     * Create a {@link EmrClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static EmrClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link EmrClient}.
     */
    static EmrClientBuilder builder() {
        return new DefaultEmrClientBuilder();
    }

    /**
     * <p>
     * Adds an instance fleet to a running cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.
     * </p>
     * </note>
     *
     * @param addInstanceFleetRequest
     * @return Result of the AddInstanceFleet operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.AddInstanceFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default AddInstanceFleetResponse addInstanceFleet(AddInstanceFleetRequest addInstanceFleetRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an instance fleet to a running cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddInstanceFleetRequest.Builder} avoiding the need
     * to create one manually via {@link AddInstanceFleetRequest#builder()}
     * </p>
     *
     * @param addInstanceFleetRequest
     *        A {@link Consumer} that will call methods on {@link AddInstanceFleetInput.Builder} to create a request.
     * @return Result of the AddInstanceFleet operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.AddInstanceFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default AddInstanceFleetResponse addInstanceFleet(Consumer<AddInstanceFleetRequest.Builder> addInstanceFleetRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return addInstanceFleet(AddInstanceFleetRequest.builder().applyMutation(addInstanceFleetRequest).build());
    }

    /**
     * <p>
     * Adds one or more instance groups to a running cluster.
     * </p>
     *
     * @param addInstanceGroupsRequest
     *        Input to an AddInstanceGroups call.
     * @return Result of the AddInstanceGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.AddInstanceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default AddInstanceGroupsResponse addInstanceGroups(AddInstanceGroupsRequest addInstanceGroupsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more instance groups to a running cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddInstanceGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link AddInstanceGroupsRequest#builder()}
     * </p>
     *
     * @param addInstanceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link AddInstanceGroupsInput.Builder} to create a request.
     *        Input to an AddInstanceGroups call.
     * @return Result of the AddInstanceGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.AddInstanceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default AddInstanceGroupsResponse addInstanceGroups(Consumer<AddInstanceGroupsRequest.Builder> addInstanceGroupsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        return addInstanceGroups(AddInstanceGroupsRequest.builder().applyMutation(addInstanceGroupsRequest).build());
    }

    /**
     * <p>
     * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.
     * </p>
     * <p>
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps
     * to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to
     * the master node and submitting queries directly to the software running on the master node, such as Hive and
     * Hadoop. For more information on how to do this, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to
     * a Cluster</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <p>
     * A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each
     * step is performed by the main function of the main class of the JAR file. The main class can be specified either
     * in the manifest of the JAR or by using the MainFunction parameter of the step.
     * </p>
     * <p>
     * Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must
     * exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run
     * successfully.
     * </p>
     * <p>
     * You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or
     * WAITING.
     * </p>
     *
     * @param addJobFlowStepsRequest
     *        The input argument to the <a>AddJobFlowSteps</a> operation.
     * @return Result of the AddJobFlowSteps operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.AddJobFlowSteps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddJobFlowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default AddJobFlowStepsResponse addJobFlowSteps(AddJobFlowStepsRequest addJobFlowStepsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.
     * </p>
     * <p>
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps
     * to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to
     * the master node and submitting queries directly to the software running on the master node, such as Hive and
     * Hadoop. For more information on how to do this, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to
     * a Cluster</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <p>
     * A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each
     * step is performed by the main function of the main class of the JAR file. The main class can be specified either
     * in the manifest of the JAR or by using the MainFunction parameter of the step.
     * </p>
     * <p>
     * Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must
     * exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run
     * successfully.
     * </p>
     * <p>
     * You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or
     * WAITING.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddJobFlowStepsRequest.Builder} avoiding the need
     * to create one manually via {@link AddJobFlowStepsRequest#builder()}
     * </p>
     *
     * @param addJobFlowStepsRequest
     *        A {@link Consumer} that will call methods on {@link AddJobFlowStepsInput.Builder} to create a request. The
     *        input argument to the <a>AddJobFlowSteps</a> operation.
     * @return Result of the AddJobFlowSteps operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.AddJobFlowSteps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddJobFlowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default AddJobFlowStepsResponse addJobFlowSteps(Consumer<AddJobFlowStepsRequest.Builder> addJobFlowStepsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        return addJobFlowSteps(AddJobFlowStepsRequest.builder().applyMutation(addJobFlowStepsRequest).build());
    }

    /**
     * <p>
     * Adds tags to an Amazon EMR resource. Tags make it easier to associate clusters in various ways, such as grouping
     * clusters to track your Amazon EMR resource allocation costs. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>.
     * </p>
     *
     * @param addTagsRequest
     *        This input identifies a cluster and a list of tags to attach.
     * @return Result of the AddTags operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.AddTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws InternalServerException, InvalidRequestException,
            AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to an Amazon EMR resource. Tags make it easier to associate clusters in various ways, such as grouping
     * clusters to track your Amazon EMR resource allocation costs. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsInput.Builder} to create a request. This input
     *        identifies a cluster and a list of tags to attach.
     * @return Result of the AddTags operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.AddTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsResponse addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later,
     * excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is
     * idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is
     * successfully submitted. You can only cancel steps that are in a <code>PENDING</code> state.
     * </p>
     *
     * @param cancelStepsRequest
     *        The input argument to the <a>CancelSteps</a> operation.
     * @return Result of the CancelSteps operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.CancelSteps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelSteps" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelStepsResponse cancelSteps(CancelStepsRequest cancelStepsRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later,
     * excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is
     * idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is
     * successfully submitted. You can only cancel steps that are in a <code>PENDING</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelStepsRequest.Builder} avoiding the need to
     * create one manually via {@link CancelStepsRequest#builder()}
     * </p>
     *
     * @param cancelStepsRequest
     *        A {@link Consumer} that will call methods on {@link CancelStepsInput.Builder} to create a request. The
     *        input argument to the <a>CancelSteps</a> operation.
     * @return Result of the CancelSteps operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.CancelSteps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CancelSteps" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelStepsResponse cancelSteps(Consumer<CancelStepsRequest.Builder> cancelStepsRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return cancelSteps(CancelStepsRequest.builder().applyMutation(cancelStepsRequest).build());
    }

    /**
     * <p>
     * Creates a security configuration, which is stored in the service and can be specified when a cluster is created.
     * </p>
     *
     * @param createSecurityConfigurationRequest
     * @return Result of the CreateSecurityConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.CreateSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSecurityConfigurationResponse createSecurityConfiguration(
            CreateSecurityConfigurationRequest createSecurityConfigurationRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a security configuration, which is stored in the service and can be specified when a cluster is created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param createSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSecurityConfigurationInput.Builder} to create a
     *        request.
     * @return Result of the CreateSecurityConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.CreateSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSecurityConfigurationResponse createSecurityConfiguration(
            Consumer<CreateSecurityConfigurationRequest.Builder> createSecurityConfigurationRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return createSecurityConfiguration(CreateSecurityConfigurationRequest.builder()
                .applyMutation(createSecurityConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Creates a new Amazon EMR Studio.
     * </p>
     *
     * @param createStudioRequest
     * @return Result of the CreateStudio operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.CreateStudio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStudioResponse createStudio(CreateStudioRequest createStudioRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Creates a new Amazon EMR Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStudioRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStudioRequest#builder()}
     * </p>
     *
     * @param createStudioRequest
     *        A {@link Consumer} that will call methods on {@link CreateStudioInput.Builder} to create a request.
     * @return Result of the CreateStudio operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.CreateStudio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStudioResponse createStudio(Consumer<CreateStudioRequest.Builder> createStudioRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return createStudio(CreateStudioRequest.builder().applyMutation(createStudioRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Maps a user or group to the Amazon EMR Studio specified by <code>StudioId</code>, and applies a session policy to
     * refine Studio permissions for that user or group.
     * </p>
     *
     * @param createStudioSessionMappingRequest
     * @return Result of the CreateStudioSessionMapping operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.CreateStudioSessionMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStudioSessionMappingResponse createStudioSessionMapping(
            CreateStudioSessionMappingRequest createStudioSessionMappingRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Maps a user or group to the Amazon EMR Studio specified by <code>StudioId</code>, and applies a session policy to
     * refine Studio permissions for that user or group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStudioSessionMappingRequest.Builder} avoiding
     * the need to create one manually via {@link CreateStudioSessionMappingRequest#builder()}
     * </p>
     *
     * @param createStudioSessionMappingRequest
     *        A {@link Consumer} that will call methods on {@link CreateStudioSessionMappingInput.Builder} to create a
     *        request.
     * @return Result of the CreateStudioSessionMapping operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.CreateStudioSessionMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/CreateStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStudioSessionMappingResponse createStudioSessionMapping(
            Consumer<CreateStudioSessionMappingRequest.Builder> createStudioSessionMappingRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return createStudioSessionMapping(CreateStudioSessionMappingRequest.builder()
                .applyMutation(createStudioSessionMappingRequest).build());
    }

    /**
     * <p>
     * Deletes a security configuration.
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     * @return Result of the DeleteSecurityConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DeleteSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSecurityConfigurationResponse deleteSecurityConfiguration(
            DeleteSecurityConfigurationRequest deleteSecurityConfigurationRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a security configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSecurityConfigurationInput.Builder} to create a
     *        request.
     * @return Result of the DeleteSecurityConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DeleteSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSecurityConfigurationResponse deleteSecurityConfiguration(
            Consumer<DeleteSecurityConfigurationRequest.Builder> deleteSecurityConfigurationRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return deleteSecurityConfiguration(DeleteSecurityConfigurationRequest.builder()
                .applyMutation(deleteSecurityConfigurationRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Removes an Amazon EMR Studio from the Studio metadata store.
     * </p>
     *
     * @param deleteStudioRequest
     * @return Result of the DeleteStudio operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DeleteStudio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteStudioResponse deleteStudio(DeleteStudioRequest deleteStudioRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Removes an Amazon EMR Studio from the Studio metadata store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStudioRequest#builder()}
     * </p>
     *
     * @param deleteStudioRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStudioInput.Builder} to create a request.
     * @return Result of the DeleteStudio operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DeleteStudio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudio" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteStudioResponse deleteStudio(Consumer<DeleteStudioRequest.Builder> deleteStudioRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return deleteStudio(DeleteStudioRequest.builder().applyMutation(deleteStudioRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Removes a user or group from an Amazon EMR Studio.
     * </p>
     *
     * @param deleteStudioSessionMappingRequest
     * @return Result of the DeleteStudioSessionMapping operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DeleteStudioSessionMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStudioSessionMappingResponse deleteStudioSessionMapping(
            DeleteStudioSessionMappingRequest deleteStudioSessionMappingRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Removes a user or group from an Amazon EMR Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioSessionMappingRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteStudioSessionMappingRequest#builder()}
     * </p>
     *
     * @param deleteStudioSessionMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStudioSessionMappingInput.Builder} to create a
     *        request.
     * @return Result of the DeleteStudioSessionMapping operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DeleteStudioSessionMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DeleteStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStudioSessionMappingResponse deleteStudioSessionMapping(
            Consumer<DeleteStudioSessionMappingRequest.Builder> deleteStudioSessionMappingRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return deleteStudioSessionMapping(DeleteStudioSessionMappingRequest.builder()
                .applyMutation(deleteStudioSessionMappingRequest).build());
    }

    /**
     * <p>
     * Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.
     * </p>
     *
     * @param describeClusterRequest
     *        This input determines which cluster to describe.
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterInput.Builder} to create a request.
     *        This input determines which cluster to describe.
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterResponse describeCluster(Consumer<DescribeClusterRequest.Builder> describeClusterRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     * <p>
     * Provides details of a notebook execution.
     * </p>
     *
     * @param describeNotebookExecutionRequest
     * @return Result of the DescribeNotebookExecution operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeNotebookExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookExecutionResponse describeNotebookExecution(
            DescribeNotebookExecutionRequest describeNotebookExecutionRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details of a notebook execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotebookExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeNotebookExecutionRequest#builder()}
     * </p>
     *
     * @param describeNotebookExecutionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNotebookExecutionInput.Builder} to create a
     *        request.
     * @return Result of the DescribeNotebookExecution operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeNotebookExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotebookExecutionResponse describeNotebookExecution(
            Consumer<DescribeNotebookExecutionRequest.Builder> describeNotebookExecutionRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return describeNotebookExecution(DescribeNotebookExecutionRequest.builder()
                .applyMutation(describeNotebookExecutionRequest).build());
    }

    /**
     * <p>
     * Provides the details of a security configuration by returning the configuration JSON.
     * </p>
     *
     * @param describeSecurityConfigurationRequest
     * @return Result of the DescribeSecurityConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityConfigurationResponse describeSecurityConfiguration(
            DescribeSecurityConfigurationRequest describeSecurityConfigurationRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details of a security configuration by returning the configuration JSON.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSecurityConfigurationRequest#builder()}
     * </p>
     *
     * @param describeSecurityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSecurityConfigurationInput.Builder} to create
     *        a request.
     * @return Result of the DescribeSecurityConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeSecurityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeSecurityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityConfigurationResponse describeSecurityConfiguration(
            Consumer<DescribeSecurityConfigurationRequest.Builder> describeSecurityConfigurationRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return describeSecurityConfiguration(DescribeSecurityConfigurationRequest.builder()
                .applyMutation(describeSecurityConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides more detail about the cluster step.
     * </p>
     *
     * @param describeStepRequest
     *        This input determines which step to describe.
     * @return Result of the DescribeStep operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeStep
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStep" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStepResponse describeStep(DescribeStepRequest describeStepRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more detail about the cluster step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStepRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStepRequest#builder()}
     * </p>
     *
     * @param describeStepRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStepInput.Builder} to create a request. This
     *        input determines which step to describe.
     * @return Result of the DescribeStep operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeStep
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStep" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStepResponse describeStep(Consumer<DescribeStepRequest.Builder> describeStepRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return describeStep(DescribeStepRequest.builder().applyMutation(describeStepRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.
     * </p>
     *
     * @param describeStudioRequest
     * @return Result of the DescribeStudio operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeStudio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStudio"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStudioResponse describeStudio(DescribeStudioRequest describeStudioRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStudioRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStudioRequest#builder()}
     * </p>
     *
     * @param describeStudioRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStudioInput.Builder} to create a request.
     * @return Result of the DescribeStudio operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.DescribeStudio
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeStudio"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStudioResponse describeStudio(Consumer<DescribeStudioRequest.Builder> describeStudioRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return describeStudio(DescribeStudioRequest.builder().applyMutation(describeStudioRequest).build());
    }

    /**
     * <p>
     * Returns the Amazon EMR block public access configuration for your AWS account in the current Region. For more
     * information see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     *
     * @param getBlockPublicAccessConfigurationRequest
     * @return Result of the GetBlockPublicAccessConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.GetBlockPublicAccessConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetBlockPublicAccessConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBlockPublicAccessConfigurationResponse getBlockPublicAccessConfiguration(
            GetBlockPublicAccessConfigurationRequest getBlockPublicAccessConfigurationRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Amazon EMR block public access configuration for your AWS account in the current Region. For more
     * information see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlockPublicAccessConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetBlockPublicAccessConfigurationRequest#builder()}
     * </p>
     *
     * @param getBlockPublicAccessConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetBlockPublicAccessConfigurationInput.Builder} to
     *        create a request.
     * @return Result of the GetBlockPublicAccessConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.GetBlockPublicAccessConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetBlockPublicAccessConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBlockPublicAccessConfigurationResponse getBlockPublicAccessConfiguration(
            Consumer<GetBlockPublicAccessConfigurationRequest.Builder> getBlockPublicAccessConfigurationRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return getBlockPublicAccessConfiguration(GetBlockPublicAccessConfigurationRequest.builder()
                .applyMutation(getBlockPublicAccessConfigurationRequest).build());
    }

    /**
     * <p>
     * Fetches the attached managed scaling policy for an Amazon EMR cluster.
     * </p>
     *
     * @param getManagedScalingPolicyRequest
     * @return Result of the GetManagedScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.GetManagedScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedScalingPolicyResponse getManagedScalingPolicy(GetManagedScalingPolicyRequest getManagedScalingPolicyRequest)
            throws AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the attached managed scaling policy for an Amazon EMR cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedScalingPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetManagedScalingPolicyRequest#builder()}
     * </p>
     *
     * @param getManagedScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetManagedScalingPolicyInput.Builder} to create a
     *        request.
     * @return Result of the GetManagedScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.GetManagedScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedScalingPolicyResponse getManagedScalingPolicy(
            Consumer<GetManagedScalingPolicyRequest.Builder> getManagedScalingPolicyRequest) throws AwsServiceException,
            SdkClientException, EmrException {
        return getManagedScalingPolicy(GetManagedScalingPolicyRequest.builder().applyMutation(getManagedScalingPolicyRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).
     * </p>
     *
     * @param getStudioSessionMappingRequest
     * @return Result of the GetStudioSessionMapping operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.GetStudioSessionMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStudioSessionMappingResponse getStudioSessionMapping(GetStudioSessionMappingRequest getStudioSessionMappingRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStudioSessionMappingRequest.Builder} avoiding
     * the need to create one manually via {@link GetStudioSessionMappingRequest#builder()}
     * </p>
     *
     * @param getStudioSessionMappingRequest
     *        A {@link Consumer} that will call methods on {@link GetStudioSessionMappingInput.Builder} to create a
     *        request.
     * @return Result of the GetStudioSessionMapping operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.GetStudioSessionMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/GetStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStudioSessionMappingResponse getStudioSessionMapping(
            Consumer<GetStudioSessionMappingRequest.Builder> getStudioSessionMappingRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return getStudioSessionMapping(GetStudioSessionMappingRequest.builder().applyMutation(getStudioSessionMappingRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the bootstrap actions associated with a cluster.
     * </p>
     *
     * @param listBootstrapActionsRequest
     *        This input determines which bootstrap actions to retrieve.
     * @return Result of the ListBootstrapActions operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListBootstrapActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBootstrapActionsResponse listBootstrapActions(ListBootstrapActionsRequest listBootstrapActionsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the bootstrap actions associated with a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBootstrapActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBootstrapActionsRequest#builder()}
     * </p>
     *
     * @param listBootstrapActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBootstrapActionsInput.Builder} to create a
     *        request. This input determines which bootstrap actions to retrieve.
     * @return Result of the ListBootstrapActions operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListBootstrapActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBootstrapActionsResponse listBootstrapActions(
            Consumer<ListBootstrapActionsRequest.Builder> listBootstrapActionsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listBootstrapActions(ListBootstrapActionsRequest.builder().applyMutation(listBootstrapActionsRequest).build());
    }

    /**
     * <p>
     * Provides information about the bootstrap actions associated with a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBootstrapActions(software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsIterable responses = client.listBootstrapActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsIterable responses = client
     *             .listBootstrapActionsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsIterable responses = client.listBootstrapActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBootstrapActions(software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBootstrapActionsRequest
     *        This input determines which bootstrap actions to retrieve.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListBootstrapActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBootstrapActionsIterable listBootstrapActionsPaginator(ListBootstrapActionsRequest listBootstrapActionsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the bootstrap actions associated with a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBootstrapActions(software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsIterable responses = client.listBootstrapActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsIterable responses = client
     *             .listBootstrapActionsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListBootstrapActionsIterable responses = client.listBootstrapActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBootstrapActions(software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBootstrapActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBootstrapActionsRequest#builder()}
     * </p>
     *
     * @param listBootstrapActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBootstrapActionsInput.Builder} to create a
     *        request. This input determines which bootstrap actions to retrieve.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListBootstrapActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListBootstrapActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBootstrapActionsIterable listBootstrapActionsPaginator(
            Consumer<ListBootstrapActionsRequest.Builder> listBootstrapActionsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listBootstrapActionsPaginator(ListBootstrapActionsRequest.builder().applyMutation(listBootstrapActionsRequest)
                .build());
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this AWS account. Allows you to filter the list of clusters based
     * on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a
     * maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple
     * ListClusters calls.
     * </p>
     *
     * @return Result of the ListClusters operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListClusters
     * @see #listClusters(ListClustersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersResponse listClusters() throws InternalServerException, InvalidRequestException, AwsServiceException,
            SdkClientException, EmrException {
        return listClusters(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this AWS account. Allows you to filter the list of clusters based
     * on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a
     * maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple
     * ListClusters calls.
     * </p>
     *
     * @param listClustersRequest
     *        This input determines how the ListClusters action filters the list of clusters that it returns.
     * @return Result of the ListClusters operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this AWS account. Allows you to filter the list of clusters based
     * on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a
     * maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple
     * ListClusters calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on {@link ListClustersInput.Builder} to create a request. This
     *        input determines how the ListClusters action filters the list of clusters that it returns.
     * @return Result of the ListClusters operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersResponse listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listClusters(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this AWS account. Allows you to filter the list of clusters based
     * on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a
     * maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple
     * ListClusters calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListClusters
     * @see #listClustersPaginator(ListClustersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersIterable listClustersPaginator() throws InternalServerException, InvalidRequestException,
            AwsServiceException, SdkClientException, EmrException {
        return listClustersPaginator(ListClustersRequest.builder().build());
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this AWS account. Allows you to filter the list of clusters based
     * on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a
     * maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple
     * ListClusters calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)} operation.</b>
     * </p>
     *
     * @param listClustersRequest
     *        This input determines how the ListClusters action filters the list of clusters that it returns.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the status of all clusters visible to this AWS account. Allows you to filter the list of clusters based
     * on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a
     * maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple
     * ListClusters calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListClustersIterable responses = client.listClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClusters(software.amazon.awssdk.services.emr.model.ListClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListClustersRequest.Builder} avoiding the need to
     * create one manually via {@link ListClustersRequest#builder()}
     * </p>
     *
     * @param listClustersRequest
     *        A {@link Consumer} that will call methods on {@link ListClustersInput.Builder} to create a request. This
     *        input determines how the ListClusters action filters the list of clusters that it returns.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default ListClustersIterable listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listClustersPaginator(ListClustersRequest.builder().applyMutation(listClustersRequest).build());
    }

    /**
     * <p>
     * Lists all available details about the instance fleets in a cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note>
     *
     * @param listInstanceFleetsRequest
     * @return Result of the ListInstanceFleets operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstanceFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceFleetsResponse listInstanceFleets(ListInstanceFleetsRequest listInstanceFleetsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available details about the instance fleets in a cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceFleetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceFleetsRequest#builder()}
     * </p>
     *
     * @param listInstanceFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceFleetsInput.Builder} to create a request.
     * @return Result of the ListInstanceFleets operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstanceFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceFleetsResponse listInstanceFleets(Consumer<ListInstanceFleetsRequest.Builder> listInstanceFleetsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listInstanceFleets(ListInstanceFleetsRequest.builder().applyMutation(listInstanceFleetsRequest).build());
    }

    /**
     * <p>
     * Lists all available details about the instance fleets in a cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceFleets(software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsIterable responses = client.listInstanceFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsIterable responses = client
     *             .listInstanceFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsIterable responses = client.listInstanceFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceFleets(software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listInstanceFleetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstanceFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceFleetsIterable listInstanceFleetsPaginator(ListInstanceFleetsRequest listInstanceFleetsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available details about the instance fleets in a cluster.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceFleets(software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsIterable responses = client.listInstanceFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsIterable responses = client
     *             .listInstanceFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceFleetsIterable responses = client.listInstanceFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceFleets(software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceFleetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceFleetsRequest#builder()}
     * </p>
     *
     * @param listInstanceFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceFleetsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstanceFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceFleetsIterable listInstanceFleetsPaginator(
            Consumer<ListInstanceFleetsRequest.Builder> listInstanceFleetsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listInstanceFleetsPaginator(ListInstanceFleetsRequest.builder().applyMutation(listInstanceFleetsRequest).build());
    }

    /**
     * <p>
     * Provides all available details about the instance groups in a cluster.
     * </p>
     *
     * @param listInstanceGroupsRequest
     *        This input determines which instance groups to retrieve.
     * @return Result of the ListInstanceGroups operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstanceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceGroupsResponse listInstanceGroups(ListInstanceGroupsRequest listInstanceGroupsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides all available details about the instance groups in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceGroupsRequest#builder()}
     * </p>
     *
     * @param listInstanceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceGroupsInput.Builder} to create a request.
     *        This input determines which instance groups to retrieve.
     * @return Result of the ListInstanceGroups operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstanceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceGroupsResponse listInstanceGroups(Consumer<ListInstanceGroupsRequest.Builder> listInstanceGroupsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listInstanceGroups(ListInstanceGroupsRequest.builder().applyMutation(listInstanceGroupsRequest).build());
    }

    /**
     * <p>
     * Provides all available details about the instance groups in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceGroups(software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsIterable responses = client.listInstanceGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsIterable responses = client
     *             .listInstanceGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsIterable responses = client.listInstanceGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceGroups(software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listInstanceGroupsRequest
     *        This input determines which instance groups to retrieve.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstanceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceGroupsIterable listInstanceGroupsPaginator(ListInstanceGroupsRequest listInstanceGroupsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides all available details about the instance groups in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceGroups(software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsIterable responses = client.listInstanceGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsIterable responses = client
     *             .listInstanceGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstanceGroupsIterable responses = client.listInstanceGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceGroups(software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceGroupsRequest#builder()}
     * </p>
     *
     * @param listInstanceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListInstanceGroupsInput.Builder} to create a request.
     *        This input determines which instance groups to retrieve.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstanceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceGroupsIterable listInstanceGroupsPaginator(
            Consumer<ListInstanceGroupsRequest.Builder> listInstanceGroupsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listInstanceGroupsPaginator(ListInstanceGroupsRequest.builder().applyMutation(listInstanceGroupsRequest).build());
    }

    /**
     * <p>
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a
     * maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT,
     * PROVISIONING, BOOTSTRAPPING, RUNNING.
     * </p>
     *
     * @param listInstancesRequest
     *        This input determines which instances to list.
     * @return Result of the ListInstances operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a
     * maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT,
     * PROVISIONING, BOOTSTRAPPING, RUNNING.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesInput.Builder} to create a request. This
     *        input determines which instances to list.
     * @return Result of the ListInstances operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a
     * maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT,
     * PROVISIONING, BOOTSTRAPPING, RUNNING.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.emr.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.emr.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     *        This input determines which instances to list.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a
     * maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT,
     * PROVISIONING, BOOTSTRAPPING, RUNNING.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.emr.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.emr.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on {@link ListInstancesInput.Builder} to create a request. This
     *        input determines which instances to list.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status,
     * time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a
     * longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.
     * </p>
     *
     * @param listNotebookExecutionsRequest
     * @return Result of the ListNotebookExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListNotebookExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookExecutionsResponse listNotebookExecutions(ListNotebookExecutionsRequest listNotebookExecutionsRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status,
     * time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a
     * longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotebookExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotebookExecutionsRequest#builder()}
     * </p>
     *
     * @param listNotebookExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotebookExecutionsInput.Builder} to create a
     *        request.
     * @return Result of the ListNotebookExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListNotebookExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookExecutionsResponse listNotebookExecutions(
            Consumer<ListNotebookExecutionsRequest.Builder> listNotebookExecutionsRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listNotebookExecutions(ListNotebookExecutionsRequest.builder().applyMutation(listNotebookExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status,
     * time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a
     * longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookExecutions(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsIterable responses = client.listNotebookExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsIterable responses = client
     *             .listNotebookExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsIterable responses = client.listNotebookExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookExecutions(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNotebookExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListNotebookExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookExecutionsIterable listNotebookExecutionsPaginator(
            ListNotebookExecutionsRequest listNotebookExecutionsRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status,
     * time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a
     * longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNotebookExecutions(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsIterable responses = client.listNotebookExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsIterable responses = client
     *             .listNotebookExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListNotebookExecutionsIterable responses = client.listNotebookExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNotebookExecutions(software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNotebookExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNotebookExecutionsRequest#builder()}
     * </p>
     *
     * @param listNotebookExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link ListNotebookExecutionsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListNotebookExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListNotebookExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNotebookExecutionsIterable listNotebookExecutionsPaginator(
            Consumer<ListNotebookExecutionsRequest.Builder> listNotebookExecutionsRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listNotebookExecutionsPaginator(ListNotebookExecutionsRequest.builder()
                .applyMutation(listNotebookExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     *
     * @return Result of the ListSecurityConfigurations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSecurityConfigurations
     * @see #listSecurityConfigurations(ListSecurityConfigurationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsResponse listSecurityConfigurations() throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listSecurityConfigurations(ListSecurityConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     *
     * @param listSecurityConfigurationsRequest
     * @return Result of the ListSecurityConfigurations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsResponse listSecurityConfigurations(
            ListSecurityConfigurationsRequest listSecurityConfigurationsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSecurityConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSecurityConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityConfigurationsInput.Builder} to create a
     *        request.
     * @return Result of the ListSecurityConfigurations operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsResponse listSecurityConfigurations(
            Consumer<ListSecurityConfigurationsRequest.Builder> listSecurityConfigurationsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listSecurityConfigurations(ListSecurityConfigurationsRequest.builder()
                .applyMutation(listSecurityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client.listSecurityConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client
     *             .listSecurityConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client.listSecurityConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSecurityConfigurations
     * @see #listSecurityConfigurationsPaginator(ListSecurityConfigurationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsIterable listSecurityConfigurationsPaginator() throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listSecurityConfigurationsPaginator(ListSecurityConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client.listSecurityConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client
     *             .listSecurityConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client.listSecurityConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsIterable listSecurityConfigurationsPaginator(
            ListSecurityConfigurationsRequest listSecurityConfigurationsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the security configurations visible to this account, providing their creation dates and times, and
     * their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the
     * cluster list across multiple ListSecurityConfigurations calls.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client.listSecurityConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client
     *             .listSecurityConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListSecurityConfigurationsIterable responses = client.listSecurityConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigurations(software.amazon.awssdk.services.emr.model.ListSecurityConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSecurityConfigurationsRequest#builder()}
     * </p>
     *
     * @param listSecurityConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSecurityConfigurationsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSecurityConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSecurityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigurationsIterable listSecurityConfigurationsPaginator(
            Consumer<ListSecurityConfigurationsRequest.Builder> listSecurityConfigurationsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listSecurityConfigurationsPaginator(ListSecurityConfigurationsRequest.builder()
                .applyMutation(listSecurityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the
     * request of filter by <code>StepStates</code>. You can specify a maximum of ten <code>stepIDs</code>.
     * </p>
     *
     * @param listStepsRequest
     *        This input determines which steps to list.
     * @return Result of the ListSteps operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSteps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsResponse listSteps(ListStepsRequest listStepsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the
     * request of filter by <code>StepStates</code>. You can specify a maximum of ten <code>stepIDs</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStepsRequest#builder()}
     * </p>
     *
     * @param listStepsRequest
     *        A {@link Consumer} that will call methods on {@link ListStepsInput.Builder} to create a request. This
     *        input determines which steps to list.
     * @return Result of the ListSteps operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSteps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsResponse listSteps(Consumer<ListStepsRequest.Builder> listStepsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listSteps(ListStepsRequest.builder().applyMutation(listStepsRequest).build());
    }

    /**
     * <p>
     * Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the
     * request of filter by <code>StepStates</code>. You can specify a maximum of ten <code>stepIDs</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSteps(software.amazon.awssdk.services.emr.model.ListStepsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSteps(software.amazon.awssdk.services.emr.model.ListStepsRequest)} operation.</b>
     * </p>
     *
     * @param listStepsRequest
     *        This input determines which steps to list.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSteps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsIterable listStepsPaginator(ListStepsRequest listStepsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the
     * request of filter by <code>StepStates</code>. You can specify a maximum of ten <code>stepIDs</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSteps(software.amazon.awssdk.services.emr.model.ListStepsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListStepsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStepsIterable responses = client.listStepsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSteps(software.amazon.awssdk.services.emr.model.ListStepsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStepsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStepsRequest#builder()}
     * </p>
     *
     * @param listStepsRequest
     *        A {@link Consumer} that will call methods on {@link ListStepsInput.Builder} to create a request. This
     *        input determines which steps to list.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListSteps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStepsIterable listStepsPaginator(Consumer<ListStepsRequest.Builder> listStepsRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listStepsPaginator(ListStepsRequest.builder().applyMutation(listStepsRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all user or group session mappings for the EMR Studio specified by <code>StudioId</code>.
     * </p>
     *
     * @param listStudioSessionMappingsRequest
     * @return Result of the ListStudioSessionMappings operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListStudioSessionMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStudioSessionMappingsResponse listStudioSessionMappings(
            ListStudioSessionMappingsRequest listStudioSessionMappingsRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all user or group session mappings for the EMR Studio specified by <code>StudioId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudioSessionMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStudioSessionMappingsRequest#builder()}
     * </p>
     *
     * @param listStudioSessionMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListStudioSessionMappingsInput.Builder} to create a
     *        request.
     * @return Result of the ListStudioSessionMappings operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListStudioSessionMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStudioSessionMappingsResponse listStudioSessionMappings(
            Consumer<ListStudioSessionMappingsRequest.Builder> listStudioSessionMappingsRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listStudioSessionMappings(ListStudioSessionMappingsRequest.builder()
                .applyMutation(listStudioSessionMappingsRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all user or group session mappings for the EMR Studio specified by <code>StudioId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStudioSessionMappings(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsIterable responses = client.listStudioSessionMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsIterable responses = client
     *             .listStudioSessionMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsIterable responses = client.listStudioSessionMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioSessionMappings(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStudioSessionMappingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListStudioSessionMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStudioSessionMappingsIterable listStudioSessionMappingsPaginator(
            ListStudioSessionMappingsRequest listStudioSessionMappingsRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all user or group session mappings for the EMR Studio specified by <code>StudioId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStudioSessionMappings(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsIterable responses = client.listStudioSessionMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsIterable responses = client
     *             .listStudioSessionMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudioSessionMappingsIterable responses = client.listStudioSessionMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudioSessionMappings(software.amazon.awssdk.services.emr.model.ListStudioSessionMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudioSessionMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStudioSessionMappingsRequest#builder()}
     * </p>
     *
     * @param listStudioSessionMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListStudioSessionMappingsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListStudioSessionMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudioSessionMappings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStudioSessionMappingsIterable listStudioSessionMappingsPaginator(
            Consumer<ListStudioSessionMappingsRequest.Builder> listStudioSessionMappingsRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listStudioSessionMappingsPaginator(ListStudioSessionMappingsRequest.builder()
                .applyMutation(listStudioSessionMappingsRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all Amazon EMR Studios associated with the AWS account. The list includes details such as ID,
     * Studio Access URL, and creation time for each Studio.
     * </p>
     *
     * @param listStudiosRequest
     * @return Result of the ListStudios operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListStudios
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStudiosResponse listStudios(ListStudiosRequest listStudiosRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all Amazon EMR Studios associated with the AWS account. The list includes details such as ID,
     * Studio Access URL, and creation time for each Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudiosRequest.Builder} avoiding the need to
     * create one manually via {@link ListStudiosRequest#builder()}
     * </p>
     *
     * @param listStudiosRequest
     *        A {@link Consumer} that will call methods on {@link ListStudiosInput.Builder} to create a request.
     * @return Result of the ListStudios operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListStudios
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStudiosResponse listStudios(Consumer<ListStudiosRequest.Builder> listStudiosRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listStudios(ListStudiosRequest.builder().applyMutation(listStudiosRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all Amazon EMR Studios associated with the AWS account. The list includes details such as ID,
     * Studio Access URL, and creation time for each Studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStudios(software.amazon.awssdk.services.emr.model.ListStudiosRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudiosIterable responses = client.listStudiosPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListStudiosIterable responses = client.listStudiosPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListStudiosResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudiosIterable responses = client.listStudiosPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudios(software.amazon.awssdk.services.emr.model.ListStudiosRequest)} operation.</b>
     * </p>
     *
     * @param listStudiosRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListStudios
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStudiosIterable listStudiosPaginator(ListStudiosRequest listStudiosRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Returns a list of all Amazon EMR Studios associated with the AWS account. The list includes details such as ID,
     * Studio Access URL, and creation time for each Studio.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStudios(software.amazon.awssdk.services.emr.model.ListStudiosRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudiosIterable responses = client.listStudiosPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.emr.paginators.ListStudiosIterable responses = client.listStudiosPaginator(request);
     *     for (software.amazon.awssdk.services.emr.model.ListStudiosResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.emr.paginators.ListStudiosIterable responses = client.listStudiosPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStudios(software.amazon.awssdk.services.emr.model.ListStudiosRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStudiosRequest.Builder} avoiding the need to
     * create one manually via {@link ListStudiosRequest#builder()}
     * </p>
     *
     * @param listStudiosRequest
     *        A {@link Consumer} that will call methods on {@link ListStudiosInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ListStudios
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListStudios" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStudiosIterable listStudiosPaginator(Consumer<ListStudiosRequest.Builder> listStudiosRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return listStudiosPaginator(ListStudiosRequest.builder().applyMutation(listStudiosRequest).build());
    }

    /**
     * <p>
     * Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.
     * </p>
     *
     * @param modifyClusterRequest
     * @return Result of the ModifyCluster operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ModifyCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyClusterResponse modifyCluster(ModifyClusterRequest modifyClusterRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyClusterRequest#builder()}
     * </p>
     *
     * @param modifyClusterRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterInput.Builder} to create a request.
     * @return Result of the ModifyCluster operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ModifyCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyCluster" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyClusterResponse modifyCluster(Consumer<ModifyClusterRequest.Builder> modifyClusterRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return modifyCluster(ModifyClusterRequest.builder().applyMutation(modifyClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified
     * InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note>
     *
     * @param modifyInstanceFleetRequest
     * @return Result of the ModifyInstanceFleet operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ModifyInstanceFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyInstanceFleetResponse modifyInstanceFleet(ModifyInstanceFleetRequest modifyInstanceFleetRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified
     * InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyInstanceFleetRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyInstanceFleetRequest#builder()}
     * </p>
     *
     * @param modifyInstanceFleetRequest
     *        A {@link Consumer} that will call methods on {@link ModifyInstanceFleetInput.Builder} to create a request.
     * @return Result of the ModifyInstanceFleet operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ModifyInstanceFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyInstanceFleetResponse modifyInstanceFleet(
            Consumer<ModifyInstanceFleetRequest.Builder> modifyInstanceFleetRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return modifyInstanceFleet(ModifyInstanceFleetRequest.builder().applyMutation(modifyInstanceFleetRequest).build());
    }

    /**
     * <p>
     * ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input
     * parameters include the new target instance count for the group and the instance group ID. The call will either
     * succeed or fail atomically.
     * </p>
     *
     * @param modifyInstanceGroupsRequest
     *        Change the size of some instance groups.
     * @return Result of the ModifyInstanceGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ModifyInstanceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyInstanceGroupsResponse modifyInstanceGroups(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input
     * parameters include the new target instance count for the group and the instance group ID. The call will either
     * succeed or fail atomically.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyInstanceGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyInstanceGroupsRequest#builder()}
     * </p>
     *
     * @param modifyInstanceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ModifyInstanceGroupsInput.Builder} to create a
     *        request. Change the size of some instance groups.
     * @return Result of the ModifyInstanceGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.ModifyInstanceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyInstanceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyInstanceGroupsResponse modifyInstanceGroups(
            Consumer<ModifyInstanceGroupsRequest.Builder> modifyInstanceGroupsRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, EmrException {
        return modifyInstanceGroups(ModifyInstanceGroupsRequest.builder().applyMutation(modifyInstanceGroupsRequest).build());
    }

    /**
     * <p>
     * Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR
     * cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances
     * in response to the value of a CloudWatch metric.
     * </p>
     *
     * @param putAutoScalingPolicyRequest
     * @return Result of the PutAutoScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.PutAutoScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAutoScalingPolicyResponse putAutoScalingPolicy(PutAutoScalingPolicyRequest putAutoScalingPolicyRequest)
            throws AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR
     * cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances
     * in response to the value of a CloudWatch metric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAutoScalingPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutAutoScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putAutoScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutAutoScalingPolicyInput.Builder} to create a
     *        request.
     * @return Result of the PutAutoScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.PutAutoScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutAutoScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAutoScalingPolicyResponse putAutoScalingPolicy(
            Consumer<PutAutoScalingPolicyRequest.Builder> putAutoScalingPolicyRequest) throws AwsServiceException,
            SdkClientException, EmrException {
        return putAutoScalingPolicy(PutAutoScalingPolicyRequest.builder().applyMutation(putAutoScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Creates or updates an Amazon EMR block public access configuration for your AWS account in the current Region.
     * For more information see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     *
     * @param putBlockPublicAccessConfigurationRequest
     * @return Result of the PutBlockPublicAccessConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.PutBlockPublicAccessConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutBlockPublicAccessConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBlockPublicAccessConfigurationResponse putBlockPublicAccessConfiguration(
            PutBlockPublicAccessConfigurationRequest putBlockPublicAccessConfigurationRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an Amazon EMR block public access configuration for your AWS account in the current Region.
     * For more information see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBlockPublicAccessConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBlockPublicAccessConfigurationRequest#builder()}
     * </p>
     *
     * @param putBlockPublicAccessConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutBlockPublicAccessConfigurationInput.Builder} to
     *        create a request.
     * @return Result of the PutBlockPublicAccessConfiguration operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.PutBlockPublicAccessConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutBlockPublicAccessConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBlockPublicAccessConfigurationResponse putBlockPublicAccessConfiguration(
            Consumer<PutBlockPublicAccessConfigurationRequest.Builder> putBlockPublicAccessConfigurationRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return putBlockPublicAccessConfiguration(PutBlockPublicAccessConfigurationRequest.builder()
                .applyMutation(putBlockPublicAccessConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the
     * limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only
     * applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * </p>
     *
     * @param putManagedScalingPolicyRequest
     * @return Result of the PutManagedScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.PutManagedScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutManagedScalingPolicyResponse putManagedScalingPolicy(PutManagedScalingPolicyRequest putManagedScalingPolicyRequest)
            throws AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the
     * limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only
     * applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutManagedScalingPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutManagedScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putManagedScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutManagedScalingPolicyInput.Builder} to create a
     *        request.
     * @return Result of the PutManagedScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.PutManagedScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/PutManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutManagedScalingPolicyResponse putManagedScalingPolicy(
            Consumer<PutManagedScalingPolicyRequest.Builder> putManagedScalingPolicyRequest) throws AwsServiceException,
            SdkClientException, EmrException {
        return putManagedScalingPolicy(PutManagedScalingPolicyRequest.builder().applyMutation(putManagedScalingPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Removes an automatic scaling policy from a specified instance group within an EMR cluster.
     * </p>
     *
     * @param removeAutoScalingPolicyRequest
     * @return Result of the RemoveAutoScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.RemoveAutoScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveAutoScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAutoScalingPolicyResponse removeAutoScalingPolicy(RemoveAutoScalingPolicyRequest removeAutoScalingPolicyRequest)
            throws AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an automatic scaling policy from a specified instance group within an EMR cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAutoScalingPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveAutoScalingPolicyRequest#builder()}
     * </p>
     *
     * @param removeAutoScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link RemoveAutoScalingPolicyInput.Builder} to create a
     *        request.
     * @return Result of the RemoveAutoScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.RemoveAutoScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveAutoScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAutoScalingPolicyResponse removeAutoScalingPolicy(
            Consumer<RemoveAutoScalingPolicyRequest.Builder> removeAutoScalingPolicyRequest) throws AwsServiceException,
            SdkClientException, EmrException {
        return removeAutoScalingPolicy(RemoveAutoScalingPolicyRequest.builder().applyMutation(removeAutoScalingPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Removes a managed scaling policy from a specified EMR cluster.
     * </p>
     *
     * @param removeManagedScalingPolicyRequest
     * @return Result of the RemoveManagedScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.RemoveManagedScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveManagedScalingPolicyResponse removeManagedScalingPolicy(
            RemoveManagedScalingPolicyRequest removeManagedScalingPolicyRequest) throws AwsServiceException, SdkClientException,
            EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a managed scaling policy from a specified EMR cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveManagedScalingPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveManagedScalingPolicyRequest#builder()}
     * </p>
     *
     * @param removeManagedScalingPolicyRequest
     *        A {@link Consumer} that will call methods on {@link RemoveManagedScalingPolicyInput.Builder} to create a
     *        request.
     * @return Result of the RemoveManagedScalingPolicy operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.RemoveManagedScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveManagedScalingPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveManagedScalingPolicyResponse removeManagedScalingPolicy(
            Consumer<RemoveManagedScalingPolicyRequest.Builder> removeManagedScalingPolicyRequest) throws AwsServiceException,
            SdkClientException, EmrException {
        return removeManagedScalingPolicy(RemoveManagedScalingPolicyRequest.builder()
                .applyMutation(removeManagedScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon EMR resource. Tags make it easier to associate clusters in various ways, such as
     * grouping clusters to track your Amazon EMR resource allocation costs. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>.
     * </p>
     * <p>
     * The following example removes the stack tag with value Prod from a cluster:
     * </p>
     *
     * @param removeTagsRequest
     *        This input identifies a cluster and a list of tags to remove.
     * @return Result of the RemoveTags operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.RemoveTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveTags" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon EMR resource. Tags make it easier to associate clusters in various ways, such as
     * grouping clusters to track your Amazon EMR resource allocation costs. For more information, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>.
     * </p>
     * <p>
     * The following example removes the stack tag with value Prod from a cluster:
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsRequest.Builder} avoiding the need to
     * create one manually via {@link RemoveTagsRequest#builder()}
     * </p>
     *
     * @param removeTagsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsInput.Builder} to create a request. This
     *        input identifies a cluster and a list of tags to remove.
     * @return Result of the RemoveTags operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.RemoveTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RemoveTags" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsResponse removeTags(Consumer<RemoveTagsRequest.Builder> removeTagsRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return removeTags(RemoveTagsRequest.builder().applyMutation(removeTagsRequest).build());
    }

    /**
     * <p>
     * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the
     * steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last
     * step of the job flow to store results in Amazon S3. If the <a>JobFlowInstancesConfig</a>
     * <code>KeepJobFlowAliveWhenNoSteps</code> parameter is set to <code>TRUE</code>, the cluster transitions to the
     * WAITING state rather than shutting down after the steps have completed.
     * </p>
     * <p>
     * For additional protection, you can set the <a>JobFlowInstancesConfig</a> <code>TerminationProtected</code>
     * parameter to <code>TRUE</code> to lock the cluster and prevent it from being terminated by API call, user
     * intervention, or in the event of a job flow error.
     * </p>
     * <p>
     * A maximum of 256 steps are allowed in each job flow.
     * </p>
     * <p>
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps
     * to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to
     * connect to the master node and submitting queries directly to the software running on the master node, such as
     * Hive and Hadoop. For more information on how to do this, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to
     * a Cluster</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <p>
     * For long running clusters, we recommend that you periodically store your results.
     * </p>
     * <note>
     * <p>
     * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not
     * both.
     * </p>
     * </note>
     *
     * @param runJobFlowRequest
     *        Input to the <a>RunJobFlow</a> operation.
     * @return Result of the RunJobFlow operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.RunJobFlow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RunJobFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default RunJobFlowResponse runJobFlow(RunJobFlowRequest runJobFlowRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the
     * steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last
     * step of the job flow to store results in Amazon S3. If the <a>JobFlowInstancesConfig</a>
     * <code>KeepJobFlowAliveWhenNoSteps</code> parameter is set to <code>TRUE</code>, the cluster transitions to the
     * WAITING state rather than shutting down after the steps have completed.
     * </p>
     * <p>
     * For additional protection, you can set the <a>JobFlowInstancesConfig</a> <code>TerminationProtected</code>
     * parameter to <code>TRUE</code> to lock the cluster and prevent it from being terminated by API call, user
     * intervention, or in the event of a job flow error.
     * </p>
     * <p>
     * A maximum of 256 steps are allowed in each job flow.
     * </p>
     * <p>
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps
     * to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to
     * connect to the master node and submitting queries directly to the software running on the master node, such as
     * Hive and Hadoop. For more information on how to do this, see <a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to
     * a Cluster</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <p>
     * For long running clusters, we recommend that you periodically store your results.
     * </p>
     * <note>
     * <p>
     * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not
     * both.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RunJobFlowRequest.Builder} avoiding the need to
     * create one manually via {@link RunJobFlowRequest#builder()}
     * </p>
     *
     * @param runJobFlowRequest
     *        A {@link Consumer} that will call methods on {@link RunJobFlowInput.Builder} to create a request. Input to
     *        the <a>RunJobFlow</a> operation.
     * @return Result of the RunJobFlow operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.RunJobFlow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/RunJobFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default RunJobFlowResponse runJobFlow(Consumer<RunJobFlowRequest.Builder> runJobFlowRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        return runJobFlow(RunJobFlowRequest.builder().applyMutation(runJobFlowRequest).build());
    }

    /**
     * <p>
     * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by
     * user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful
     * completion of the job flow. Calling <code>SetTerminationProtection</code> on a cluster is similar to calling the
     * Amazon EC2 <code>DisableAPITermination</code> API on all EC2 instances in a cluster.
     * </p>
     * <p>
     * <code>SetTerminationProtection</code> is used to prevent accidental termination of a cluster and to ensure that
     * in the event of an error, the instances persist so that you can recover any data stored in their ephemeral
     * instance storage.
     * </p>
     * <p>
     * To terminate a cluster that has been locked by setting <code>SetTerminationProtection</code> to <code>true</code>
     * , you must first unlock the job flow by a subsequent call to <code>SetTerminationProtection</code> in which you
     * set the value to <code>false</code>.
     * </p>
     * <p>
     * For more information, see<a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html">Managing
     * Cluster Termination</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     *
     * @param setTerminationProtectionRequest
     *        The input argument to the <a>TerminationProtection</a> operation.
     * @return Result of the SetTerminationProtection operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.SetTerminationProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTerminationProtectionResponse setTerminationProtection(
            SetTerminationProtectionRequest setTerminationProtectionRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by
     * user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful
     * completion of the job flow. Calling <code>SetTerminationProtection</code> on a cluster is similar to calling the
     * Amazon EC2 <code>DisableAPITermination</code> API on all EC2 instances in a cluster.
     * </p>
     * <p>
     * <code>SetTerminationProtection</code> is used to prevent accidental termination of a cluster and to ensure that
     * in the event of an error, the instances persist so that you can recover any data stored in their ephemeral
     * instance storage.
     * </p>
     * <p>
     * To terminate a cluster that has been locked by setting <code>SetTerminationProtection</code> to <code>true</code>
     * , you must first unlock the job flow by a subsequent call to <code>SetTerminationProtection</code> in which you
     * set the value to <code>false</code>.
     * </p>
     * <p>
     * For more information, see<a
     * href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html">Managing
     * Cluster Termination</a> in the <i>Amazon EMR Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTerminationProtectionRequest.Builder} avoiding
     * the need to create one manually via {@link SetTerminationProtectionRequest#builder()}
     * </p>
     *
     * @param setTerminationProtectionRequest
     *        A {@link Consumer} that will call methods on {@link SetTerminationProtectionInput.Builder} to create a
     *        request. The input argument to the <a>TerminationProtection</a> operation.
     * @return Result of the SetTerminationProtection operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.SetTerminationProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetTerminationProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default SetTerminationProtectionResponse setTerminationProtection(
            Consumer<SetTerminationProtectionRequest.Builder> setTerminationProtectionRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        return setTerminationProtection(SetTerminationProtectionRequest.builder().applyMutation(setTerminationProtectionRequest)
                .build());
    }

    /**
     * <p>
     * Sets the <a>Cluster&#36VisibleToAllUsers</a> value, which determines whether the cluster is visible to all IAM
     * users of the AWS account associated with the cluster. Only the IAM user who created the cluster or the AWS
     * account root user can call this action. The default value, <code>true</code>, indicates that all IAM users in the
     * AWS account can perform cluster actions if they have the proper IAM policy permissions. If set to
     * <code>false</code>, only the IAM user that created the cluster can perform actions. This action works on running
     * clusters. You can override the default <code>true</code> setting when you create a cluster by using the
     * <code>VisibleToAllUsers</code> parameter with <code>RunJobFlow</code>.
     * </p>
     *
     * @param setVisibleToAllUsersRequest
     *        The input to the SetVisibleToAllUsers action.
     * @return Result of the SetVisibleToAllUsers operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.SetVisibleToAllUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetVisibleToAllUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default SetVisibleToAllUsersResponse setVisibleToAllUsers(SetVisibleToAllUsersRequest setVisibleToAllUsersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the <a>Cluster&#36VisibleToAllUsers</a> value, which determines whether the cluster is visible to all IAM
     * users of the AWS account associated with the cluster. Only the IAM user who created the cluster or the AWS
     * account root user can call this action. The default value, <code>true</code>, indicates that all IAM users in the
     * AWS account can perform cluster actions if they have the proper IAM policy permissions. If set to
     * <code>false</code>, only the IAM user that created the cluster can perform actions. This action works on running
     * clusters. You can override the default <code>true</code> setting when you create a cluster by using the
     * <code>VisibleToAllUsers</code> parameter with <code>RunJobFlow</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetVisibleToAllUsersRequest.Builder} avoiding the
     * need to create one manually via {@link SetVisibleToAllUsersRequest#builder()}
     * </p>
     *
     * @param setVisibleToAllUsersRequest
     *        A {@link Consumer} that will call methods on {@link SetVisibleToAllUsersInput.Builder} to create a
     *        request. The input to the SetVisibleToAllUsers action.
     * @return Result of the SetVisibleToAllUsers operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.SetVisibleToAllUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/SetVisibleToAllUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default SetVisibleToAllUsersResponse setVisibleToAllUsers(
            Consumer<SetVisibleToAllUsersRequest.Builder> setVisibleToAllUsersRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, EmrException {
        return setVisibleToAllUsers(SetVisibleToAllUsersRequest.builder().applyMutation(setVisibleToAllUsersRequest).build());
    }

    /**
     * <p>
     * Starts a notebook execution.
     * </p>
     *
     * @param startNotebookExecutionRequest
     * @return Result of the StartNotebookExecution operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.StartNotebookExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StartNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartNotebookExecutionResponse startNotebookExecution(StartNotebookExecutionRequest startNotebookExecutionRequest)
            throws InternalServerException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a notebook execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartNotebookExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StartNotebookExecutionRequest#builder()}
     * </p>
     *
     * @param startNotebookExecutionRequest
     *        A {@link Consumer} that will call methods on {@link StartNotebookExecutionInput.Builder} to create a
     *        request.
     * @return Result of the StartNotebookExecution operation returned by the service.
     * @throws InternalServerException
     *         This exception occurs when there is an internal failure in the EMR service.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.StartNotebookExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StartNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StartNotebookExecutionResponse startNotebookExecution(
            Consumer<StartNotebookExecutionRequest.Builder> startNotebookExecutionRequest) throws InternalServerException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return startNotebookExecution(StartNotebookExecutionRequest.builder().applyMutation(startNotebookExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Stops a notebook execution.
     * </p>
     *
     * @param stopNotebookExecutionRequest
     * @return Result of the StopNotebookExecution operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.StopNotebookExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StopNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StopNotebookExecutionResponse stopNotebookExecution(StopNotebookExecutionRequest stopNotebookExecutionRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a notebook execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopNotebookExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link StopNotebookExecutionRequest#builder()}
     * </p>
     *
     * @param stopNotebookExecutionRequest
     *        A {@link Consumer} that will call methods on {@link StopNotebookExecutionInput.Builder} to create a
     *        request.
     * @return Result of the StopNotebookExecution operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.StopNotebookExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StopNotebookExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default StopNotebookExecutionResponse stopNotebookExecution(
            Consumer<StopNotebookExecutionRequest.Builder> stopNotebookExecutionRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return stopNotebookExecution(StopNotebookExecutionRequest.builder().applyMutation(stopNotebookExecutionRequest).build());
    }

    /**
     * <p>
     * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet
     * completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not
     * already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.
     * </p>
     * <p>
     * The maximum number of clusters allowed is 10. The call to <code>TerminateJobFlows</code> is asynchronous.
     * Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely
     * terminate and release allocated resources, such as Amazon EC2 instances.
     * </p>
     *
     * @param terminateJobFlowsRequest
     *        Input to the <a>TerminateJobFlows</a> operation.
     * @return Result of the TerminateJobFlows operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.TerminateJobFlows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/TerminateJobFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateJobFlowsResponse terminateJobFlows(TerminateJobFlowsRequest terminateJobFlowsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet
     * completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not
     * already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.
     * </p>
     * <p>
     * The maximum number of clusters allowed is 10. The call to <code>TerminateJobFlows</code> is asynchronous.
     * Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely
     * terminate and release allocated resources, such as Amazon EC2 instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateJobFlowsRequest.Builder} avoiding the need
     * to create one manually via {@link TerminateJobFlowsRequest#builder()}
     * </p>
     *
     * @param terminateJobFlowsRequest
     *        A {@link Consumer} that will call methods on {@link TerminateJobFlowsInput.Builder} to create a request.
     *        Input to the <a>TerminateJobFlows</a> operation.
     * @return Result of the TerminateJobFlows operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.TerminateJobFlows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/TerminateJobFlows"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateJobFlowsResponse terminateJobFlows(Consumer<TerminateJobFlowsRequest.Builder> terminateJobFlowsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, EmrException {
        return terminateJobFlows(TerminateJobFlowsRequest.builder().applyMutation(terminateJobFlowsRequest).build());
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Updates the session policy attached to the user or group for the specified Amazon EMR Studio.
     * </p>
     *
     * @param updateStudioSessionMappingRequest
     * @return Result of the UpdateStudioSessionMapping operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.UpdateStudioSessionMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStudioSessionMappingResponse updateStudioSessionMapping(
            UpdateStudioSessionMappingRequest updateStudioSessionMappingRequest) throws InternalServerErrorException,
            InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The Amazon EMR Studio APIs are in preview release for Amazon EMR and are subject to change.
     * </p>
     * </note>
     * <p>
     * Updates the session policy attached to the user or group for the specified Amazon EMR Studio.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStudioSessionMappingRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateStudioSessionMappingRequest#builder()}
     * </p>
     *
     * @param updateStudioSessionMappingRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStudioSessionMappingInput.Builder} to create a
     *        request.
     * @return Result of the UpdateStudioSessionMapping operation returned by the service.
     * @throws InternalServerErrorException
     *         Indicates that an error occurred while processing the request and that the request was not completed.
     * @throws InvalidRequestException
     *         This exception occurs when there is something wrong with user input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws EmrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample EmrClient.UpdateStudioSessionMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/UpdateStudioSessionMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStudioSessionMappingResponse updateStudioSessionMapping(
            Consumer<UpdateStudioSessionMappingRequest.Builder> updateStudioSessionMappingRequest)
            throws InternalServerErrorException, InvalidRequestException, AwsServiceException, SdkClientException, EmrException {
        return updateStudioSessionMapping(UpdateStudioSessionMappingRequest.builder()
                .applyMutation(updateStudioSessionMappingRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("elasticmapreduce");
    }

    /**
     * Create an instance of {@link EmrWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link EmrWaiter}
     */
    default EmrWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
