/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EC2InstanceIdsToTerminateListCopier;
import software.amazon.awssdk.services.emr.model.ShrinkPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceGroupModifyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceGroupModifyConfig> {
    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupId").getter(InstanceGroupModifyConfig.getter(InstanceGroupModifyConfig::instanceGroupId)).setter(InstanceGroupModifyConfig.setter(Builder::instanceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(InstanceGroupModifyConfig.getter(InstanceGroupModifyConfig::instanceCount)).setter(InstanceGroupModifyConfig.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<List<String>> EC2_INSTANCE_IDS_TO_TERMINATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2InstanceIdsToTerminate").getter(InstanceGroupModifyConfig.getter(InstanceGroupModifyConfig::ec2InstanceIdsToTerminate)).setter(InstanceGroupModifyConfig.setter(Builder::ec2InstanceIdsToTerminate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceIdsToTerminate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ShrinkPolicy> SHRINK_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShrinkPolicy").getter(InstanceGroupModifyConfig.getter(InstanceGroupModifyConfig::shrinkPolicy)).setter(InstanceGroupModifyConfig.setter(Builder::shrinkPolicy)).constructor(ShrinkPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShrinkPolicy").build()}).build();
    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configurations").getter(InstanceGroupModifyConfig.getter(InstanceGroupModifyConfig::configurations)).setter(InstanceGroupModifyConfig.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_ID_FIELD, INSTANCE_COUNT_FIELD, EC2_INSTANCE_IDS_TO_TERMINATE_FIELD, SHRINK_POLICY_FIELD, CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceGroupId;
    private final Integer instanceCount;
    private final List<String> ec2InstanceIdsToTerminate;
    private final ShrinkPolicy shrinkPolicy;
    private final List<Configuration> configurations;

    private InstanceGroupModifyConfig(BuilderImpl builder) {
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceCount = builder.instanceCount;
        this.ec2InstanceIdsToTerminate = builder.ec2InstanceIdsToTerminate;
        this.shrinkPolicy = builder.shrinkPolicy;
        this.configurations = builder.configurations;
    }

    public final String instanceGroupId() {
        return this.instanceGroupId;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final boolean hasEc2InstanceIdsToTerminate() {
        return this.ec2InstanceIdsToTerminate != null && !(this.ec2InstanceIdsToTerminate instanceof SdkAutoConstructList);
    }

    public final List<String> ec2InstanceIdsToTerminate() {
        return this.ec2InstanceIdsToTerminate;
    }

    public final ShrinkPolicy shrinkPolicy() {
        return this.shrinkPolicy;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public final List<Configuration> configurations() {
        return this.configurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceIdsToTerminate() ? this.ec2InstanceIdsToTerminate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.shrinkPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupModifyConfig)) {
            return false;
        }
        InstanceGroupModifyConfig other = (InstanceGroupModifyConfig)obj;
        return Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.instanceCount(), other.instanceCount()) && this.hasEc2InstanceIdsToTerminate() == other.hasEc2InstanceIdsToTerminate() && Objects.equals(this.ec2InstanceIdsToTerminate(), other.ec2InstanceIdsToTerminate()) && Objects.equals(this.shrinkPolicy(), other.shrinkPolicy()) && this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceGroupModifyConfig").add("InstanceGroupId", (Object)this.instanceGroupId()).add("InstanceCount", (Object)this.instanceCount()).add("EC2InstanceIdsToTerminate", this.hasEc2InstanceIdsToTerminate() ? this.ec2InstanceIdsToTerminate() : null).add("ShrinkPolicy", (Object)this.shrinkPolicy()).add("Configurations", this.hasConfigurations() ? this.configurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceGroupId": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupId()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "EC2InstanceIdsToTerminate": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceIdsToTerminate()));
            }
            case "ShrinkPolicy": {
                return Optional.ofNullable(clazz.cast(this.shrinkPolicy()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroupModifyConfig, T> g) {
        return obj -> g.apply((InstanceGroupModifyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceGroupId;
        private Integer instanceCount;
        private List<String> ec2InstanceIdsToTerminate = DefaultSdkAutoConstructList.getInstance();
        private ShrinkPolicy shrinkPolicy;
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupModifyConfig model) {
            this.instanceGroupId(model.instanceGroupId);
            this.instanceCount(model.instanceCount);
            this.ec2InstanceIdsToTerminate(model.ec2InstanceIdsToTerminate);
            this.shrinkPolicy(model.shrinkPolicy);
            this.configurations(model.configurations);
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<String> getEc2InstanceIdsToTerminate() {
            if (this.ec2InstanceIdsToTerminate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2InstanceIdsToTerminate;
        }

        @Override
        public final Builder ec2InstanceIdsToTerminate(Collection<String> ec2InstanceIdsToTerminate) {
            this.ec2InstanceIdsToTerminate = EC2InstanceIdsToTerminateListCopier.copy(ec2InstanceIdsToTerminate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceIdsToTerminate(String ... ec2InstanceIdsToTerminate) {
            this.ec2InstanceIdsToTerminate(Arrays.asList(ec2InstanceIdsToTerminate));
            return this;
        }

        public final void setEc2InstanceIdsToTerminate(Collection<String> ec2InstanceIdsToTerminate) {
            this.ec2InstanceIdsToTerminate = EC2InstanceIdsToTerminateListCopier.copy(ec2InstanceIdsToTerminate);
        }

        public final ShrinkPolicy.Builder getShrinkPolicy() {
            return this.shrinkPolicy != null ? this.shrinkPolicy.toBuilder() : null;
        }

        @Override
        public final Builder shrinkPolicy(ShrinkPolicy shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy;
            return this;
        }

        public final void setShrinkPolicy(ShrinkPolicy.BuilderImpl shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy != null ? shrinkPolicy.build() : null;
        }

        public final List<Configuration.Builder> getConfigurations() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public InstanceGroupModifyConfig build() {
            return new InstanceGroupModifyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceGroupModifyConfig> {
        public Builder instanceGroupId(String var1);

        public Builder instanceCount(Integer var1);

        public Builder ec2InstanceIdsToTerminate(Collection<String> var1);

        public Builder ec2InstanceIdsToTerminate(String ... var1);

        public Builder shrinkPolicy(ShrinkPolicy var1);

        default public Builder shrinkPolicy(Consumer<ShrinkPolicy.Builder> shrinkPolicy) {
            return this.shrinkPolicy((ShrinkPolicy)((ShrinkPolicy.Builder)ShrinkPolicy.builder().applyMutation(shrinkPolicy)).build());
        }

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);
    }
}

