/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.IdentityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionMappingSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionMappingSummary> {
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StudioId").getter(SessionMappingSummary.getter(SessionMappingSummary::studioId)).setter(SessionMappingSummary.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioId").build()}).build();
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(SessionMappingSummary.getter(SessionMappingSummary::identityId)).setter(SessionMappingSummary.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<String> IDENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityName").getter(SessionMappingSummary.getter(SessionMappingSummary::identityName)).setter(SessionMappingSummary.setter(Builder::identityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityName").build()}).build();
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityType").getter(SessionMappingSummary.getter(SessionMappingSummary::identityTypeAsString)).setter(SessionMappingSummary.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()}).build();
    private static final SdkField<String> SESSION_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionPolicyArn").getter(SessionMappingSummary.getter(SessionMappingSummary::sessionPolicyArn)).setter(SessionMappingSummary.setter(Builder::sessionPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionPolicyArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(SessionMappingSummary.getter(SessionMappingSummary::creationTime)).setter(SessionMappingSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ID_FIELD, IDENTITY_ID_FIELD, IDENTITY_NAME_FIELD, IDENTITY_TYPE_FIELD, SESSION_POLICY_ARN_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String studioId;
    private final String identityId;
    private final String identityName;
    private final String identityType;
    private final String sessionPolicyArn;
    private final Instant creationTime;

    private SessionMappingSummary(BuilderImpl builder) {
        this.studioId = builder.studioId;
        this.identityId = builder.identityId;
        this.identityName = builder.identityName;
        this.identityType = builder.identityType;
        this.sessionPolicyArn = builder.sessionPolicyArn;
        this.creationTime = builder.creationTime;
    }

    public String studioId() {
        return this.studioId;
    }

    public String identityId() {
        return this.identityId;
    }

    public String identityName() {
        return this.identityName;
    }

    public IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public String identityTypeAsString() {
        return this.identityType;
    }

    public String sessionPolicyArn() {
        return this.sessionPolicyArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionMappingSummary)) {
            return false;
        }
        SessionMappingSummary other = (SessionMappingSummary)obj;
        return Objects.equals(this.studioId(), other.studioId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.identityName(), other.identityName()) && Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.sessionPolicyArn(), other.sessionPolicyArn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"SessionMappingSummary").add("StudioId", (Object)this.studioId()).add("IdentityId", (Object)this.identityId()).add("IdentityName", (Object)this.identityName()).add("IdentityType", (Object)this.identityTypeAsString()).add("SessionPolicyArn", (Object)this.sessionPolicyArn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StudioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "IdentityName": {
                return Optional.ofNullable(clazz.cast(this.identityName()));
            }
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "SessionPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.sessionPolicyArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionMappingSummary, T> g) {
        return obj -> g.apply((SessionMappingSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String studioId;
        private String identityId;
        private String identityName;
        private String identityType;
        private String sessionPolicyArn;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionMappingSummary model) {
            this.studioId(model.studioId);
            this.identityId(model.identityId);
            this.identityName(model.identityName);
            this.identityType(model.identityType);
            this.sessionPolicyArn(model.sessionPolicyArn);
            this.creationTime(model.creationTime);
        }

        public final String getStudioId() {
            return this.studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityName() {
            return this.identityName;
        }

        @Override
        public final Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        public final void setIdentityName(String identityName) {
            this.identityName = identityName;
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final String getSessionPolicyArn() {
            return this.sessionPolicyArn;
        }

        @Override
        public final Builder sessionPolicyArn(String sessionPolicyArn) {
            this.sessionPolicyArn = sessionPolicyArn;
            return this;
        }

        public final void setSessionPolicyArn(String sessionPolicyArn) {
            this.sessionPolicyArn = sessionPolicyArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public SessionMappingSummary build() {
            return new SessionMappingSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionMappingSummary> {
        public Builder studioId(String var1);

        public Builder identityId(String var1);

        public Builder identityName(String var1);

        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder sessionPolicyArn(String var1);

        public Builder creationTime(Instant var1);
    }
}

