/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.IdentityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStudioSessionMappingRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, GetStudioSessionMappingRequest> {
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StudioId").getter(GetStudioSessionMappingRequest.getter(GetStudioSessionMappingRequest::studioId)).setter(GetStudioSessionMappingRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioId").build()}).build();
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(GetStudioSessionMappingRequest.getter(GetStudioSessionMappingRequest::identityId)).setter(GetStudioSessionMappingRequest.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<String> IDENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityName").getter(GetStudioSessionMappingRequest.getter(GetStudioSessionMappingRequest::identityName)).setter(GetStudioSessionMappingRequest.setter(Builder::identityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityName").build()}).build();
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityType").getter(GetStudioSessionMappingRequest.getter(GetStudioSessionMappingRequest::identityTypeAsString)).setter(GetStudioSessionMappingRequest.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ID_FIELD, IDENTITY_ID_FIELD, IDENTITY_NAME_FIELD, IDENTITY_TYPE_FIELD));
    private final String studioId;
    private final String identityId;
    private final String identityName;
    private final String identityType;

    private GetStudioSessionMappingRequest(BuilderImpl builder) {
        super(builder);
        this.studioId = builder.studioId;
        this.identityId = builder.identityId;
        this.identityName = builder.identityName;
        this.identityType = builder.identityType;
    }

    public String studioId() {
        return this.studioId;
    }

    public String identityId() {
        return this.identityId;
    }

    public String identityName() {
        return this.identityName;
    }

    public IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public String identityTypeAsString() {
        return this.identityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStudioSessionMappingRequest)) {
            return false;
        }
        GetStudioSessionMappingRequest other = (GetStudioSessionMappingRequest)((Object)obj);
        return Objects.equals(this.studioId(), other.studioId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.identityName(), other.identityName()) && Objects.equals(this.identityTypeAsString(), other.identityTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetStudioSessionMappingRequest").add("StudioId", (Object)this.studioId()).add("IdentityId", (Object)this.identityId()).add("IdentityName", (Object)this.identityName()).add("IdentityType", (Object)this.identityTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StudioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "IdentityName": {
                return Optional.ofNullable(clazz.cast(this.identityName()));
            }
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStudioSessionMappingRequest, T> g) {
        return obj -> g.apply((GetStudioSessionMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String studioId;
        private String identityId;
        private String identityName;
        private String identityType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStudioSessionMappingRequest model) {
            super(model);
            this.studioId(model.studioId);
            this.identityId(model.identityId);
            this.identityName(model.identityName);
            this.identityType(model.identityType);
        }

        public final String getStudioId() {
            return this.studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityName() {
            return this.identityName;
        }

        @Override
        public final Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        public final void setIdentityName(String identityName) {
            this.identityName = identityName;
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStudioSessionMappingRequest build() {
            return new GetStudioSessionMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStudioSessionMappingRequest> {
        public Builder studioId(String var1);

        public Builder identityId(String var1);

        public Builder identityName(String var1);

        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

