/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.ExecutionEngineConfig;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartNotebookExecutionRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, StartNotebookExecutionRequest> {
    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EditorId").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::editorId)).setter(StartNotebookExecutionRequest.setter(Builder::editorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()}).build();
    private static final SdkField<String> RELATIVE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelativePath").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::relativePath)).setter(StartNotebookExecutionRequest.setter(Builder::relativePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativePath").build()}).build();
    private static final SdkField<String> NOTEBOOK_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookExecutionName").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::notebookExecutionName)).setter(StartNotebookExecutionRequest.setter(Builder::notebookExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionName").build()}).build();
    private static final SdkField<String> NOTEBOOK_PARAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookParams").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::notebookParams)).setter(StartNotebookExecutionRequest.setter(Builder::notebookParams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookParams").build()}).build();
    private static final SdkField<ExecutionEngineConfig> EXECUTION_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionEngine").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::executionEngine)).setter(StartNotebookExecutionRequest.setter(Builder::executionEngine)).constructor(ExecutionEngineConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEngine").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::serviceRole)).setter(StartNotebookExecutionRequest.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceSecurityGroupId").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::notebookInstanceSecurityGroupId)).setter(StartNotebookExecutionRequest.setter(Builder::notebookInstanceSecurityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceSecurityGroupId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartNotebookExecutionRequest.getter(StartNotebookExecutionRequest::tags)).setter(StartNotebookExecutionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITOR_ID_FIELD, RELATIVE_PATH_FIELD, NOTEBOOK_EXECUTION_NAME_FIELD, NOTEBOOK_PARAMS_FIELD, EXECUTION_ENGINE_FIELD, SERVICE_ROLE_FIELD, NOTEBOOK_INSTANCE_SECURITY_GROUP_ID_FIELD, TAGS_FIELD));
    private final String editorId;
    private final String relativePath;
    private final String notebookExecutionName;
    private final String notebookParams;
    private final ExecutionEngineConfig executionEngine;
    private final String serviceRole;
    private final String notebookInstanceSecurityGroupId;
    private final List<Tag> tags;

    private StartNotebookExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.editorId = builder.editorId;
        this.relativePath = builder.relativePath;
        this.notebookExecutionName = builder.notebookExecutionName;
        this.notebookParams = builder.notebookParams;
        this.executionEngine = builder.executionEngine;
        this.serviceRole = builder.serviceRole;
        this.notebookInstanceSecurityGroupId = builder.notebookInstanceSecurityGroupId;
        this.tags = builder.tags;
    }

    public String editorId() {
        return this.editorId;
    }

    public String relativePath() {
        return this.relativePath;
    }

    public String notebookExecutionName() {
        return this.notebookExecutionName;
    }

    public String notebookParams() {
        return this.notebookParams;
    }

    public ExecutionEngineConfig executionEngine() {
        return this.executionEngine;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public String notebookInstanceSecurityGroupId() {
        return this.notebookInstanceSecurityGroupId;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.editorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookParams());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNotebookExecutionRequest)) {
            return false;
        }
        StartNotebookExecutionRequest other = (StartNotebookExecutionRequest)((Object)obj);
        return Objects.equals(this.editorId(), other.editorId()) && Objects.equals(this.relativePath(), other.relativePath()) && Objects.equals(this.notebookExecutionName(), other.notebookExecutionName()) && Objects.equals(this.notebookParams(), other.notebookParams()) && Objects.equals(this.executionEngine(), other.executionEngine()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.notebookInstanceSecurityGroupId(), other.notebookInstanceSecurityGroupId()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"StartNotebookExecutionRequest").add("EditorId", (Object)this.editorId()).add("RelativePath", (Object)this.relativePath()).add("NotebookExecutionName", (Object)this.notebookExecutionName()).add("NotebookParams", (Object)this.notebookParams()).add("ExecutionEngine", (Object)this.executionEngine()).add("ServiceRole", (Object)this.serviceRole()).add("NotebookInstanceSecurityGroupId", (Object)this.notebookInstanceSecurityGroupId()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EditorId": {
                return Optional.ofNullable(clazz.cast(this.editorId()));
            }
            case "RelativePath": {
                return Optional.ofNullable(clazz.cast(this.relativePath()));
            }
            case "NotebookExecutionName": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutionName()));
            }
            case "NotebookParams": {
                return Optional.ofNullable(clazz.cast(this.notebookParams()));
            }
            case "ExecutionEngine": {
                return Optional.ofNullable(clazz.cast(this.executionEngine()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "NotebookInstanceSecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceSecurityGroupId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartNotebookExecutionRequest, T> g) {
        return obj -> g.apply((StartNotebookExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String editorId;
        private String relativePath;
        private String notebookExecutionName;
        private String notebookParams;
        private ExecutionEngineConfig executionEngine;
        private String serviceRole;
        private String notebookInstanceSecurityGroupId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartNotebookExecutionRequest model) {
            super(model);
            this.editorId(model.editorId);
            this.relativePath(model.relativePath);
            this.notebookExecutionName(model.notebookExecutionName);
            this.notebookParams(model.notebookParams);
            this.executionEngine(model.executionEngine);
            this.serviceRole(model.serviceRole);
            this.notebookInstanceSecurityGroupId(model.notebookInstanceSecurityGroupId);
            this.tags(model.tags);
        }

        public final String getEditorId() {
            return this.editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        public final String getRelativePath() {
            return this.relativePath;
        }

        @Override
        public final Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public final void setRelativePath(String relativePath) {
            this.relativePath = relativePath;
        }

        public final String getNotebookExecutionName() {
            return this.notebookExecutionName;
        }

        @Override
        public final Builder notebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
            return this;
        }

        public final void setNotebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
        }

        public final String getNotebookParams() {
            return this.notebookParams;
        }

        @Override
        public final Builder notebookParams(String notebookParams) {
            this.notebookParams = notebookParams;
            return this;
        }

        public final void setNotebookParams(String notebookParams) {
            this.notebookParams = notebookParams;
        }

        public final ExecutionEngineConfig.Builder getExecutionEngine() {
            return this.executionEngine != null ? this.executionEngine.toBuilder() : null;
        }

        @Override
        public final Builder executionEngine(ExecutionEngineConfig executionEngine) {
            this.executionEngine = executionEngine;
            return this;
        }

        public final void setExecutionEngine(ExecutionEngineConfig.BuilderImpl executionEngine) {
            this.executionEngine = executionEngine != null ? executionEngine.build() : null;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getNotebookInstanceSecurityGroupId() {
            return this.notebookInstanceSecurityGroupId;
        }

        @Override
        public final Builder notebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId) {
            this.notebookInstanceSecurityGroupId = notebookInstanceSecurityGroupId;
            return this;
        }

        public final void setNotebookInstanceSecurityGroupId(String notebookInstanceSecurityGroupId) {
            this.notebookInstanceSecurityGroupId = notebookInstanceSecurityGroupId;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNotebookExecutionRequest build() {
            return new StartNotebookExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartNotebookExecutionRequest> {
        public Builder editorId(String var1);

        public Builder relativePath(String var1);

        public Builder notebookExecutionName(String var1);

        public Builder notebookParams(String var1);

        public Builder executionEngine(ExecutionEngineConfig var1);

        default public Builder executionEngine(Consumer<ExecutionEngineConfig.Builder> executionEngine) {
            return this.executionEngine((ExecutionEngineConfig)((ExecutionEngineConfig.Builder)ExecutionEngineConfig.builder().applyMutation(executionEngine)).build());
        }

        public Builder serviceRole(String var1);

        public Builder notebookInstanceSecurityGroupId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

