/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.services.emr.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HadoopStepConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HadoopStepConfig> {
    private static final SdkField<String> JAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Jar").getter(HadoopStepConfig.getter(HadoopStepConfig::jar)).setter(HadoopStepConfig.setter(Builder::jar)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jar").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Properties").getter(HadoopStepConfig.getter(HadoopStepConfig::properties)).setter(HadoopStepConfig.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> MAIN_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MainClass").getter(HadoopStepConfig.getter(HadoopStepConfig::mainClass)).setter(HadoopStepConfig.setter(Builder::mainClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MainClass").build()}).build();
    private static final SdkField<List<String>> ARGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Args").getter(HadoopStepConfig.getter(HadoopStepConfig::args)).setter(HadoopStepConfig.setter(Builder::args)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JAR_FIELD, PROPERTIES_FIELD, MAIN_CLASS_FIELD, ARGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jar;
    private final Map<String, String> properties;
    private final String mainClass;
    private final List<String> args;

    private HadoopStepConfig(BuilderImpl builder) {
        this.jar = builder.jar;
        this.properties = builder.properties;
        this.mainClass = builder.mainClass;
        this.args = builder.args;
    }

    public String jar() {
        return this.jar;
    }

    public boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String mainClass() {
        return this.mainClass;
    }

    public boolean hasArgs() {
        return this.args != null && !(this.args instanceof SdkAutoConstructList);
    }

    public List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jar());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.mainClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.args());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HadoopStepConfig)) {
            return false;
        }
        HadoopStepConfig other = (HadoopStepConfig)obj;
        return Objects.equals(this.jar(), other.jar()) && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.mainClass(), other.mainClass()) && Objects.equals(this.args(), other.args());
    }

    public String toString() {
        return ToString.builder((String)"HadoopStepConfig").add("Jar", (Object)this.jar()).add("Properties", this.properties()).add("MainClass", (Object)this.mainClass()).add("Args", this.args()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Jar": {
                return Optional.ofNullable(clazz.cast(this.jar()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "MainClass": {
                return Optional.ofNullable(clazz.cast(this.mainClass()));
            }
            case "Args": {
                return Optional.ofNullable(clazz.cast(this.args()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HadoopStepConfig, T> g) {
        return obj -> g.apply((HadoopStepConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jar;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();
        private String mainClass;
        private List<String> args = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HadoopStepConfig model) {
            this.jar(model.jar);
            this.properties(model.properties);
            this.mainClass(model.mainClass);
            this.args(model.args);
        }

        public final String getJar() {
            return this.jar;
        }

        @Override
        public final Builder jar(String jar) {
            this.jar = jar;
            return this;
        }

        public final void setJar(String jar) {
            this.jar = jar;
        }

        public final Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = StringMapCopier.copy(properties);
            return this;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = StringMapCopier.copy(properties);
        }

        public final String getMainClass() {
            return this.mainClass;
        }

        @Override
        public final Builder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public final void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public final Collection<String> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = StringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = StringListCopier.copy(args);
        }

        public HadoopStepConfig build() {
            return new HadoopStepConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HadoopStepConfig> {
        public Builder jar(String var1);

        public Builder properties(Map<String, String> var1);

        public Builder mainClass(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

